/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	dme_pmax_sii_ram.h,v $
 * Revision 1.1.3.2  92/02/27  16:02:09  cam_proj_Janet_Schank
 * 	"bsubmitted from shared SB"
 * 
 * Revision 1.1.2.4  92/01/31  11:17:49  Janet_Schank
 * 	Made 64bit modifications
 * 	[92/01/31  09:47:39  Janet_Schank]
 * 
 * Revision 1.1.2.3  92/01/28  18:26:48  Janet_Schank
 * 	Merged in changes from LA.
 * 	[92/01/28  18:07:06  Janet_Schank]
 * 
 * Revision 1.1.2.2  92/01/17  13:21:22  Janet_Schank
 * 	CAM support added
 * 	[92/01/17  11:17:05  Janet_Schank]
 * 
 * $EndLog$
 */
/*
 * @(#)$RCSfile: dme_pmax_sii_ram.h,v $ $Revision: 1.1.3.2 $ (DEC) $Date: 92/02/27 16:02:09 $
 */
#ifndef __DME_PMAX_SII_RAM_H__

#define __DME_PMAX_SII_RAM_H__

/* ---------------------------------------------------------------------- */
/* dme_pmax_sii_94_ram.h	Version 1.00		July 20, 1991 */

/*  This file contains the definitions and data structures needed by
    the PMAX DME related files.

Modification History

	Version	  Date		Who	Reason

	1.00    07/20/90        rps	Created this file.
*/

typedef struct dme_pmax_struct 
  {
    /*
     * These pointers contain the free DMA segments available to the
     * the SIM DME.
     *
     * Allocate pointers to each of the Active Segment structure.
     * The dme_XXkb_flink points at the first free segment and
     * dme_XXkb_blink points at the last free segment. The list
     * is empty if the blink points at the flink.
     */
    SEGMENT_ELEMENT *head_1kb;
    SEGMENT_ELEMENT *tail_1kb;
    SEGMENT_ELEMENT *head_4kb;
    SEGMENT_ELEMENT *tail_4kb;
    SEGMENT_ELEMENT *head_8kb;
    SEGMENT_ELEMENT *tail_8kb;
    SEGMENT_ELEMENT *head_16kb;
    SEGMENT_ELEMENT *tail_16kb;

    void*	SVAPTE;		/* System Virtual address of first PTE */
    				/* used to double map P0 Virt Addresses*/
    void*	SVA;		/* S0 address used to dbl mapped buffer*/

  } DME_PMAX_STRUCT;

#endif

