/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	vbareg.h,v $
 * Revision 1.1.3.4  92/05/20  15:42:44  Stuart_Hollander
 * 	Added byte swap mode "VME_BS_SIZE_DEPENDENT," same as VME_BS_WORD.
 * 
 * Revision 1.1.3.3  92/02/14  13:31:49  Stuart_Hollander
 * 	Added defines for vme AM bits, user/supervisor, data/prog
 * 	Removed defines unused or moved elsewhere by generic VME interface
 * 	[92/02/10  22:05:51  Stuart_Hollander]
 * 
 * Revision 1.1.3.2  91/11/20  14:05:26  Hal_Project
 * 	Moved from dec/io/...; pool reorg
 * 	[91/11/18  08:55:36  Donald_Dutile]
 * 
 * Revision 4.2.2.2  91/10/23  15:04:02  William_Burns
 * 	Merge from ODE/TIN: revision 3.2.9.2
 * 	date: 91/10/17 21:14:56;  author: devrcs;  state: Exp;  lines added/del: 2/2
 * 	sccs rev: 3.3;  orig date: 91/10/02 16:23:42;  orig author: fred
 * 	Fred Canter - warnings.
 * 	[91/10/23  12:08:21  William_Burns]
 * 
 * Revision 4.2  91/09/19  23:23:25  devbld
 * 	Adding ODE Headers
 * 
 * $EndLog$
 */
/*	
 *	@(#)$RCSfile: vbareg.h,v $ $Revision: 1.1.3.4 $ (DEC) $Date: 92/05/20 15:42:44 $
 */ 
/*
 */
/*
 * OSF/1 Release 1.0
 */
/* 
 * derived from vbareg.h	4.2	(ULTRIX)	1/23/9
 */

/*
 * Abstract:
 *	This module contains the definitions for general VMEbus host
 *	modules.
 *
 * Revision History
 *
 *	05-Jun-1991	Mark Parenti
 *		Add definition of vbahd entry in bus structure.
 *
 *	Above this line is OSF/1
 *	--------------------------------------------------------------------
 *
 *	22-Jan-1990	Mark Parenti
 *		Add asc field to vbadata structure.  Selects if DMA PMRs
 *		are mapped to 1st or 2nd GB of VMEbus address space.
 *
 *	14-Nov-1989	Mark Parenti (map)
 *		Original Version
 */

/*	Definitions for flags parameter to vbasetup()	*/

#define	VME_A16		0x00000000	/* A16 Request			*/
#define	VME_A24		0x00000001	/* A24 Request			*/
#define	VME_A32		0x00000002	/* A32 Request			*/
#define	VME_D08		0x00000000	/* D08 Data Size		*/
#define	VME_D16		0x00000010	/* D16 Data Size		*/
#define	VME_D32		0x00000020	/* D32 Data Size		*/
#define	VME_USER	0x00000040	/* Supervisory Access Mode (if 0)*/
					/* User Access Mode (if 1)	*/
#define	VME_DATA	0x00000004	/* Prog Access Mode (if 0)	*/
					/* Data Access Mode (if 1)	*/
#define	VME_AM		0x0000FF00	/* Addr Modifier bits (if non-zero)*/
					/* Override other bits. */
#define	VME_AM_SHIFT	8		/* Addr Modifier bits shift count */
#define	VME_BS_MASK	0x00030000	/* Byte Swap mask		*/
#define	VME_BS_SHIFT	16		/* Byte Swap shift count	*/
#define	VME_ASPACE_MASK	0x00000003	/* Address space mask		*/
#define	VME_ASIZE_MASK	0x00000030	/* Data space mask		*/
#define	VME_ASIZE_SHIFT	4		/* Shift for array index	*/
#define	VME_ADD_MASK	(VME_A16 | VME_A24 | VME_A32)


#define	vbahd		private[4]


/************************************************************************/
/* The following values are used for the flags parameter of the		*/
/* vbasetup() and vballoc() routines. They may be combined by using the	*/
/* C-language bit-wise or ( | ).					*/
/************************************************************************/
#define	VMEA16D08	(VME_A16 | VME_D08)
#define	VMEA16D16	(VME_A16 | VME_D16)
#define	VMEA16D32	(VME_A16 | VME_D32)

#define	VMEA24D08	(VME_A24 | VME_D08)
#define	VMEA24D16	(VME_A24 | VME_D16)
#define	VMEA24D32	(VME_A24 | VME_D32)

#define	VMEA32D08	(VME_A32 | VME_D08)
#define	VMEA32D16	(VME_A32 | VME_D16)
#define	VMEA32D32	(VME_A32 | VME_D32)

#define	VME_DMA		0x02000000	/* Need DMA registers		*/
#define	VME_RESERV	0x04000000	/* Reserve VME Address space	*/
#define	VME_CANTWAIT	0x01000000	/* Must have it now		*/
#define	VME_BS_NOSWAP	0x00000000	/* No Byte Swap			*/
#define	VME_RMW_ENAB	0x00100000	/* Enable RMW (XVIB ONLY)	*/
#define	VME_BS_BYTE	0x00010000	/* Byte Swap Bytes		*/
#define	VME_BS_WORD	0x00020000	/* Byte Swap Words		*/
/* some adapters may treat Byte Swap Words as a transaction Size Dependent swap instead */
#define	VME_BS_SIZE_DEPENDENT	0x00020000 /* Byte Swap Dependent upon transaction size	*/
#define	VME_BS_LWORD	0x00030000	/* Byte Swap Longwords		*/
