/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	ipc_signal.h,v $
 * Revision 4.2  91/09/19  22:25:00  devbld
 * Adding ODE Headers
 * 
 * $EndLog$
 */
/*	
 *	@(#)$RCSfile: ipc_signal.h,v $ $Revision: 4.2 $ (DEC) $Date: 91/09/19 22:25:00 $
 */ 
/*
 */
/*
 * (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/* 
 * Mach Operating System
 * Copyright (c) 1989 Carnegie-Mellon University
 * Copyright (c) 1988 Carnegie-Mellon University
 * Copyright (c) 1987 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * OSF/1 Release 1.0
 */

#ifndef	_KERN_IPC_SIGNAL_H_
#define _KERN_IPC_SIGNAL_H_

#include <mach_ipc_sighack.h>

#if	MACH_IPC_SIGHACK

#include <mach/boolean.h>
#include <kern/task.h>
#include <kern/macro_help.h>
#include <sys/signal.h>
#include <sys/proc.h>

#define PSIGNAL(task, emerg) \
	MACRO_BEGIN						\
	if ((task)->ipc_intr_msg)				\
		psignal(&proc[(task)->proc_index],		\
			(emerg) ? SIGEMSG : SIGMSG);		\
	MACRO_END

#else	/* MACH_IPC_SIGHACK */

#define PSIGNAL(task, emerg)

#endif	/* MACH_IPC_SIGHACK */

#endif	/* _KERN_IPC_SIGNAL_H_ */
