/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	parallel.h,v $
 * Revision 4.2.2.2  92/02/14  14:11:57  Ronald_Widyono
 * 	"Fix circular include file problem"
 * 
 * Revision 4.2.1.2  92/02/13  12:27:30  Ronald_Widyono
 * 	Remove references to current_thread from the preemption_point_safe macro.
 * 
 * Revision 4.2  91/09/19  22:26:31  devbld
 * 	Adding ODE Headers
 * 
 * $EndLog$
 */
/*	
 *	@(#)$RCSfile: parallel.h,v $ $Revision: 4.2.2.2 $ (DEC) $Date: 92/02/14 14:11:57 $
 */ 
/*
 */
/*
 * (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/* 
 * Mach Operating System
 * Copyright (c) 1989 Carnegie-Mellon University
 * Copyright (c) 1988 Carnegie-Mellon University
 * Copyright (c) 1987 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */

/*
 * OSF/1 Release 1.0
 */

/*
 *	kern/parallel.h
 *
 *	Revision History:
 *
 * 5-May-91	Ron Widyono
 *	Incorporate run-time option for kernel preemption (rt_preempt_enabled).
 *
 * 6-Apr-91	Ron Widyono
 *	Track unix_master/unix_release calls for preemption points.  Preemption
 *	point on unix_release() and unix_release_force().  Conditionalized
 *	by RT_PREEMPT.
 *
 */

#ifndef	_KERN_PARALLEL_H_
#define _KERN_PARALLEL_H_

#include <cpus.h>
#include <rt_preempt.h>
#include <rt_preempt_debug.h>

#if	NCPUS > 1

#define unix_master()  _unix_master()
#define unix_release() _unix_release()
#define unix_release_force()	_unix_release_force()
#define unix_reset()   _unix_reset()
extern void _unix_master(), _unix_release(), _unix_release_force(), 
	    _unix_reset();

#elif	!RT_PREEMPT

#define unix_master()
#define unix_release()
#define unix_release_force()
#define unix_reset()

#else	/* !RT_PREEMPT */

#include <kern/thread.h>
#include <sys/preempt.h>
#include <kern/processor.h>

extern int rt_preempt_enabled;
#if	RT_PREEMPT_DEBUG
extern int rt_preempt_funnel;
#endif

#define unix_master()	{						\
	if (rt_preempt_enabled)						\
	    current_thread()->unix_lock++;				\
}

#define unix_release() {						\
	if (rt_preempt_enabled) {					\
	    if ((--current_thread()->unix_lock) < 0) {			\
		preemption_point_safe(rt_preempt_funnel); \
	    }								\
	}								\
}

#define unix_release_force() {						\
	if (rt_preempt_enabled) {					\
	    current_thread()->unix_lock = -1;				\
	    preemption_point_safe(rt_preempt_funnel);			\
	}								\
}

#define unix_reset() {							\
	if (rt_preempt_enabled)						\
	    if (current_thread()->unix_lock != -1)			\
		current_thread()->unix_lock = 0;			\
}

#endif	/* NCPUS > 1 */

#endif	/* _KERN_PARALLEL_H_ */
