/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	mig_errors.h,v $
 * Revision 4.2  91/09/19  22:35:01  devbld
 * Adding ODE Headers
 * 
 * $EndLog$
 */
/*	
 *	@(#)$RCSfile: mig_errors.h,v $ $Revision: 4.2 $ (DEC) $Date: 91/09/19 22:35:01 $
 */ 
/*
 */
/*
 * (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/* 
 * Mach Operating System
 * Copyright (c) 1989 Carnegie-Mellon University
 * Copyright (c) 1988 Carnegie-Mellon University
 * Copyright (c) 1987 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * OSF/1 Release 1.0
 */
/*
 * Mach Interface Generator errors
 *
 */

#ifndef	_MACH_MIG_ERRORS_H_
#define _MACH_MIG_ERRORS_H_

#include <mach/kern_return.h>
#include <mach/message.h>

#define MIG_TYPE_ERROR		-300		/* Type check failure */
#define MIG_REPLY_MISMATCH	-301		/* Wrong return message ID */
#define MIG_REMOTE_ERROR	-302		/* Server detected error */
#define MIG_BAD_ID		-303		/* Bad message ID */
#define MIG_BAD_ARGUMENTS	-304		/* Server found wrong arguments */
#define MIG_NO_REPLY		-305		/* Server shouldn't reply */
#define MIG_EXCEPTION		-306		/* Server raised exception */
#define MIG_ARRAY_TOO_LARGE	-307		/* User specified array not large enough
						   to hold returned array */

typedef struct {
	msg_header_t	Head;
	msg_type_t	RetCodeType;
	kern_return_t	RetCode;
} death_pill_t;

typedef struct mig_symtab {
	char	*ms_routine_name;
	int	ms_routine_number;
#ifdef	hc
	void
#else
	int
#endif
		(*ms_routine)();
} mig_symtab_t;

#endif	/* _MACH_MIG_ERRORS_H_ */
