/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	pmap_clnt.h,v $
 * Revision 1.1.2.2  92/02/26  15:45:16  Charles_Briggs
 * 	From ONC reference port.
 * 	[92/02/21  08:42:59  Charles_Briggs]
 * 
 * $EndLog$
 */
/*
 * @(#)$RCSfile: pmap_clnt.h,v $ $Revision: 1.1.2.2 $ (DEC) $Date: 92/02/26 15:45:16 $
 */
/*	@(#)pmap_clnt.h	1.2 90/07/17 4.1NFSSRC SMI	*/

/* 
 * Copyright (c) 1990 by Sun Microsystems, Inc.
 *	@(#)pmap_clnt.h 1.11 88/02/08 SMI
 */


/*
 * pmap_clnt.h
 * Supplies C routines to get to portmap services.
 */

/*
 * Usage:
 *	success = pmap_set(program, version, protocol, port);
 *	success = pmap_unset(program, version);
 *	port = pmap_getport(address, program, version, protocol);
 *	head = pmap_getmaps(address);
 *	clnt_stat = pmap_rmtcall(address, program, version, procedure,
 *		xdrargs, argsp, xdrres, resp, tout, port_ptr)
 *		(works for udp only.) 
 * 	clnt_stat = clnt_broadcast(program, version, procedure,
 *		xdrargs, argsp,	xdrres, resp, eachresult)
 *		(like pmap_rmtcall, except the call is broadcasted to all
 *		locally connected nets.  For each valid response received,
 *		the procedure eachresult is called.  Its form is:
 *	done = eachresult(resp, raddr)
 *		bool_t done;
 *		caddr_t resp;
 *		struct sockaddr_in raddr;
 *		where resp points to the results of the call and raddr is the
 *		address if the responder to the broadcast.
 */

#ifndef _rpc_pmap_clnt_h
#define	_rpc_pmap_clnt_h

extern bool_t		pmap_set();
extern bool_t		pmap_unset();
extern struct pmaplist	*pmap_getmaps();
enum clnt_stat		pmap_rmtcall();
enum clnt_stat		clnt_broadcast();
extern u_short		pmap_getport();

#endif /*!_rpc_pmap_clnt_h*/
