/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	s5ino.h,v $
 * Revision 4.2  91/09/19  22:52:03  devbld
 * Adding ODE Headers
 * 
 * $EndLog$
 */
/*	
 *	@(#)$RCSfile: s5ino.h,v $ $Revision: 4.2 $ (DEC) $Date: 91/09/19 22:52:03 $
 */ 
/*
 */
/*
 * (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/*
 * OSF/1 Release 1.0
 */


#ifndef	_S5_INO_H_
#define _S5_INO_H_

/* Inode structure as it appears on a disk block. */

struct s5dinode
{
	ushort  di_mode;	/* mode and type of file */
	short	di_nlink;    	/* number of links to file */
	ushort	di_uid;      	/* owner's user id */
	ushort	di_gid;      	/* owner's group id */
	off_t	di_size;     	/* number of bytes in file */
	char  	di_addr[40];	/* disk block addresses */
	time_t	di_atime;   	/* time last accessed */
	time_t	di_mtime;   	/* time last modified */
	time_t	di_ctime;   	/* time created */
};

/*
 * the 40 address bytes:
 *	39 used; 13 addresses
 *	of 3 bytes each.
 */
#endif	/* _S5_INO_H */
