/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	str_proto.h,v $
 * Revision 4.2  91/09/19  22:54:36  devbld
 * Adding ODE Headers
 * 
 * $EndLog$
 */
/*
 *    @(#)$RCSfile: str_proto.h,v $ $Revision: 4.2 $ (DEC) $Date: 91/09/19 22:54:36 $
 */

/*
 */

/*
 * (c) Copyright 1990, 1991, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/*
 * OSF/1 Release 1.0.1
 */

#ifdef _NO_PROTO

extern	int		dcookie_set_stht();
extern	int		dcookie_to_dindex();
extern	char *		dcookie_to_name();
extern	SQHP		dcookie_to_osqh();
extern	STHTP		dcookie_to_stht();
extern	struct dmodsw *	dcookie_to_dmp();
extern	int		dindex_set_stht();
extern	int		dindex_set_str();
extern	char *		dindex_to_name();
extern	STHTP		dindex_to_stht();
extern	struct streamtab * dindex_to_str();
extern	int		dmodsw_install();
extern	int		dmodsw_remove();
extern	int		dname_to_dcookie();
extern	int		dname_to_dindex();
extern	struct streamtab * dname_to_str();
extern	struct streamtab * dqinfo_to_str();
extern	int		fmodsw_install();
extern	int		fmodsw_move();
extern	int		fmodsw_remove();
extern	struct streamtab * fname_to_str();
extern	void		get_module_names();
extern	char *		qinfo_to_name();
extern	SQHP		sqh_get_parent();
extern	SQHP		sqh_set_parent();

#else

extern	int		dcookie_set_stht(int, STHTP);
extern	int		dcookie_to_dindex(int);
extern	char *		dcookie_to_name(int);
extern	SQHP		dcookie_to_osqh(int);
extern	STHTP		dcookie_to_stht(int);
extern	struct dmodsw *	dcookie_to_dmp(int);
extern	int		dindex_set_stht(int, STHTP);
extern	int		dindex_set_str(int, struct streamtab *);
extern	char *		dindex_to_name(int);
extern	STHTP		dindex_to_stht(int);
extern	struct streamtab * dindex_to_str(int);
extern	int dmodsw_install(char *, struct streamtab *, STHTP, int, SQHP, int);
extern	int		dmodsw_remove(char *);
extern	int		dname_to_dcookie(char *);
extern	int		dname_to_dindex(char *);
extern	struct streamtab * dname_to_str(char *);
extern	struct streamtab * dqinfo_to_str(struct qinit *);
extern	int		fmodsw_install(char *, struct streamtab *, int, SQHP);
extern	int		fmodsw_move(char *, char *);
extern	int		fmodsw_remove(char *);
extern	struct streamtab * fname_to_str(char *);
extern	void		get_module_names(struct msgb *);
extern	char *		qinfo_to_name(struct qinit);
extern	SQHP		sqh_get_parent(queue_t *, struct streamtab *);
extern	SQHP		sqh_set_parent(queue_t *, struct streamtab *);

#endif

/*
 * stht.c
 */

#ifdef _NO_PROTO

extern	int		stht_free();
extern	STHP		sth_get_sth();
extern	int		sth_fd_to_sth();
extern	int		sth_set_sth();
extern	STHTP		stht_alloc();

#else

extern	int		stht_free(dev_t);
extern	STHP		sth_get_sth(dev_t);
extern	int		sth_fd_to_sth(int, STHPP);
extern	int		sth_set_sth(dev_t, STHP);
extern	STHTP		stht_alloc(void);

#endif

/*
 * str_config.c
 */
extern	void	str_config();

/*
 * str_tty.c
 */
#ifdef	_NO_PROTO

extern	void		sth_ttyopen();
extern	void		sth_ttyclose();
extern	int		sth_tiocsctty();
extern	void		sth_pgsignal();

#else

extern	void		sth_ttyopen(STHP);
extern	void		sth_ttyclose(STHP);
extern	int		sth_tiocsctty(STHP);
extern	void		sth_pgsignal(STHP, int);

#endif

/*
 * str_env.c
 */

#ifdef _NO_PROTO

extern	void		delay();
extern	void		cmn_err();
extern	void		mapinit();
extern	caddr_t		malloc();
extern	void		mfree();
extern	ulong		vtop();
extern	time_t		streams_time();
extern	time_t		streams_lbolt();
extern	void		streams_lbolt_init();
extern	void		str_to_init();
extern	void		streams_untimeout();
extern	int		streams_timeout();
extern	int		streams_sleep();

#else

extern	void		delay(int);
extern	void		cmn_err(int, char *, ...);
extern	void		mapinit(struct map *, int);
extern	caddr_t		malloc(struct map *, size);
extern	void		mfree(struct map *, long, long);
extern	ulong 		vtop(ulong, int);
extern	time_t		streams_time(void);
extern	time_t		streams_lbolt(void);
extern	void		streams_lbolt_init(void);
extern	void		str_to_init(void);
extern	void		streams_untimeout(int);
extern	int		streams_timeout(pfi_t, int, int);
extern	int		streams_sleep(caddr_t, int);

#endif

/*
 * str_filesys.c
 */

#ifdef _NO_PROTO

extern	int	 	fd_to_cookie();
extern	int		fd_alloc();
extern	void		cookie_destroy();
extern	int		fd_to_dev();

#else

extern	int		fd_to_cookie(int, struct file_cookie *);
extern	int		fd_alloc(struct file_cookie *, int *);
extern	void		cookie_destroy(struct file_cookie *);
extern	int		fd_to_dev(int, dev_t *);

#endif

/*
 * str_init.c
 */
extern	int		pse_init();

/*
 *	str_memory.c
 */

#ifdef	_NO_PROTO

extern	caddr_t		he_alloc();
extern	void		he_free();
extern	caddr_t		he_realloc();
extern	int		bufcall_configure();
extern	int		bufcall_init();
extern	int		bufcall_rsrv();

#else

extern	caddr_t		he_alloc(long, int);
extern	void		he_free(caddr_t);
extern	caddr_t		he_realloc(caddr_t, long, long);
extern	int		bufcall_configure(enum cfg_op, dev_t *, size_t *);
extern	int		bufcall_init(void);
extern	int		bufcall_rsrv(queue_t *);

#endif

/*
 * str_osr.c
 */

#ifdef _NO_PROTO

extern	void		discard_passfp();
extern	int		osr_fdinsert();
extern	int		osr_find();
extern	int		osr_flush();
extern	int		osr_getmsg();
extern	int		osr_grdopt();
extern	int		osr_getsig();
extern	int		osr_link();
extern	int		osr_look();
extern	int		osr_nread();
extern	int		osr_peek();
extern	int		osr_pop();
extern	int		osr_pop_subr();
extern	int		osr_push();
extern	int		osr_push_subr();
extern	int		osr_putmsg();
extern	int		osr_read();
extern	int		osr_recvfd();
extern	int		osr_sendfd();
extern	int		osr_setsig();
extern	int		osr_srdopt();
extern	int		osr_str();
extern	int		osr_unlink();
extern	int		osr_unlink_subr();
extern	int		osr_write();

#else

extern	void		discard_passfp(MBLKP);
extern	int		osr_fdinsert(OSRP);
extern	int		osr_find(OSRP);
extern	int		osr_flush(OSRP);
extern	int		osr_getmsg(OSRP);
extern	int		osr_grdopt(OSRP);
extern	int		osr_getsig(OSRP);
extern	int		osr_link(OSRP);
extern	int		osr_look(OSRP);
extern	int		osr_nread(OSRP);
extern	int		osr_peek(OSRP);
extern	int		osr_pop(OSRP);
extern	int		osr_pop_subr(OSRP, queue_t *);
extern	int		osr_push(OSRP);
extern	int		osr_push_subr(OSRP, struct streamtab *, int, int, int, int *);
extern	int		osr_putmsg(OSRP);
extern	int		osr_read(OSRP);
extern	int		osr_recvfd(OSRP);
extern	int		osr_sendfd(OSRP);
extern	int		osr_setsig(OSRP);
extern	int		osr_srdopt(OSRP);
extern	int		osr_str(OSRP);
extern	int		osr_unlink(OSRP);
extern	int		osr_unlink_subr(OSRP, int, OSRQP);
extern	int		osr_write(OSRP);

#endif

/*
 * str_runq.c
 */

#ifdef	_NO_PROTO

extern	void		runq_init();
extern	void		runq_run();
extern	int		qenable();
extern	void		runq_sq_init();
extern	void		runq_remove();

#else

extern	void		runq_init(void);
extern	void		runq_run(void);
extern	int		qenable(queue_t *);
extern	void		runq_sq_init(queue_t *);
extern	void		runq_remove(queue_t *);

#endif

/*
 * str_scalls.c
 */

#ifdef _NO_PROTO

extern	int		pse_open();
extern	int		osr_open();
extern	int		pse_reopen();
extern	int		osr_reopen();
extern	int		clone_open();
extern	int		pse_close();
extern	int		osr_close();
extern	void		osr_close_subr();
extern	int	 	pse_read();
extern	int		pse_write();
extern	int		pse_ioctl();
extern	int		pse_select();

#else

extern	int		pse_open(dev_t, int, int);
extern	int		osr_open(OSRP, int);
extern	int		pse_reopen(OSRP);
extern	int		osr_reopen(OSRP);
extern	int		clone_open(dev_t, int, int, dev_t *);
extern	int		pse_close(dev_t, int);
extern	int		osr_close(OSRP);
extern	void		osr_close_subr(OSRQP);
extern	int		pse_read(dev_t, struct uio *, int);
extern	int		pse_write(dev_t, struct uio *, int);
extern	int		pse_ioctl(dev_t, int, caddr_t, int);
extern	int		pse_select(dev_t, short *, short *, int);

#endif

/*
 * str_shead.c
 */

#ifdef _NO_PROTO

extern	int		sth_rput();
extern	MBLKP		osr_getq();

#else

extern	int		sth_rput(queue_t *, MBLKP);
extern	MBLKP		osr_getq(STHP);

#endif

/*
 * str_subr.c
 */

#ifdef _NO_PROTO

extern	STHP		sth_alloc();
extern	void		sth_free();
extern	queue_t *	q_alloc();
extern	int		q_free();
extern	OSRP		osr_alloc();
extern	void		osr_free();
extern	POLLSP		ps_alloc();
extern	void		ps_free();
extern	STHPP		sth_muxid_lookup();
extern	MBLKP		sth_link_alloc();
extern	void		sth_u_set();
extern	void		sth_u_restore();
extern	int		sth_read_reset();
extern	int		sth_read_seek();
extern	int		open_wrapper();
extern	int		sth_mpcopyout();

#else

extern	STHP		sth_alloc(void);
extern	void		sth_free(STHP);
extern	queue_t *	q_alloc(void);
extern	int		q_free(queue_t *);
extern	OSRP		osr_alloc(int, int);
extern	void		osr_free(OSRP, int);
extern	POLLSP		ps_alloc(void);
extern	void		ps_free(POLLSP);
extern	STHPP		sth_muxid_lookup(STHP, int);
extern	MBLKP		sth_link_alloc(OSRP, int, int, queue_t *, queue_t *);
extern	void		sth_u_set(OSRP);
extern	void		sth_u_restore(OSRP);
extern	int		sth_read_reset(OSRP);
extern	int		sth_read_seek(OSRP, int, long);
extern	int		open_wrapper(struct open_args *);
extern	int		sth_mpcopyout(mblk_t *, caddr_t, int, int);

#endif

/*
 * str_synch.c
 */

#ifdef _NO_PROTO

extern	int		osr_run();
extern	void		osrq_init();
extern	void		osrq_insert();
extern	OSRP		osrq_remove();
extern	int		osrq_cancel();
extern	int		osr_sleep();
extern	void		osrq_wakeup();

#ifdef	MULTI_CPU

extern	void		act_q_init();
extern	void		csq_run();
extern	void		csq_acquire();
extern	void		csq_release();
extern	void		csq_turnover();
extern	void		csq_lateral();
extern	void		mult_sqh_acquire();
extern	void		mult_sqh_release();
extern	void		csq_newparent();
extern	queue_t *	csq_which_q();
extern	int		csq_protect();
extern	void		csq_cleanup();

#endif	/* MULTI_CPU */

extern	void		sqh_insert();
extern	SQP		sqh_remove();
extern	void		sqh_init();

#ifdef MULTI_DEBUG

extern	void		spin_lock_init();
extern	void		spin_lock();
extern	int		spin_lock_try();
extern	void		spin_unlock();

#endif	/* MULTI_DEBUG */

#else	/* _NO_PROTO */

extern	int		osr_run(OSRP);
extern	void		osrq_init(OSRQP);
extern	void		osrq_insert(OSRQP, OSRP);
extern	OSRP		osrq_remove(OSRQP);
extern	int		osrq_cancel(OSRQP, u32);
extern	int		osr_sleep(OSRP, int, int);
extern	void		osrq_wakeup(OSRQP);

#ifdef	MULTI_CPU

extern	void		act_q_init(void);
extern	void		csq_run(SQHP sqh, SQH sq);
extern	void		csq_acquire(SQHP, SQP);
extern	void		csq_release(SQHP, SQP);
extern	void		csq_turnover(SQHP);
extern	void		csq_lateral(SQHP, SQP);
extern	void		mult_sqh_acquire(OSRP);
extern	void		mult_sqh_release(OSRP);
extern	void		csq_newparent(OSRP, queue_t *, struct streamtab *)
extern	queue_t *	csq_which_q(void);
extern	int	csq_protect(queue_t *, queue_t *, pfi_t, long, int, SQP);
extern	void		csq_cleanup(SQHP);

#endif	/* MULTI_CPU */

extern	void		sqh_insert(SQHP, SQP);
extern	SQP		sqh_remove(SQHP);
extern	void		sqh_init(SQHP);

#ifdef MULTI_DEBUG

extern	void		spin_lock_init(simple_lock_t);
extern	void		spin_lock(simple_lock_t);
extern	int		spin_lock_try(simple_lock_t);
extern	void		spin_unlock(simple_lock_t);

#endif	/* MULTI_DEBUG */

#endif	/* _NO_PROTO */

/*
 * str_util.c
 *
 * Implements the STREAMS utility routines. Some routines which
 * are closely related to certain modules are found in other
 * files. The prototypes for this file come from the standard
 * include file stream.h. We list here only non-standard
 * extensions, which are for the use by the stream head, but
 * functionally closely related to standard utilities.
 */


#ifdef _NO_PROTO

extern	int		putq_owned();

#else

extern	int		putq_owned(queue_t *, mblk_t *);

#endif	/* _NO_PROTO */


/*
 *	str_weld.c
 */
#ifdef	_NO_PROTO

extern	int		weldq();
extern	int		unweldq();
extern	int		weldq_comm();
extern	int		weldq_init();
extern	void		weldq_thread_main();
extern	void		weldq_exec();
extern	void		unweldq_exec();

#else

extern	int		weldq(queue_t *, queue_t *, queue_t *, queue_t *,
				pfi_t, unsigned long, unsigned long);
extern	int		unweldq(queue_t *, queue_t *, queue_t *, queue_t *,
				pfi_t, unsigned long, unsigned long);
extern	int		weldq_comm(queue_t *, queue_t *, queue_t *, queue_t *,
				pfi_t, unsigned long, unsigned long, int);
extern	int		weldq_init(void);
extern	void		weldq_thread_main(void);
extern	void		weldq_exec(queue_t *, queue_t *);
extern	void		unweldq_exec(queue_t *, queue_t *);

#endif	/* _NO_PROTO */
