/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	core.h,v $
 * Revision 4.2.2.3  91/12/19  14:06:36  William_Burns
 * 	Merge from ODE/TIN: revision 3.1.9.2
 * 	date: 91/11/14 15:58:20;  author: devrcs;  state: Exp;  lines added/del: 8/1
 * 	sccs rev: 3.2;  orig date: 91/11/06 14:04:00;  orig author: bstevens
 * 	Added field tid to core_filehdr so that the faulting thread can be
 * 	identified in the core file.
 * 	[91/12/19  13:29:42  William_Burns]
 * 
 * Revision 4.2.2.2  91/12/05  11:44:36  Jim_McHale
 * 	Put in dbx 3.0 version; is already merged with bl8 version;
 * 	[91/11/29  13:12:00  Jim_McHale]
 * 
 * Revision 4.2  91/09/19  23:04:03  devbld
 * 	Adding ODE Headers
 * 
 * $EndLog$
 */
/* @(#)$RCSfile: core.h,v $ $Revision: 4.2.2.3 $ (DEC) $Date: 91/12/19 14:06:36 $ */
/*
 *
 * 31-Oct-91	Brian Stevens
 *	Modified core_filehdr to contain the offending thread id.
 */


#ifndef _CORE_H_
#define _CORE_H_
#include <sys/types.h>
#include <machine/coreregs.h>

#define CORE_VERS 1

#define SCNTEXT  1
#define SCNDATA  2
#define SCNRGN   3
#define SCNSTACK 4
#define SCNREGS  5
#define SCNOVFL  6

#ifdef _KERNEL
typedef vm_prot_t core_prot_t;
typedef vm_offset_t core_offset_t;
typedef vm_size_t core_size_t;
#else
typedef uint_t core_prot_t;
typedef void core_offset_t;
typedef uint_t core_size_t;
#endif /* _KERNEL */

struct core_filehdr {
	char   magic[4];		/* Contains "Core"		*/
	ushort_t version;		/* Version of this core file	*/
	ushort_t nscns;			/* Number of section headers	*/
	uint_t tid;			/* Thread causing fault		*/
	uint_t   nthreads;		/* Number of threads in process */
	int    signo;			/* Signal			*/
	char   name[MAXCOMLEN+1];	/* Name of program		*/
};

struct core_scnhdr {
	ushort_t      scntype;	/* Sect. type: SCNTEXT, SCNDATA, etc.	*/
	union {
	   uint_t     tid;	/* Thread id in SCNREGS section		*/
	   core_prot_t  prot;	/* Memory protections in text/data/stack*/
	} c_u;
	core_offset_t *vaddr;	/* Starting virtual address		*/
	core_size_t   size;	/* Size of section			*/
	uint_t	      scnptr;	/* Offset to raw data from beg. of file */
};

#endif /* _CORE_H_ */
