/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	lwc.h,v $
 * Revision 1.1.2.2  92/03/26  10:43:37  Robert_Picco
 * 	new module for lwc
 * 	[92/03/24  09:57:44  Robert_Picco]
 * 
 * $EndLog$
 */
/*
 * @(#)$RCSfile: lwc.h,v $ $Revision: 1.1.2.2 $ (DEC) $Date: 92/03/26 10:43:37 $
 */
#ifndef	__LWC__
#define	__LWC__

#ifndef	ASSEMBLER

#ifndef	spllwc
#define	spllwc splimp
#endif	/* !spllwc */

typedef vm_offset_t lwc_id_t;
typedef long lwc_pri_t;

struct lwc {
	struct lwc	*lwc_fl, *lwc_bl;	/* Forward and back links */
	unsigned short	lwc_ref;		/* References */
	unsigned short	lwc_flags;		/* None current */
	lwc_id_t	lwc_id;			/* Light weight context id */
	lwc_pri_t	lwc_pri;		/* Priority */
	void 		(*lwc_ctxt)();		/* Context */
						/* Must be at end of struct */
	long		lwc_cpu[1];		/* cpus active on */
};

typedef	struct lwc * lwc_t;

#define	LWC_NULL	(struct lwc *) 0
#define	LWC_ID_NULL	(lwc_id_t) 0

#endif /* !ASSEMBLER */

#ifdef	KERNEL
#ifndef	ASSMEBLER

extern lwc_id_t lwc_create(/* lwc_pri_t pri, void (*)() */);
extern int lwc_destroy(/* lwc_id_t id */);

#endif	/* !ASSEMBLER */
#endif	/* KERNEL */

#endif /* !__LWC__ */
