/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	msg.h,v $
 * Revision 4.2.2.2  92/03/27  15:10:33  Craig_Horman
 * 	Merge with AG
 * 	[92/03/27  13:38:46  Craig_Horman]
 * 
 * 	Merge with BL5
 * 	[92/03/10  12:33:32  Craig_Horman]
 * 
 * 	Added C++ Support
 * 	[92/02/26  18:24:34  Craig_Horman]
 * 
 * Revision 4.2  91/09/19  22:58:57  devbld
 * 	Adding ODE Headers
 * 
 * $EndLog$
 */
/*	
 *	@(#)$RCSfile: msg.h,v $ $Revision: 4.2.2.2 $ (DEC) $Date: 92/03/27 15:10:33 $
 */ 
/*
 */
/*
 * (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/*
 * OSF/1 Release 1.0
 */
/*
 * RESTRICTED RIGHTS LEGEND
 * Use, Duplication or Disclosure by the Government is subject to
 * restrictions as set forth in paragraph (b)(3)(B) of the rights in
 * Technical Data and Computer Software clause in DAR 7-104.9(a).
 */ 


#ifndef _SYS_MSG_H_
#define _SYS_MSG_H_

#include <standards.h>
#include <sys/ipc.h>

#ifdef _XOPEN_SOURCE

/*
 *	Message Operation Flags.
 */

#define	MSG_NOERROR	010000	/* no error if big message */

/*
 *	Structure Definitions
 */

/*
 *	There is one msg structure for each message that may be in the system.
 */

#ifdef _KERNEL

struct msg {
	struct msg     *msg_next;	/* ptr to next message on q */
	long            msg_type;	/* message type */
	long		msg_ts; 	/* message text size */
	caddr_t         msg_addr;	/* message text address */
};
#endif /* _KERNEL */


/*
 *	There is one msg queue id data structure for each q in the system.
 */

struct msqid_ds {
	struct ipc_perm	msg_perm;	/* operation permission struct */
	struct msg	*msg_first;	/* ptr to first message on q */
	struct msg	*msg_last;	/* ptr to last message on q */
	u_short		msg_cbytes;	/* current # bytes on q */
	u_short		msg_qnum;	/* # of messages on q */
	u_short		msg_qbytes;	/* max # of bytes on q */
	ushort		msg_lspid;	/* pid of last msgsnd */
	ushort		msg_lrpid;	/* pid of last msgrcv */
	time_t		msg_stime;	/* last msgsnd time */
	time_t		msg_rtime;	/* last msgrcv time */
	time_t		msg_ctime;	/* last change time */
};

#ifndef _KERNEL
#ifdef _NO_PROTO
extern int msgctl();
extern int msgget();
extern int msgrcv();
extern int msgsnd();
#else
#if defined(__STDC__) || defined(__cplusplus)
#if defined(__cplusplus)
extern "C"
{
#endif
extern int msgget(key_t, int);
extern int msgrcv(int, void *, size_t, long, int);
extern int msgsnd(int, void *, size_t, int);
extern int msgctl(int, int, struct msqid_ds *);
#if defined(__cplusplus)
}
#endif
#endif
#endif /* _NO_PROTO */
#endif /* _KERNEL */

#endif /* _XOPEN_SOURCE */

#ifdef	_OSF_SOURCE
/*
 * 	Implementation Constants. 
 */

#define	PMSG	(PZERO + 2)	/* message facility sleep priority */

/*
 * 	Permission Definitions. 
 */
#define	MSG_R		IPC_R	/* read permission */
#define	MSG_W		IPC_W	/* write permission */

/*
 *	ipc_perm Mode Definitions.
 */
#define	MSG_RWAIT	01000	/* a reader is waiting for a message */
#define	MSG_WWAIT	02000	/* a writer is waiting to send */


/*
 *	User message buffer template for msgsnd and msgrcv system calls.
 */

struct msgbuf {
	mtyp_t	mtype;		/* message type */
	char	mtext[1];	/* message text */
};


#ifdef _KERNEL
/*
 *	Message information structure.
 */

struct msginfo {
	int	msgmax,	/* max message size */
		msgmnb,	/* max # bytes on queue */
		msgmni,	/* # of message queue identifiers */
	   	msgtql;	/* # of system message headers */
};

#endif  /* _KERNEL */

#endif	/* _OSF_SOURCE */

extern struct msqid_ds msgque[];
extern struct msginfo msginfo;

#endif  /* _SYS_MSG_H_ */

