/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	sem.h,v $
 * Revision 4.2.2.2  92/03/27  15:11:11  Craig_Horman
 * 	Merge with AG
 * 	[92/03/27  13:39:12  Craig_Horman]
 * 
 * 	Merge with BL5
 * 	[92/03/10  12:33:46  Craig_Horman]
 * 
 * 	Added C++ Support
 * 	[92/02/26  18:26:20  Craig_Horman]
 * 
 * Revision 4.2  91/09/19  23:00:03  devbld
 * 	Adding ODE Headers
 * 
 * $EndLog$
 */
/*	
 *	@(#)$RCSfile: sem.h,v $ $Revision: 4.2.2.2 $ (DEC) $Date: 92/03/27 15:11:11 $
 */ 
/*
 */
/*
 * (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/*
 * OSF/1 Release 1.0
 */
/*
 * RESTRICTED RIGHTS LEGEND
 * Use, Duplication or Disclosure by the Government is subject to
 * restrictions as set forth in paragraph (b)(3)(B) of the rights in
 * Technical Data and Computer Software clause in DAR 7-104.9(a).
 */ 

#ifndef _SYS_SEM_H_
#define _SYS_SEM_H_

#include <standards.h>
#include <sys/ipc.h>

#ifdef _XOPEN_SOURCE


/*
 *	Semaphore Operation Flags.
 */

#define	SEM_UNDO	010000	/* set up adjust on exit entry */

/*
 *	Semctl Command Definitions.
 */

#define	GETNCNT	3	/* get semncnt */
#define	GETPID	4	/* get sempid */
#define	GETVAL	5	/* get semval */
#define	GETALL	6	/* get all semval's */
#define	GETZCNT	7	/* get semzcnt */
#define	SETVAL	8	/* set semval */
#define	SETALL	9	/* set all semval's */

/*
 *	There is one semaphore structure for each semaphore in the system.
 */

struct sem {
	u_short		semval;		/* semaphore text map address	*/
	short		sempid;		/* pid of last operation	*/
	u_short		semncnt;	/* # awaiting semval > cval	*/
	u_short		semzcnt;	/* # awaiting semval = 0	*/
};

/*
 *	There is one semaphore id data structure for each set of semaphores
 *		in the system.
 */

struct semid_ds {
	struct ipc_perm	sem_perm;	/* operation permission struct	*/
	struct sem	*sem_base;	/* ptr to first semaphore in set*/
	u_short		sem_nsems;	/* # of semaphores in set	*/
	time_t		sem_otime;	/* last semop time		*/
	time_t		sem_ctime;	/* last change time		*/
};


/*
 *	User semaphore template for semop system calls.
 */

struct sembuf {
	u_short		sem_num;	/* semaphore #			*/
	short		sem_op;		/* semaphore operation		*/
	short		sem_flg;	/* operation flags		*/
};

#ifndef _KERNEL
#ifdef _NO_PROTO
extern int semctl();
extern int semget();
extern int semop();
#else
#if defined(__STDC__) || defined(__cplusplus)
#if defined(__cplusplus)
extern "C"
{
#endif
extern int semget(key_t, int, int);
extern int semop(int, struct sembuf *, u_int);
extern int semctl(int, int, int, ...);
#if defined(__cplusplus)
}
#endif
#endif
#endif /* _NO_PROTO */
#endif /* _KERNEL   */

#endif /* _XOPEN_SOURCE */

#ifdef _OSF_SOURCE
/*
 * 	Implementation Constants. 
 */

#define	PSEMN	(PZERO + 3)	/* sleep priority waiting for greater value */
#define	PSEMZ	(PZERO + 2)	/* sleep priority waiting for zero */

/*
 * 	Permission Definitions. 
 */
#define	SEM_A	IPC_W	/* alter permission */
#define	SEM_R	IPC_R	/* read permission */

/*
 * 	There is one undo structure per process in the system. 
 *      each sem_undo struct has: 
 *       - a pointer to the next active undo struct,       
 * 	 - the number of active entries, 
 *       - and an array of undo struct entries. 
 */

#ifdef _KERNEL
struct sem_undo {
	struct sem_undo 	*un_nextp;	/* ptr to next active undo structure */
	short           	un_cnt;		/* # of active entries */
	struct undo_entry 	*un_entp;	/* ptr to list of undo entries */
};

struct undo_entry {
	struct undo_entry	*uent_nextp;	/* pointer to next undo structure */
	short           	uent_aoe;	/* adjust on exit values */
	short           	uent_num;	/* semaphore # */
	int             	uent_id;	/* semid */
};

/*
 *	Semaphore information structure. 
 */
struct seminfo {
	int	semmni,		/* # of semaphore identifiers */
		semmsl,		/* max # of semaphores per id */
		semopm,		/* max # of operations per semop call */
		semume,		/* max # of undo entries per process */
		semvmx,		/* semaphore maximum value */
		semaem;		/* adjust on exit max value */
};

#endif /* _KERNEL */

extern struct semid_ds sema[];
extern struct seminfo seminfo;

#endif /* _OSF_SOURCE */

#endif /* _SYS_SEM_H_ */



