/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	statvfs.h,v $
 * Revision 1.1.3.2  92/03/13  15:39:56  Anthony_Decarlo
 * 	bmerge
 * 	[92/03/13  15:38:09  Anthony_Decarlo]
 * 
 * 	new file for statvfs
 * 	[92/03/13  10:18:19  Anthony_Decarlo]
 * 
 * $EndLog$
 */
/*
 * @(#)$RCSfile: statvfs.h,v $ $Revision: 1.1.3.2 $ (DEC) $Date: 92/03/13 15:39:56 $
 */

#ifndef _SYS_STATVFS_H
#define _SYS_STATVFS_H

/*
 * Structure returned by statvfs.
 */

#define	FSTYPSZ	16

typedef struct statvfs {
	u_long	f_bsize;		/* prefered file system block size */
	u_long	f_frsize;		/* fundamental file system block size */
	u_long	f_blocks;		/* total # of blocks of f_frsize on fs 
					 */
	u_long	f_bfree;		/* total # of free blocks of f_frsize */
	u_long	f_bavail;		/* # of free blocks avail to 
					   non-superuser */
	u_long	f_files;		/* total # of file nodes (inodes) */
	u_long	f_ffree;		/* total # of free file nodes */
	u_long	f_favail;		/* # of free nodes avail to 
					   non-superuser */
	u_long	f_fsid;			/* file system id */
	char	f_basetype[FSTYPSZ]; 	/* target fs type name, null-terminated
					 */
	u_long	f_flag;			/* bit-mask of flags */
	u_long	f_namemax;		/* maximum file name length */
	char	f_fstr[32];		/* filesystem-specific string */
} statvfs_t;

/*
 * Flag definitions.
 */

#define	ST_RDONLY	0x01	/* read-only file system */
#define	ST_NOSUID	0x02	/* does not support setuid/setgid semantics */

#if defined(__STDC__) && !defined(_KERNEL)
int statvfs(const char *, struct statvfs *);
int fstatvfs(int, struct statvfs *);
#endif

#endif	/* _SYS_STATVFS_H */
