/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	timers.h,v $
 * Revision 4.2.2.2  92/02/14  15:54:18  Robert_Haydt
 * 	Update to POSIX.4/D11 (which obsoletes this file, but we're stuck with it).
 * 	[92/02/14  14:31:47  Jeffrey_Denham]
 * 
 * Revision 4.2  91/09/20  05:11:49  devbld
 * 	Adding ODE Headers
 * 
 * $EndLog$
 */
/*	
 *	@(#)$RCSfile: timers.h,v $ $Revision: 4.2.2.2 $ (DEC) $Date: 92/02/14 15:54:18 $
 */ 
/*
 */
/*
 * (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/*
 * OSF/1 Release 1.0
 */

#ifndef _TIMERS_H
#define _TIMERS_H

#ifndef _POSIX_4SOURCE
#include <sys/types.h>
struct timespec {
	unsigned long	tv_sec;		/* seconds */
	long		tv_nsec;	/* and nanoseconds */
};

struct itimerspec {
	struct timespec	it_interval;	/* timer period */
	struct timespec	it_value;	/* timer expiration */
};

struct itimercb {
#ifdef _POSIX_AYNCHRONOUS_EVENTS
	struct event	itcb_event;	/* timer event definition */
#endif
	int		itcb_count;	/* timer "overrun" count */
};


#define TIMEOFDAY	1	/* time of day clock type */

/*
 * Notification types
 */
#define DELIVERY_SIGNALS	1
#define DELIVERY_EVENTS		2

#ifdef nanosleep
#undef nanosleep
#endif
#define nanosleep(rqtp,rmtp)   nanosleep_d9(rqtp,rmtp)
/*
 * Functions
 */
int getclock(int clock_type, struct timespec *tp);
int setclock(int clock_type, struct timespec *tp);
int resclock(int clock_type, struct timespec *res, struct timespec *maxval);
timer_t mktimer(int clock_type, int notify_type, struct itimercb *itimercbp);
int rmtimer(timer_t timerid);
int gettimer(timer_t timerid, struct itimerspec *value);
int reltimer(timer_t timerid, struct itimerspec *value, struct itimerspec *ovalue);
int abstimer(timer_t timerid, struct itimerspec *value, struct itimerspec *ovalue);
int resrel(timer_t timerid, struct timespec *res, struct timespec *max);
int resabs(timer_t timerid, struct timespec *res, struct timespec *max);
int nanosleep_d9(struct timespec *rqtp, struct timespec *rmtp);
int ressleep(struct timespec *res, struct timespec *max);
#else                         /* _POSIX_4SOURCE */
#include <sys/types.h>
#include <sys/signal.h>

/* 
 * Constants and Macros
 */

#define REL 0
#define ABS 1

/*
 * Data Structure Definitions
 */

/*
 * The maximum timeout value, in seconds, allowed for an P1003.4
 * interval timers.
 */

struct timespec {
	time_t	tv_sec;		/* seconds */
	long	tv_nsec;	/* microseconds */
};

struct	itimerspec {
	struct		timespec it_interval; /* timer interval */
	struct		timespec it_value; /* current value */
};

/* 
 * useful macros,  note these are not defined by P1003.4
 */

#define	nsec_timerisset(tvp)		((tvp)->tv_sec || (tvp)->tv_nsec)
#define	nsec_timerclear(tvp)		(tvp)->tv_sec = (tvp)->tv_nsec = 0

/*
 * Compare two nano_second timers.  Not this only works for
 * <, > or = but not for any conbination of the two.
 */

#define	nsec_timercmp(tvp, fvp, cmp)			        	\
	((tvp)->tv_sec cmp (fvp)->tv_sec ||				\
	 (tvp)->tv_sec == (fvp)->tv_sec &&				\
	 (tvp)->tv_nsec cmp (fvp)->tv_nsec)

/*
 * Routines now made obsolete in D11
 */

#ifdef POSIX_4D10
#define clock_gettimedrift clock_getdrift
#define clock_settimedrift clock_setdrift
#define clock_getres 	   clock_getres_d10
#else
#undef clock_gettimedrift
#undef clock_settimedrift
#undef nanosleep_getres
#undef timer_getres
#define nanosleep_getres   obsolete_function_nanosleep_getres
#define timer_getres       obsolete_function_timer_getres
#define clock_settimedrift obsolete_function_clock_settimedrift
#define clock_gettimedrift obsolete_fucntion_clock_gettimedrift
#endif  /* POSIX_4D10 */

/* 
 * routine definitions
 */

#ifdef _NO_PROTO
int clock_gettime();
int clock_settime();
int clock_getdrift();
int clock_setdrift();
timer_t timer_create();
int timer_delete();
int timer_gettime();
int timer_settime();
int timer_getoverrun();
int nanosleep();
#ifndef POSIX_4D10
int clock_getres();
#else
int clock_getres_d10();
int nanosleep_getres();
int timer_getres();
#endif     /* POSIX_4D10            */
#else      /* function proto-typing */
int clock_gettime(int clock_id, struct timespec *tp);
int clock_settime(int clock_id, struct timespec *tp);
int clock_getdrift(int clock_id, int *oppb);
int clock_setdrift(int clock_id, const int ppb, int *oppb);
timer_t timer_create(int clock_id, struct sigevent *evp);
int timer_delete(timer_t timerid);
int timer_gettime(timer_t timerid, struct itimerspec *value);  
int timer_settime(timer_t timerid, int flags, struct itimerspec *value, 
                   struct itimerspec *ovalue); 
int timer_getoverrun(timer_t timerid);
int nanosleep(struct timespec *rqtp, struct timespec *rmtp);

#ifndef POSIX_4D10
int clock_getres(int clock_id,struct timespec *res);
#else
int clock_getres_d10(int clock_id,struct timespec *res,struct timespec *maxval);
int nanosleep_getres(struct timespec *res, struct timespec *maxval); 
int timer_getres(timer_t timerid, int abstime, struct timespec *res,
                 struct timespec *maxval);
#endif     /* POSIX_4D10            */

#endif  /* _NO_PROTO_ */
#endif  /* _POSIX_4SOURCE */
#endif	/* _TIMERS_H */
