/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	ucred.h,v $
 * Revision 4.2.2.2  92/03/27  15:08:14  William_Brown
 * 	"added SIA hooks for DASS"
 * 
 * Revision 4.2.1.5  92/03/27  15:02:01  William_Brown
 * 	submit checkin
 * 
 * Revision 4.2.1.4  92/03/27  11:56:43  William_Brown
 * 	ci for ag merge
 * 
 * Revision 4.2.1.3  92/03/27  11:27:08  William_Brown
 * 	pre submit checkin two
 * 
 * Revision 4.2.1.2  92/03/27  10:27:38  William_Brown
 * 	pre-submit checkin
 * 
 * Revision 4.2  91/09/19  23:02:24  devbld
 * 	Adding ODE Headers
 * 
 * $EndLog$
 */
/*	
 *	@(#)$RCSfile: ucred.h,v $ $Revision: 4.2.2.2 $ (DEC) $Date: 92/03/27 15:08:14 $
 */ 
/*
 */
/*
 * (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/*
 * OSF/1 Release 1.0
 */
/*
 * Copyright (c) 1989 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the University of California, Berkeley.  The name of the
 * University may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *

 */

#ifndef _SYS_UCRED_H_
#define	_SYS_UCRED_H_

#ifdef	_KERNEL
#include <sys/unix_defs.h>
#endif

/*
 * Credentials.
 *
 * By convention, credentials are never modified, only copied.
 * Thus, it is always possible to examine a credential entry
 * without holding the structure locked.
 *
 * Credentials in the u-area are changed by building a new
 * credentials structure and substituting it for the old one
 * pointed to by the proc structure's p_rcred field.
 */
struct ucred {
#if	MACH_ASSERT
	long	cr_dummy;		/* the zone free element ptr. */
#endif
	u_short	cr_ref;			/* reference count */
	uid_t	cr_uid;			/* effective user id */
	short	cr_ngroups;		/* number of groups */
	gid_t	cr_gid;			/* effective group id */
	gid_t	cr_groups[NGROUPS];	/* groups */
#if	defined(_KERNEL) && defined(MACH_AFS)
	long	cr_pag;			/* AFS process authentication group */
#endif
	long	cr_sia_proc_cred_val;	/* DASS proc-wide auth value */
#ifdef	_KERNEL
	udecl_simple_lock_data(,cr_lock)
#endif
};
#define NOCRED	((struct ucred *)-1)
#define	NOUID	((uid_t) -1)
#define	NOGID	((gid_t) -1)


#ifdef	_KERNEL

#define	CR_LOCK(cr)		usimple_lock(&(cr)->cr_lock)
#define	CR_UNLOCK(cr)		usimple_unlock(&(cr)->cr_lock)
#define	CR_LOCK_INIT(cr)	usimple_lock_init(&(cr)->cr_lock)

/*
 * Inline references for non-debug kernels.
 * Could inline crfree, too.
 */
#if	MACH_ASSERT
#define crhold(cr) cr_ref(cr)
#else
#define	crhold(cr)							\
MACRO_BEGIN								\
	CR_LOCK(cr);							\
	(cr)->cr_ref++;							\
	CR_UNLOCK(cr);							\
MACRO_END
#endif	/* MACH_ASSERT */

struct ucred *crget();
struct ucred *crcopy();
struct ucred *crdup();

#endif

#endif /* _SYS_UCRED_H_ */
