/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	vfs_ubc.h,v $
 * Revision 1.1.2.2  92/02/26  15:49:27  Charles_Briggs
 * 	UBC merge.
 * 	[92/02/22  14:16:03  Charles_Briggs]
 * 
 * $EndLog$
 */
/*
 * @(#)$RCSfile: vfs_ubc.h,v $ $Revision: 1.1.2.2 $ (DEC) $Date: 92/02/26 15:49:27 $
 */
#ifndef	__VFS_UBC__
#define __VFS_UBC__ 1

#ifdef	KERNEL
#include <machine/vm_ubc.h>

#ifndef	ubc_load
extern int ubc_load(vm_page_t pp, vm_offset_t offset, vm_size_t size);
#endif

#ifndef	ubc_unload
extern int ubc_unload(vm_page_t pp, vm_offset_t offset, vm_size_t size);
#endif

#ifndef	ubc_kmem_alloc
extern int ubc_kmem_alloc(vm_page_t pp);
#endif

#ifndef ubc_kmem_free
extern int ubc_kmem_free(vm_page_t pp);
#endif

#ifndef ubc_kmem_cache
extern boolean_t int ubc_kmem_cache(vm_page_t pp);
#endif

#ifndef ubc_page_zero
extern void ubc_page_zero(vm_page_t pp, vm_offset_t offset, vm_size_t len);
#endif

extern struct vm_page *ubc_dirty_kluster();
extern struct vm_page *ubc_kluster();

/*
 * ubc_kluster operation flags for hold condition
 */

#define	UBC_HNONE	0x0			/* Don't hold pages */
#define	UBC_HBCP	0x1			/* Hold before center page */
#define	UBC_HACP	0x2			/* Hold after center page */
#define	UBC_HALL	(UBC_HBCP|UBC_HACP)	/* Hold all pages */

#endif	/* KERNEL */

#endif /* !__VFS_UBC */
