/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	wait.h,v $
 * Revision 4.2.4.9  92/06/04  14:12:36  Anthony_Decarlo
 * 	bmerge done
 * 	[92/06/04  13:59:30  Anthony_Decarlo]
 * 
 * 	Added WEXITED for OSF1.1 compatibility
 * 	moved WIFCONTINUED & _W_CONTINUED to be within ifdef _OSF_SOURCE
 * 	[92/06/04  13:21:26  Anthony_Decarlo]
 * 
 * Revision 4.2.4.8  92/06/03  16:20:43  Terry_Linsey
 * 	Added prototype definition of wait() from OSF v1.1 code.
 * 	[92/05/29  15:57:35  Terry_Linsey]
 * 
 * Revision 4.2.4.7  92/05/21  16:43:16  Terry_Linsey
 * 	Temporarily backed out prototype change to fix build.
 * 	[92/05/21  16:24:53  Terry_Linsey]
 * 
 * Revision 4.2.4.6  92/05/20  15:58:02  Terry_Linsey
 * 	Added prototype declaration of wait() and moved the declaration of wait()
 * 	below the definition of "union wait" since the new prototype declaration uses
 * 	"union wait".
 * 	[92/05/15  14:50:02  Terry_Linsey]
 * 
 * Revision 4.2.4.5  92/03/27  15:17:41  Craig_Horman
 * 	Merge with AG
 * 	[92/03/27  13:45:49  Craig_Horman]
 * 
 * 	Merge with BL5
 * 	[92/03/10  12:35:59  Craig_Horman]
 * 
 * 	Added C++ Support
 * 	[92/02/26  18:58:13  Craig_Horman]
 * 
 * Revision 4.2.4.4  92/03/13  18:27:41  Peter_Lega
 * 	SVID3 waitpid() macros
 * 	[92/03/13  18:20:52  Peter_Lega]
 * 
 * Revision 4.2.4.3  92/02/28  21:30:35  Sec_Proj_Michael_Fairbrother
 * 	Merge security changes from ag.bl2 to ag.bl4
 * 	[92/01/30  11:39:48  Michael_Fairbrother]
 * 
 * 	Merge of security changes
 * 	[91/12/03  08:41:05  Michael_Fairbrother]
 * 
 * Revision 4.2.4.2  92/01/16  09:29:19  William_Burns
 * 	Merge from ODE/TIN: revision 3.1.9.2
 * 	date: 92/01/13 12:13:33;  author: devrcs;  state: Exp;  lines added/del: 10/9
 * 	sccs rev: 3.2;  orig date: 91/12/04 15:13:33;  orig author: terry
 * 	Edit to comply with POSIX VSX test.  Substitute _WSTOPPED for W_STOPPED.
 * 	[92/01/14  09:57:28  William_Burns]
 * 
 * Revision 4.2.4.2  92/01/16  09:29:19  William_Burns
 * 	Merge from ODE/TIN: revision 3.1.9.2
 * 	date: 92/01/13 12:13:33;  author: devrcs;  state: Exp;  lines added/del: 10/9
 * 	sccs rev: 3.2;  orig date: 91/12/04 15:13:33;  orig author: terry
 * 	Edit to comply with POSIX VSX test.  Substitute _WSTOPPED for W_STOPPED.
 * 	[92/01/14  09:57:28  William_Burns]
 * 
 * Revision 4.2  91/09/19  23:03:27  devbld
 * 	Adding ODE Headers
 * 
 * Revision 3.1.2.2  91/08/02  07:08:19  Michael_Fairbrother
 * 
 * 	adding OSF/1 1.0.1 changes.
 * 	[91/08/02  07:07:33  Michael_Fairbrother]
 * 
 * $EndLog$
 */
/*	
 *	@(#)$RCSfile: wait.h,v $ $Revision: 4.2.4.9 $ (DEC) $Date: 92/06/04 14:12:36 $
 */ 
/*
 * (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/*
 * OSF/1 Release 1.0.1
 */
/* @(#)wait.h   1.13  com/inc/sys,3.1,9013 1/26/90 16:14:52 */
/*
 * NAME:  Waitpid, wait, and wait3 system call constants and definitions 
 *
 * ORIGIN: BSD, IBM
 *
 * Copyright International Business Machines Corp. 1985, 1988
 * All Rights Reserved
 * Licensed Material - Property of IBM
 *
 * RESTRICTED RIGHTS LEGEND
 * Use, Duplication or Disclosure by the Government is subject to
 * restrictions as set forth in paragraph (b)(3)(B) of the Rights in
 * Technical Data and Computer Software clause in DAR 7-104.9(a).
 */

#ifndef _SYS_WAIT_H_
#define _SYS_WAIT_H_

#include <standards.h>

#include <sys/types.h>

/*
 * This file holds definitions relevent to the waitpid(), wait(), and wait3()
 * system calls.  The rusage option is only available with the wait3() call.
 * The options field in wait3() and waitpid() determines the behavior of the
 * call, while the process ID field in the waitpid() call determines which
 * group of children to search.
 */

/*
 * POSIX requires that certain values be included in wait.h.  It also
 * requires that when _POSIX_SOURCE is defined only those standard
 * specific values are present.  This header includes all the POSIX
 * required entries.
 */
#ifdef _POSIX_SOURCE

/*
 * If the user defines _BSD, they are obviously not looking for
 * POSIX definitions with respect to wait, so give 'em the BSD
 * interface.
 *
 */
#ifndef _BSD				/* POSIX definition of wait() */
#ifdef _NO_PROTO
extern pid_t wait();
#else
#if defined(__STDC__) || defined(__cplusplus)
#if defined(__cplusplus)
extern "C"
{
#endif
extern pid_t wait(int *);
#if defined(__cplusplus)
}
#endif
#endif
#endif /* _NO_PROTO */
#endif /* _BSD */

/* 
 * waitpid is not in "old" BSD so that goes here 
 */

#ifdef _NO_PROTO
extern pid_t waitpid();
#else
#if defined(__STDC__) || defined(__cplusplus)
#if defined(__cplusplus)
extern "C"
{
#endif
extern pid_t waitpid(pid_t , int *, int );
#if defined(__cplusplus)
}
#endif
#endif
#endif /* _NO_PROTO */


/*
 * The option field for wait3() and waitpid() is defined as follows:
 * WNOHANG causes the wait to not hang if there are no stopped or terminated
 * processes, rather returning an error indication in this case (pid==0).
 * WUNTRACED indicates that the caller should receive status about untraced
 * children which stop due to signals.  If children are stopped and a wait
 * without this option is done, it is as though they were still running...
 * nothing about them is returned.
 *
 */
#define WEXITED		0x0	/* process exited */
#define WNOHANG		0x1	/* dont hang in wait			 */
#define WUNTRACED	0x2	/* tell about stopped, untraced children */
#define WCONTINUED      0x4    /* wait for processes continued SVID3 */
#define WNOWAIT         0x8    /* non destructive form of wait SVID3 */



/*
 * Stopped process status.  Returned only for traced children unless requested
 * with the WUNTRACED option bit.  Lower byte gives the reason, next byte is
 * the last signal received, i.e. p->p_cursig.
 */
#define	_WSTOPPED	0177	/* bit set if stopped		*/

/*
 * MACRO defines for application interfacing to waitpid(), wait(), and wait3()
 */
#ifdef _BSD
#define	_W_INT(w)	(*(int *)&(w))	/* convert union wait to int */
#else
#define	_W_INT(i)	(i)
#endif

#define	_WSTATUS(x)	(_W_INT(x) & _WSTOPPED)
/* evaluates to a non-zero value if status returned for a stopped child	*/
#define WIFSTOPPED(x)	(_WSTATUS(x) == _WSTOPPED)
/* evaluates to the number of the signal that caused the child to stop	*/
#define WSTOPSIG(x)	(WIFSTOPPED(x) ? ((_W_INT(x) >> 8) & 0177) : -1)
/* evaluates to a non-zero value if status returned for normal termination */
#define WIFEXITED(x)	(_WSTATUS(x) == 0)
/* evaluates to the low-order 8 bits of the child exit status	*/
#define WEXITSTATUS(x)	(WIFEXITED(x) ? ((_W_INT(x) >> 8) & 0377) : -1)
/* evaluates to a non-zero value if status returned for abnormal termination */
#define WIFSIGNALED(x)	(_WSTATUS(x) != _WSTOPPED && _WSTATUS(x) != 0)
/* evaluates to the number of the signal that caused the child to terminate */
#define WTERMSIG(x)	(WIFSIGNALED(x) ? _WSTATUS(x) : -1)

#endif /* _POSIX_SOURCE */


#ifdef _OSF_SOURCE

/* evaluates to a non-zero value if status returned for continued child */
/* value for continued processes SVID3 */
#define _W_CONTINUED	0377	
#define WIFCONTINUED(x) ((_W_INT(x) & _W_CONTINUED) == _W_CONTINUED)

#include <sys/param.h>

/*
 * Option for wait3(), mach extention.
 *
 */
#define WLOGINDEV       0x8000  /* tell about login device for child */

#ifdef _BSD

/* define for BSD compatibility					*/

#define WCOREFLAG       0200

#define WCOREDUMP(x)    ((x) & WCOREFLAG)

#define W_EXITCODE(ret, sig)    ((ret) << 8 | (sig))
#define W_STOPCODE(sig)		((sig) << 8 | _WSTOPPED)

#define	WSTOPPED	_WSTOPPED
#define W_STOPPED	_WSTOPPED

/*
 * Tokens for special values of the "pid" parameter to wait4.
 */
#define WAIT_ANY	(-1)    /* any process */
#define WAIT_MYPGRP     0       /* any process in my process group */

/*
 * Use of this union is deprecated
 */
union wait
{
	int	w_status;		/* used in syscall		*/

	struct				/* terminated process status	*/
	{
#if     BYTE_ORDER == BIG_ENDIAN
		unsigned short  w_PAD16;
                unsigned        w_Retcode:8;    /* exit code if w_termsig==0 */
                unsigned        w_Coredump:1;   /* core dump indicator */
                unsigned        w_Termsig:7;    /* termination signal */
#else
                unsigned 	w_Termsig:7;    /* termination signal */
                unsigned 	w_Coredump:1;   /* core dump indicator */
                unsigned 	w_Retcode:8;    /* exit code if w_termsig==0 */
                unsigned short  w_PAD16;
#endif
	} w_T;
	/*
         * Stopped process status.  Returned
         * only for traced children unless requested
         * with the WUNTRACED option bit.
         */
        struct {
#if     BYTE_ORDER == BIG_ENDIAN
                unsigned short  w_PAD16;
                unsigned        w_Stopsig:8;    /* signal that stopped us */
                unsigned        w_Stopval:8;    /* == _WSTOPPED if stopped */
#else
                unsigned	w_Stopval:8;    /* == _WSTOPPED if stopped */
                unsigned	w_Stopsig:8;    /* signal that stopped us */
                unsigned short  w_PAD16;
#endif
	} w_S;
};

#define	w_termsig	w_T.w_Termsig
#define w_coredump	w_T.w_Coredump
#define w_retcode	w_T.w_Retcode
#define w_stopval	w_S.w_Stopval
#define w_stopsig	w_S.w_Stopsig

#ifdef _NO_PROTO
extern int wait();
extern int wait3();
#else

#if defined(__cplusplus)
extern "C" {
#endif
extern int wait(union wait *);
#if defined(__cplusplus)
}
#endif

#if defined(__cplusplus)
extern "C" {
#endif
#include <sys/resource.h>   /* contains rusage struct for wait3 */
extern int wait3(union wait *, int, struct rusage *);
#if defined(__cplusplus)
}
#endif
#endif  /* !_NO_PROTO */

#endif /* _BSD */

#endif /* _OSF_SOURCE */

#endif /* _SYS_WAIT_H_ */

