/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	vm_vlock.h,v $
 * Revision 1.1.2.2  92/02/26  16:13:10  Charles_Briggs
 * 	UBC merge.
 * 	[92/02/22  14:50:35  Charles_Briggs]
 * 
 * $EndLog$
 */
/*
 * @(#)$RCSfile: vm_vlock.h,v $ $Revision: 1.1.2.2 $ (DEC) $Date: 92/02/26 16:13:10 $
 */
#ifndef	__VM_VLOCK__
#define	__VM_VLOCK__ 1

/*
 * Support of kernel lock of user address space.
 * We don't want to pollute the user space mappings
 * with locks held by the kernel to do physical I/O.
 * Instead we maintain a list of virtual space locked.
 * Also we don't release empty lock space until we
 * scan and its above some limit.  This will work if
 * the u-map uses a common set of VAS locations to do
 * I/O.
 */ 

struct vm_vlock {
	struct vm_vlock *vl_next;	/* Next link */
	struct vm_vlock *vl_prev;	/* Back pointer */
	vm_offset_t vl_start;		/* Beginning */
	vm_offset_t vl_end;		/* Last exclusive */
	unsigned short vl_count;	/* Locks held */
};

#ifdef	KERNEL

extern kern_return_t vl_wire(vm_map_entry_t ep, 
			vm_offset_t start, vm_offset_t end, vm_prot_t prot);
extern kern_return_t vl_unwire(vm_map_entry_t ep, 
			vm_offset_t start, vm_offset_t end);
extern boolean_t vl_kwire(vm_map_entry_t ep, 
			vm_offset_t start, vm_offset_t end);
extern void vl_remove(vm_map_t map);

#endif	/* KERNEL */

#endif	/* !__VM_VLOCK */
