/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	vm_vp.h,v $
 * Revision 1.1.2.3  92/06/19  11:02:52  Robert_Picco
 * 	Segmentation code
 * 	[92/06/18  21:09:27  Robert_Picco]
 * 
 * Revision 1.1.2.2  92/02/26  16:13:15  Charles_Briggs
 * 	UBC merge.
 * 	[92/02/22  14:49:57  Charles_Briggs]
 * 
 * $EndLog$
 */
/*
 * @(#)$RCSfile: vm_vp.h,v $ $Revision: 1.1.2.3 $ (DEC) $Date: 92/06/19 11:02:52 $
 */
#ifndef	__VM_VP__
#define	__VM_VP__	1
#include <vm/vm_object.h>
#include <vm/vm_mmap.h>

	

/*
 * A regular vnode points to this object.
 */

struct vm_vp_object {
	struct vm_object vo_object;		/* Object common part */
	struct vnode 	*vo_vp;			/* Vnode */
	struct vm_page	*vo_cleanpl;		/* Clean page list */
	struct vm_page	*vo_cleanwpl;		/* Clean wired page list */
	struct vm_page	*vo_dirtywpl;		/* Dirty wired page list */
	int		vo_wirecnt;		/* Wired pages */
	vm_offset_t	vo_lastpage;		/* Last page allocated */
	int		vo_nsequential;		/* Number of contig lastpage */
	unsigned char	vo_flags;		/* Flags */
	u_long		vo_stamp;		/* Allocation stamp */
	udecl_simple_lock_data(, vo_seglock)	/* Segment list lock */
	struct vm_seg	*vo_seglist;		/* Segment list */
};

#define	vo_dirtypl vo_object.ob_memq
#define vo_orefcnt vo_object.ob_ref_count
#define vo_npages  vo_object.ob_resident_pages

/*
 * vo_flags 
 */

#define	VOP_ISTEXT	0x01			/* Contains executable */
#define	VOP_SEGMENT	0x02			/* Used as segmented text */

/*
 * An mmaper points to this object which in turn
 * points to a vm_vp_object.  
 */

struct vm_uvp_object {
	struct vm_object uvo_object;		/* Object common part */
	struct vm_vp_object *uvo_vop;		/* Pointer to vop */
	vm_offset_t uvo_end;			/* End of region mapped */
};


#define uvo_refcnt	uvo_object.ob_ref_count
#define	uvo_flags	uvo_object.ob_flags 

#ifdef	KERNEL
extern int vop_lock_size, vop_lock_pages, vop_lock_mask;
#endif	/* KERNEL */

#endif	/* !__VM_VP__ */
