/*
 *	$Source: /u1/Xr/src/Xrlib/Intrinsic/RCS/init.c,v $
 *	$Header: init.c,v 1.1 86/12/17 09:08:25 swick Exp $
 */

#ifndef lint
static char *rcsid_init_c = "$Header: init.c,v 1.1 86/12/17 09:08:25 swick Exp $";
#endif	lint

#include <Xr/xr-copyright.h>

/* $Header: init.c,v 1.1 86/12/17 09:08:25 swick Exp $ */
/* Copyright 1986, Hewlett-Packard Company */
/* Copyright 1986, Massachussetts Institute of Technology */

static char rcsid[] = "$Header: init.c,v 1.1 86/12/17 09:08:25 swick Exp $";
/*************************************<+>*************************************
 *****************************************************************************
 **
 **   File:        init.c
 **
 **   Project:     X-ray Toolbox
 **
 **   Description: init.c contains the X-ray XrInit() which initializes
 **                X-ray so that its functions can be use by the application.
 **
 **
 **   ------------------------ MODIFICATION RECORD   ------------------------
 *
 * $Log:	init.c,v $
 * Revision 1.1  86/12/17  09:08:25  swick
 * Initial revision
 * 
 * Revision 7.0  86/11/13  08:20:00  08:20:00  rick ()
 * Final QA release
 * 
 * Revision 6.0  86/11/10  15:21:50  15:21:50  rick ()
 * QA #2 release
 * 
 * Revision 5.4  86/11/07  14:01:51  14:01:51  rick ()
 * Added the copyright message.
 * 
 * Revision 5.3  86/11/06  12:54:52  12:54:52  rick ()
 * Fixed the resource id setting for the bitmaps.
 * 
 * Revision 5.2  86/10/30  13:25:27  13:25:27  rick ()
 * *** empty log message ***
 * 
 * Revision 5.1  86/10/30  09:08:27  09:08:27  rick ()
 * Changed XrInit to disallow it from being called more than once.
 * 
 * Revision 5.0  86/10/28  08:22:38  08:22:38  rick ()
 * QA #1.1 release
 * 
 * Revision 4.2  86/10/27  13:33:12  13:33:12  rick ()
 * Changed the call to XrInputInit().
 * 
 * Revision 4.1  86/10/26  16:13:33  16:13:33  rick ()
 * Added the initialization for the cursor in the default panel context.
 * 
 * Revision 4.0  86/10/20  12:08:40  12:08:40  rick ()
 * QA 1 release
 * 
 * Revision 3.11  86/10/17  12:23:24  12:23:24  rick ()
 * Linted
 * 
 * Revision 3.10  86/10/16  11:20:34  11:20:34  rick ()
 * Added register variables.
 * 
 * Revision 3.9  86/10/15  14:06:19  14:06:19  rick ()
 * Removed the menu meta default.
 * 
 * Revision 3.8  86/10/13  13:55:26  13:55:26  rick ()
 * Added the input initialization call.
 * 
 * Revision 3.7  86/10/10  13:12:33  13:12:33  rick ()
 * Added the button modifier defaults.
 * 
 * Revision 3.6  86/10/09  10:15:00  10:15:00  rick ()
 * Added the window foreground, background, and border defaults.
 * 
 * Revision 3.5  86/10/09  07:34:58  07:34:58  fred ()
 * Every change adds 2 bugs.  Fixed the foreground and 
 * background color defaults.
 * 
 * Revision 3.4  86/10/08  15:09:18  15:09:18  rick ()
 * Added the foreground and background color defaults.
 * 
 * Revision 3.3  86/10/08  13:21:21  13:21:21  rick ()
 * Finished the X defaults work.
 * 
 * Revision 3.2  86/10/08  09:35:50  09:35:50  rick ()
 * Added all of the panel context and menu X defaults.
 * 
 * Revision 3.1  86/10/07  09:53:14  09:53:14  rick ()
 * Fixed the defaults setting for the mouse buttons.
 * 
 * Revision 3.0  86/10/02  15:58:38  15:58:38  rick ()
 *  Alpha release set to 3.0
 * 
 * Revision 2.2  86/09/29  09:42:23  09:42:23  rick ()
 * Added the initialization for the menu cursor.
 * 
 * Revision 2.1  86/09/25  10:54:30  10:54:30  rick ()
 * Added the color settings and tile creation for menus.
 * Removed the .onx from the XOpenFont.
 * 
 * Revision 2.0  86/09/16  08:00:07  08:00:07  rick ()
 * Added the initialization of the select and menu buttons from X defaults.
 * 
 * Revision 1.1  86/09/03  13:35:11  13:35:11  rick ()
 * Initial revision
 * 
 *
 *****************************************************************************
 *************************************<+>*************************************/


#include <X/Xlib.h>
#include <Xr/defs.h>
#include <Xr/types.h>


/*
 *  Is this the first call to init?
 */

static int firstInit = TRUE;


/*
 *  Define the comparison strings to be used for setting the 
 *  defaults for select and menu buttons.
 */

static char * buttonStrings[] =
{
   "LeftButtonDown",
   "LeftButtonUp",
   "MiddleButtonDown",
   "MiddleButtonUp",
   "RightButtonDown",
   "RightButtonUp"
};




/*************************************<->*************************************
 *
 *  XrInit (allocFuncts)
 *  xrAllocFuncts * allocFuncts;
 *
 *
 *   Description:
 *   -----------
 *     The XrInit() routine sets up X-ray for use by an application by 
 *     initializing internal data and added a set of resources that the 
 *     X-ray routines need.
 *
 *
 *   Inputs:
 *   ------
 *     allocFuncts = This parameter contains a pointer to an xrAllocFuncts
 *                   structure which contains a set of allocation functions
 *                   to be used within X-ray in place of the normal UNIX
 *                   functions.
 *
 * 
 *   Outputs:
 *   -------
 *     TRUE =  Returned as the value of the function if the function 
 *             succeeds.
 *
 *     FALSE = Returned as the value fo the function if the function
 *             fails.
 *
 *
 *   Procedures Called
 *   -----------------
 *     XOpenFont	Xlib routine
 *     XStoreBitmap	Xlib routine
 *     XGetDefault      Xlib routine
 *     XrInput		input.c
 *     _XrGetColor      internal in init.c
 *     _XrGetModifier   internal in inti.c
 *
 *
 *************************************<->***********************************/


XrInit (allocFuncts)
xrAllocFuncts * allocFuncts;

{
   register INT32        i;
   register xrBitmapId * bitmapId;
   register INT8       * string;
   register INT32       color;
   xrResourceInfo resourceInfo;
   xrFDInput      inputSource;
   xrPixmap     * pixmap;
   INT32          cursorFGColor;
   INT32          cursorBGColor;



   /*
    *  Check to make sure that the routine is not being 
    *  called a second time.
    */

   if (firstInit == FALSE)
   {
      xrErrno = XrINVALIDPARM;
      return (FALSE);
   }
   firstInit = FALSE;


   /*
    *  Initialize the input mapping.
    */

   XrInputInit();


   /*
    *  Initialize the set of bitmaps and bitmap ids by
    *  allocating a structure to hold them and then
    *  installing them into the resource manager.
    */

   resourceInfo.resourceState = 0;

   for (i = 1; i < 10; i++)
   {
      bitmapId = (xrBitmapId *) (*xrMalloc) (sizeof (xrBitmapId));
      pixmap = (xrPixmap *) (*xrMalloc) (sizeof (xrPixmap));
      bitmapId -> width = pixmap -> width = 16;
      bitmapId -> height = pixmap -> height = 16;
      bitmapId -> bitmapId = XStoreBitmap (16, 16, xr_bitmaps[i - 1]);
      pixmap -> depth = XrBIT1;
      pixmap -> raster = xr_bitmaps[i];

      resourceInfo.resourceId = -i;

      resourceInfo.resourceObject = (INT8 *) pixmap;
      resourceInfo.resourceType = XrTYPE_BITMAP;
      if (XrResource (MSG_ADD, &resourceInfo) == FALSE)
         return (FALSE);
         
      resourceInfo.resourceObject = (INT8 *) bitmapId;
      resourceInfo.resourceType = XrTYPE_BITMAPID;

      if (XrResource (MSG_ADD, &resourceInfo) == FALSE)
         return (FALSE);
   }


   /*
    *  Set up the button defaults.
    */

   xrSelect = XrLEFTBUTTONDOWN;
   if ((string = XGetDefault ("X-ray", "Select")) != NULL)
      for (i = 0; i < 6; i++)
         if (strcmp (string, buttonStrings[i]) == 0)
         {
            xrSelect = i;
            break;
         }

   xrSelectUp = XrLEFTBUTTONUP;
   if ((string = XGetDefault ("X-ray", "SelectUp")) != NULL)
      for (i = 0; i < 6; i++)
         if (strcmp (string, buttonStrings[i]) == 0)
         {
            xrSelectUp = i;
            break;
         }

   xrMenuPost = XrRIGHTBUTTONDOWN;
   if ((string = XGetDefault ("X-ray", "MenuPost")) != NULL)
      for (i = 0; i < 6; i++)
         if (strcmp (string, buttonStrings[i]) == 0)
         {
            xrMenuPost = i;
            break;
         }

   xrMenuItemSelect = XrRIGHTBUTTONUP;
   if ((string = XGetDefault ("X-ray", "MenuItemSelect")) != NULL)
      for (i = 0; i < 6; i++)
         if (strcmp (string, buttonStrings[i]) == 0)
         {
            xrMenuItemSelect = i;
            break;
         }


   /*
    *  Get all of the button modifiers.
    */

   xrLBDMod = xrLBUMod = xrMBDMod = xrMBUMod = xrRBDMod = xrRBUMod = 0;
      
   if ((string = XGetDefault ("X-ray", "AllButtonModifier")) != NULL)
      xrLBDMod = xrLBUMod = xrMBDMod = 
      xrMBUMod = xrRBDMod = xrRBUMod = _XrGetModifier (string);
   else
   {
      if ((string = XGetDefault("X-ray","LeftButtonDownModifier")) != NULL)
         xrLBDMod = _XrGetModifier (string);

      if ((string = XGetDefault("X-ray","LeftButtonUpModifier")) != NULL)
         xrLBUMod = _XrGetModifier (string);

      if ((string=XGetDefault("X-ray","RightButtonDownModifier")) != NULL)
         xrRBDMod = _XrGetModifier (string);

      if ((string=XGetDefault("X-ray","RightButtonUpModifier")) != NULL)
         xrRBUMod = _XrGetModifier (string);

      if ((string=XGetDefault("X-ray","MiddleButtonDownModifier")) != NULL)
         xrMBDMod = _XrGetModifier (string);

      if ((string=XGetDefault("X-ray","MiddleButtonUpModifier")) != NULL)
         xrMBUMod = _XrGetModifier (string);
   }


   /*
    *  Get the window foreground, background and border defaults.
    */

   xrWindowForeground = BlackPixmap;
   xrPanelContextDefaults.winForeground = BlackPixmap;
   if ((string = XGetDefault ("X-ray", "WindowForeground")) != NULL)
      if ((color = _XrGetColor (string)) != -1)
      {
         xrWindowForeground = XMakeTile (color);
         xrPanelContextDefaults.winForeground = xrWindowForeground;
      }

   xrPanelContextDefaults.winBackground = WhitePixmap;
   xrWindowBackground = WhitePixmap;
   if ((string = XGetDefault ("X-ray", "WindowBackground")) != NULL)
      if ((color = _XrGetColor (string)) != -1)
         {
         xrWindowBackground = XMakeTile (color);
         xrPanelContextDefaults.winBackground = xrWindowBackground;
      }

   xrBorderWidth = xrPanelContextDefaults.borderWidth = 1;
   string = XGetDefault ("X-ray", "BorderWidth");
   if (string != NULL && *string >= '0' && *string <= '9')
   {
      xrBorderWidth = atoi (string);
      xrPanelContextDefaults.borderWidth = xrBorderWidth;
   }


   /*
    *  Get the default foreground and background color.
    */

   xrForegroundColor = xrPanelContextDefaults.foregroundColor = BlackPixel;
   if ((string = XGetDefault ("X-ray", "ForegroundColor")) != NULL)
      if ((color = _XrGetColor (string)) != -1)
      {
         xrPanelContextDefaults.foregroundColor = color;
         xrForegroundColor = color;
      }

   xrBackgroundColor = xrPanelContextDefaults.backgroundColor = WhitePixel;
   if ((string = XGetDefault ("X-ray", "BackgroundColor")) != NULL)
      if ((color = _XrGetColor (string)) != -1)
      {
         xrPanelContextDefaults.backgroundColor = color;
         xrBackgroundColor = color;
      }


   /*
    *  Get the default font.
    */

   if ((string = XGetDefault ("X-ray", "DefaultFont")) != NULL)
   {
      if ((xrBaseFontInfo = XOpenFont (string)) == NULL)
      {
         xrErrno = XrXCALLFAILED;
         return (FALSE);
      }
   }
   else
   {
      if ((xrBaseFontInfo = XOpenFont ("helv10b")) == NULL)
      {
         xrErrno = XrXCALLFAILED;
         return (FALSE);
      }
   }
   xrPanelContextDefaults.fontInfo = xrBaseFontInfo;


   /*
    *  Initialize the rest of the default panel context members.
    */

   xrPanelContextDefaults.showFlag = TRUE;
   xrPanelContextDefaults.currentEditor = NULL;
   xrPanelContextDefaults.timer = -1;
   xrPanelContextDefaults.initFunct = NULL;


   /*
    *  Get the menu sticky default.
    */

   xrMenuSticky = TRUE;
   if ((string = XGetDefault ("X-ray", "MenuSticky")) != NULL)
      if (strcmp (string, "On") == 0)
         xrMenuSticky = TRUE;
      else
         xrMenuSticky = FALSE;


   /*
    *  Make a default pixmap for use by the editors when they
    *  are using the default colors.
    */

   resourceInfo.resourceType = XrTYPE_BITMAPID;
   resourceInfo.resourceId = XrPERCENT50;
   XrResource (MSG_FIND, &resourceInfo);
   xrDefaultTile =
      XMakePixmap (((xrBitmapId *)resourceInfo.resourceObject) -> bitmapId,
                    xrForegroundColor, xrBackgroundColor);


   /*
    *  Get the color wanted for the default cursor.
    */

   cursorFGColor = BlackPixel;
   if ((string = XGetDefault ("X-ray", "CursorForeground")) != NULL)
      if ((cursorFGColor = _XrGetColor (string)) == -1)
         cursorFGColor = BlackPixel;

   cursorBGColor = WhitePixel;
   if ((string = XGetDefault ("X-ray", "CursorBackground")) != NULL)
      if ((cursorBGColor = _XrGetColor (string)) == -1)
         cursorBGColor = WhitePixel;


   /*
    *  Set up the cursor.
    */

   xrDefaultCursor = xrPanelContextDefaults.cursor = 
      XStoreCursor (XStoreBitmap (16, 16, xrCursorImage),
                    XStoreBitmap (16, 16, xrCursorMask),
                    1, 1, cursorFGColor, cursorBGColor, GXcopy);


   /*
    *  Initialize the allocation functions.
    */

   if (allocFuncts != NULL)
   {
      if (allocFuncts -> newMalloc  == NULL ||
          allocFuncts -> newFree    == NULL ||
          allocFuncts -> newRealloc == NULL ||
          allocFuncts -> newCalloc  == NULL)
         ;
      else
      {
         xrMalloc = allocFuncts -> newMalloc;
         xrFree = allocFuncts -> newFree;
         xrRealloc = allocFuncts -> newRealloc;
         xrCalloc = allocFuncts -> newCalloc;
      }
   }


   /*
    *  Initialize the input routine.
    */

   inputSource.type = XrREAD;
   inputSource.fd = dpyno();

   if (XrInput (NULL, MSG_ADDINPUT, &inputSource) == FALSE)
      return (FALSE);


   /*
    *  Initialize the graphics context base font info.
    */

   xr_GCList[0][XrFONTVAL] = xrBaseFontInfo -> id;

   return (TRUE);
}



/*************************************<->*************************************
 *
 *  _XrGetColor (string)
 *  INT8 * string;
 *
 *
 *   Description: 
 *   ------------
 *     _XrGetColor takes an input string and generates a color which
 *     matches the string.
 *
 *
 *   Inputs:
 *   -------
 *     string = The string which contains the "name" of the color
 *              to be generated.
 *
 *
 *   Outputs:
 *   --------
 *     pixel  =  The pixel value is returned if the routine
 *               is successful.
 *     -1     =  returned if the routine fails.
 *
 *
 *   Procedures Called
 *   -----------------
 *     XParseColor        -  Xlib
 *     XGetHardwareColor  -  Xlib
 *
 *************************************<->*************************************/


static
_XrGetColor (string)
INT8 * string;

{
   Color color;

   if (strcmp (string, "black") == 0)
      return (BlackPixel);

   if (strcmp (string, "white") == 0)
      return (WhitePixel);

   if (XParseColor (string, &color) == 0)
      return (-1);

   if (XGetHardwareColor (&color) == 0)
      return (-1);

   return (color.pixel);
}





/*************************************<->*************************************
 *
 *  _XrGetModifier (string)
 *  INT8 * string;
 *
 *
 *   Description: 
 *   ------------
 *     _XrGetModifier takes an input string and generates an unsigned
 *     16 bit quantity to be used as a button modifier.  The value
 *     will contain the mask necessary for the button pressed or
 *     released to be modified by either a control, shift, or meta
 *     key press.
 *
 *
 *   Inputs:
 *   -------
 *     string = The string which contains the "name" of the modifier
 *              to be generated.
 *
 *
 *   Outputs:
 *   --------
 *     modifier  =  The 16 bit value is returned if the routine
 *                  is successful.
 *     0         =  returned if the routine fails or the string
 *                  contains the modifier None.
 *
 *
 *   Procedures Called
 *   -----------------
 *     strcmp()
 *
 *************************************<->*************************************/


static
_XrGetModifier (string)
INT8 * string;

{
   if (strcmp (string, "Control") == 0)
      return (ControlMask);
   else if (strcmp (string, "Meta") == 0)
      return (MetaMask);
   else if (strcmp (string, "Shift") == 0)
      return (ShiftMask);
   else
      return (0x0000);
}
