/*
Copyright 1988 Torch Computers Ltd.

Permission to use, copy, modify, and otherwise generally do what you like
with this software is hereby granted provided that the above copyright notice
appears in all copies.

Torch disclaims all warranties implied or expressed with regard to this
software.  In no event shall Torch be liable for any damages arising from
this use of software.
*/

/********************************************************
*							*
*  Title   Yorn, Gs and Alert				*
*							*
*  File	   : gs.c					*
*  Author  : Gary Henderson				*
*  Date	   : 29th Sep 1988				*
*  Purpose : The gs box widgets code.	    	    	*
*							*
*********************************************************/

/*------Include files-----------------------------------*/

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xos.h>
#include <X11/Xutil.h>
#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <X11/Form.h>
#include <X11/Core.h>
#include <X11/Shell.h>
#include <X11/Command.h>
#include <X11/AsciiText.h>

/*------Forward delarations-----------------------------*/

extern long time ();

/*------Constants and macros----------------------------*/

#define ALONX 	    	((root_width / 5 + rand () % 48))
#define ALONY 	    	((root_height / 5 + rand () % 48))
#define MESSAGE_WIDTH	40
#define EXTRA 6

/*------Exported variables/functions--------------------*/

Widget 	gswidget;
void 	Finished ();

/*------Imported variables/functions--------------------*/

extern Widget 	    a_widget;
extern XFontStruct  *sysfont;
extern unsigned int root_width, root_height;
extern Display 	    *display;
extern Window 	    root_window;
extern int  	    screen_number;
extern Screen 	    *screen;
extern Boolean 	    zoom;
extern int  	    lines, cols;
extern char 	    *font_name;

/*------Static variables--------------------------------*/

static Widget 	button;
static Widget 	textwidget;
static Widget 	messagewidget;
static char 	*data;
static int  	length;

/*
							*****************
							*		*
							*    INITGS	*
							*		*
							*****************
-------------------------------------------------------------------------
| Initialise the widgets for the gs box.    	    	    	    	|
-------------------------------------------------------------------------
*/
void InitGS (string, geometry)
char * string;
char * geometry;
{
    Arg args[20];
    Widget formwidget;
    int message_width, message_height;
    int char_width = (sysfont->max_bounds.width + 
    	    	      sysfont->min_bounds.width) / 2;
    int char_height = (sysfont->ascent + sysfont->descent);
    int mx_offset, tx_offset;
    
    static XtCallbackRec ackbacks[] = {
    	{Finished, NULL},
    	{NULL, NULL},
    };

#ifdef BSD
    (void) srand ((int) time ((long *) 0));
#endif BSD

#if defined(UNISOFTV) || defined(SYSV)
    (void) srand ((unsigned int) time ((long *) 0));
#endif /* UNISOFTV || SYSV */

    /* Its a popup */

    XtSetArg (args[0], XtNx, ALONX);
    XtSetArg (args[1], XtNy, ALONY);
    XtSetArg (args[2], XtNgeometry, geometry);
    
    gswidget = XtCreatePopupShell ("gsbox", 
    	    	    	    	    zoom ? topLevelShellWidgetClass :
				    	   overrideShellWidgetClass, 
				    a_widget,
				    args,
				    geometry ? 3 : 2);
				    
    formwidget= XtCreateManagedWidget ("contents",
    	    	    	    	      formWidgetClass,
				      gswidget,
				      (ArgList) 0,
				      0);

    XtSetArg (args[0], XtNhorizDistance, 4);
    XtSetArg (args[1], XtNvertDistance, 4);
    XtSetArg (args[2], XtNresizable, False);
    XtSetArg (args[3], XtNcallback, ackbacks);
    XtSetArg (args[4], XtNfont, sysfont);
    XtSetArg (args[5], XtNbottom, XtChainTop);
    XtSetArg (args[6], XtNtop, XtChainTop);
    XtSetArg (args[7], XtNleft, XtChainLeft);
    XtSetArg (args[8], XtNright, XtChainLeft);
    
    button = XtCreateManagedWidget("Finished",
    	    	    	    	    commandWidgetClass,
				    formwidget,
				    args,
				    9);

    message_height = char_height + EXTRA;

    if (strlen (string) < MESSAGE_WIDTH)
    	message_width = strlen (string) * char_width + EXTRA;
    else
    {
    	message_width = MESSAGE_WIDTH * char_width + EXTRA;
	message_height = char_height * (1 + strlen (string) / 
	    	    	    	       MESSAGE_WIDTH) + EXTRA;
    }

    if (cols * lines != 0)
    {
    	if (cols * char_width + EXTRA > message_width)
	{
    	    mx_offset = ((cols * char_width + EXTRA) - message_width) / 2 + 4;
	    tx_offset = 4;
	}
	else
	{
    	    mx_offset = 4;
    	    tx_offset = (message_width - (cols * char_width + EXTRA)) / 2 + 4;
	}
    }
    else
    	mx_offset = 4;

    XtSetArg (args[0], XtNhorizDistance, mx_offset);
    XtSetArg (args[1], XtNvertDistance, 4);
    XtSetArg (args[2], XtNresizable, True);
    XtSetArg (args[3], XtNeditType, XttextRead);
    XtSetArg (args[4], XtNstring, string);
    XtSetArg (args[5], XtNlength, strlen (string));
    XtSetArg (args[6], XtNtextOptions, scrollOnOverflow | wordBreak);
    XtSetArg (args[7], XtNbottom, XtRubber);
    XtSetArg (args[8], XtNtop, XtChainTop);
    XtSetArg (args[9], XtNleft, XtChainLeft);
    XtSetArg (args[10], XtNright, XtChainRight);
    XtSetArg (args[11], XtNfromVert, button);
    XtSetArg (args[12], XtNwidth, message_width);
    XtSetArg (args[13], XtNheight, message_height);
    XtSetArg (args[14], XtNfont, sysfont);
    
    messagewidget = XtCreateManagedWidget ("message", asciiStringWidgetClass, 
    	    	    	    	    	formwidget, args, 15);
    if (lines * cols != 0)
    {
    	data = XtMalloc ((length = lines * cols) + 2);

    	*data = '\0';
	
	XtSetArg (args[0], XtNhorizDistance, tx_offset);
    	XtSetArg (args[1], XtNvertDistance, 4);
    	XtSetArg (args[2], XtNresizable, False);
    	XtSetArg (args[3], XtNeditType, XttextEdit);
    	XtSetArg (args[4], XtNstring, data);
    	XtSetArg (args[5], XtNlength, length);
    	XtSetArg (args[6], XtNtextOptions, scrollOnOverflow | wordBreak | editable);
    	XtSetArg (args[7], XtNbottom, XtChainBottom);
    	XtSetArg (args[8], XtNtop, XtRubber);
    	XtSetArg (args[9], XtNleft, XtChainLeft);
    	XtSetArg (args[10], XtNright, XtChainRight);
    	XtSetArg (args[11], XtNfromVert, messagewidget);
    	XtSetArg (args[12], XtNwidth, cols * char_width + EXTRA);
    	XtSetArg (args[13], XtNheight, lines * char_height + EXTRA);
    	XtSetArg (args[14], XtNfont, sysfont);
    
    	textwidget = XtCreateManagedWidget ("reply", asciiStringWidgetClass, 
    	    	    	    	    	    	    formwidget, args, 15);
    }
    else
    	length = 0, data = 0;
	
    XtRealizeWidget (gswidget);
}

/*
							*****************
							*		*
							*   FINISHED	*
							*		*
							*****************
-------------------------------------------------------------------------
| The 'Finished' button has been selected by the user.  Read the text	|
| widget's current text, print it on stdout and then exit.    	    	|
-------------------------------------------------------------------------
*/
/*ARGSUSED*/
void Finished (widget, client_data, call_data)
Widget widget;
caddr_t client_data,call_data;
{
    char * p;
    
    XtPopdown (gswidget);

    if (length == 0)
    	exit (0);
	
    /* Remove trailing spaces and make sure the string is terminated by
       a new line character */
       
    p = data + strlen (data);

    if (strlen (data) != 0)
    	p--;
	
    if (*p != '\n')
    {
    	while (p > data && *p == ' ')
	    p--;

	if (*p == ' ')
	    *p++ = '\n';
    	else
	    if (*p != '\n')
	    {
		*++p = '\n';
		p++;
	    }
	
	*p = '\0';
    }
    	
    printf ("%s", data);
    exit (0);
}
