/*
Copyright 1988 Torch Computers Ltd.

Permission to use, copy, modify, and otherwise generally do what you like
with this software is hereby granted provided that the above copyright notice
appears in all copies.

Torch disclaims all warranties implied or expressed with regard to this
software.  In no event shall Torch be liable for any damages arising from
this use of software.
*/

/********************************************************
*							*
*  Title   Yorn, Gs and Alert				*
*							*
*  File	   : main.c					*
*  Author  : Gary Henderson				*
*  Date	   : 26th Sep 1988. 	    	    	    	*
*  Purpose : Decide what we are called (hence what  	*
*   	     progame to act like), initialise the   	*
*   	     toolkit, setup some global variables and	*
*   	     call the right code.   	    	    	*
*							*
*********************************************************/

/*------Include files-----------------------------------*/

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xos.h>
#include <X11/Xutil.h>
#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <X11/TopLevel.h>
#include <X11/Shell.h>
#include <X11/Core.h>
#include <X11/Label.h>
#include <X11/cursorfont.h>

#include "classname.h"

/*------Forward delarations-----------------------------*/

static void InitFontAndResources ();

/*------Constants and macros----------------------------*/

#define EXTRABIT    50	/* Extra amount added to new long string */

/*------Exported variables/functions--------------------*/

Display     *display;
Window 	    root_window;
Screen 	    *screen;
int 	    screen_number;
XFontStruct *sysfont;
Widget 	    a_widget;
Cursor 	    arrow_cursor;
unsigned int root_width, 
    	     root_height;
Boolean     zoom = True;      	    /* Flag to use override redirect
    	    	    	    	       (False, use override ) */
int 	    cols = 0, 
    	    lines = 0,
 	    timeout = 0;
char 	    *title;
int 	    is_gs;
char	    *alertsym_name, 	    /* Various names of bitmap files */
    	    *yornsym_name,  	    /* if not null, use these in preference */
	    *ticksym_name,  	    /* to the built-in ones. */
    	    *crosssym_name,
	    *oksym_name;

char 	    *progname;
	    
void	    ReadWidgetColours ();
void 	    Usage ();

/*------Imported variables/functions--------------------*/

extern Widget 	alertwidget;
extern Widget 	gswidget;
extern void 	Finished (), AddTimeout (), AddNewConverter ();
extern void 	Yorn (), Alert (), InitAlert (), InitGS ();

/*------Static variables--------------------------------*/

static XrmOptionDescRec gscommand_options[] =
{
    {"-z", "*zoom", XrmoptionNoArg, (caddr_t) "False"},
    {"-r", "*columns", XrmoptionSepArg, (caddr_t) NULL},
    {"-n", "*gstitle", XrmoptionSepArg, (caddr_t) NULL},
    {"-t", "*gstimeout", XrmoptionSepArg, (caddr_t) NULL},
};

static XrmOptionDescRec alertcommand_options[] =
{
    {"-z", "*zoom", XrmoptionNoArg, (caddr_t) "False"},
};

/*
							*****************
							*		*
							*     MAIN	*
							*		*
							*****************
-------------------------------------------------------------------------
| Try to open the connection to the X server.  If OK initialise the 	|
| toolkit, otherwise drop into text only mode.  If toolkit initialised, |
| setup some global variables, load up some resources and decide from	|
| our name what utility to act like.	    	    	    	    	|
-------------------------------------------------------------------------
*/
int main (argc, argv)
int argc;
char *argv[];
{
    Arg arglist [10];
    unsigned int dummy;
    Window dummy_window;
    char * message;
    char * geometry;
    int i, len, start_arg;
    int alert_comm_size = XtNumber (alertcommand_options);
    int gs_comm_size = XtNumber (gscommand_options);
    char * disp = NULL;
    
    /* Note our base name */
    
    if ((progname = rindex (argv[0], '/')) == 0)
    	progname = argv[0];
    else
    	progname++;
	
    is_gs = strcmp (progname, "gs") == 0;

    /* See if the -display flag has been passed on the command line */
    
    for (i = 1;	i < argc; i++)
    	if (strcmp (argv[i], "-display") == 0)
	{
	    disp = argv[i + 1];
	    break;
	}

    /* Make sure server is up and running */
    
    if ((display = XOpenDisplay (disp)) == NULL)
    {
    	/* Cannot open display, go into text mode */
    	
	TextMode (argc, argv);
    }

    XCloseDisplay (display);
    
    AddNewConverter ();
    
    /* Initialise the toolkit */

    if ((a_widget = XtInitialize ("temp", CLASSNAME, 
    	    	    is_gs ? gscommand_options : alertcommand_options,
 		    is_gs ? gs_comm_size : alert_comm_size,
		    &argc, argv)) == NULL)
    {
    	(void) fprintf (stderr, "%s: Failed to initialise X toolkit\n", progname);
	TextMode (argc, argv);
    }
    
    display = XtDisplay (a_widget);
    root_window = DefaultRootWindow (display);
    screen_number = DefaultScreen (display);
    screen = DefaultScreenOfDisplay (display);

    /* Find out size of root window */
    
    if (!XGetGeometry (display, 
    	    	       root_window,
		       &dummy_window, 
		       &dummy, 
		       &dummy, 
		       &root_width, 
		       &root_height,
		       &dummy, 
		       &dummy))
    {
    	/* If couldn't obtain size of root window, use the macros instead */
	
	root_width = WidthOfScreen (screen);
	root_height = HeightOfScreen (screen);
    }

    /* Read what font to use and some other resource values */

    InitFontAndResources ();

    /* Check the number of command line options are OK */
    
    if ((!is_gs && argc < 3) || 
    	(is_gs && ((cols != 0 && argc < 3) || 
	(cols == 0 && argc < 2))))
    	Usage ();

    /* If the toplevel widget has been given a geometry string pass it on
       to the other toplevel widgets */
       
    XtSetArg (arglist[0], XtNgeometry, &geometry);
    XtGetValues (a_widget, arglist, 1);

    /* We are called 'gs', so start acting like it */
    
    if (is_gs)
    {
    	/* If the -r flag has been given then the first arg in the argv list
       	   must be the number of lines */
       
    	if (cols == 0)
    	    start_arg = 0;
    	else
    	{
    	    start_arg = 1;

	    if (sscanf (argv[1], "%d", &lines) != 1)
	    	Usage ();
    	}
    
    	/* Message may have been given as lots of seperate arguments.
       	   Copy them into one long string */

    	len = strlen (argv[start_arg + 1]) + 1;
    	message = XtMalloc (len);
    
    	(void) strcpy (message, argv[start_arg + 1]);

    	for (i = start_arg + 2; i < argc; i++)
    	{
    	    if (strlen (argv[i]) + strlen (message) + 2 > len)
	    	/* Need more space for the string */
    	    	message = XtRealloc (message, 
		    	    	     len = len + strlen (argv[i]) + 2);
	    
	    (void) strcat (message, " ");
    	    (void) strcat (message, argv[i]);
    	}

	/* Initialise the gs widgets */
	
    	InitGS (message, geometry);
    
    	XtSetArg (arglist[0], XtNtitle, title);
    	XtSetValues (gswidget, arglist, 1);

    	/* Add an event handler to set a timer going on the first
	   MapNotify event if a timeout has been specified for gs */
	
	if (timeout)
    	    XtAddEventHandler (gswidget, 
	    	    	       StructureNotifyMask, 
			       False, 
			       AddTimeout, 
    	    	    	       (caddr_t) NULL);
			       
    	XtPopup (gswidget, XtGrabExclusive);
	XDefineCursor (display, XtWindow (gswidget), arrow_cursor);
    }
    else
    {
    	/* Initialise the widgets for the yorn and alert boxes */
	
	InitAlert (geometry);
    
    	XtSetArg (arglist[0], XtNtitle, argv[1]);
    	XtSetValues (alertwidget, arglist, 1);

    	/* Message may have been given as lots of seperate arguments.
       	   Copy them into one long string */

    	len = strlen (argv[2]) + EXTRABIT + 1;
    	message = XtMalloc (len);
    
    	(void) strcpy (message, argv[2]);

    	for (i = 3; i < argc; i++)
    	{
    	    if (strlen (argv[i]) + strlen (message) + 2 > len)
	    	/* Need more space for the string */
    	    	message = XtRealloc (message, 
		    	    	     len = len + strlen (argv[i]) +
	    	    	    	    	   EXTRABIT + 2);
	    (void) strcat (message, " ");
    	    (void) strcat (message, argv[i]);
    	}
    
    	/* If we are called 'alert' act like alert otherwise act like yorn */
	
	if (strcmp (progname, "alert") == 0)
    	    Alert (message);
    	else
    	    Yorn (message);
    }
    
    /* Wait for events to arrive and act on them */
    
    XtMainLoop ();
}

/*
							*****************
							*		*
							*  ADDTIMEOUT	*
							*		*
							*****************
-------------------------------------------------------------------------
| Set a timer going on the first MapNotify event to be received from the|
| server.   	    	    	    	    	    	    	    	|
-------------------------------------------------------------------------
*/
/*ARGSUSED*/
void AddTimeout (widget, client_data, event)
Widget widget;
caddr_t client_data;
XMapEvent * event;
{
    static int set = False;
    
    if (!set && event->type == MapNotify)
    {
    	set = True;
	
	/* Add a dummy timeout value to stop a core dump with an early
	   X11R2 toolkit issue */
	   
	XtAddTimeOut ((unsigned long) 0xffffffff, Finished, (caddr_t) NULL);
    	XtAddTimeOut ((unsigned long) (timeout * 1000), Finished, 
	    	    	    	    	    	    	    (caddr_t) NULL);
    }
}

/*
							*****************
							*		*
							*INITFONTANDRESOURCES*
							*		*
							*****************
-------------------------------------------------------------------------
| Looks up default font to use from toolkit database, loads it  and 	|
| fills in a pointer to the font's structure.  	    	    	    	|
| and look up the icon height						|
-------------------------------------------------------------------------
*/
static void InitFontAndResources ()
{
    static char * sfont;
    static Boolean truezoom = True;
    static int zero = 0;
    static Cursor left_ptr;
    
    static XtResource resources[] = {
    	{XtNfont, XtCFont, XtRString, (Cardinal) sizeof (char *),
	 (Cardinal) &sfont, XtRString, (caddr_t) NULL},
    	
    	{XtNcursor, XtCCursor, XtRCursor, sizeof (Cursor),
	 (Cardinal) &arrow_cursor, XtRCursor, (caddr_t) &left_ptr},
    	
	{"zoom", "Zoom", XtRBoolean, (Cardinal) sizeof (Boolean),
	 (Cardinal) &zoom, XtRBoolean, (caddr_t) &truezoom},
	
	{"columns", "Columns", XtRInt, (Cardinal) sizeof (int),
	 (Cardinal) &cols, XtRInt, (caddr_t) &zero},

	{"gstimeout", "Timeout", XtRInt, (Cardinal) sizeof (int),
	 (Cardinal) &timeout, XtRInt, (caddr_t) 0},

	{"gstitle", "Title", XtRString, (Cardinal) sizeof (char *),
	 (Cardinal) &title, XtRString, (caddr_t) "Get String"},

	{"alertsym", "Alertsym", XtRString, (Cardinal) sizeof (char *),
	 (Cardinal) &alertsym_name, XtRString, (caddr_t) 0},

	{"yornsym", "Yornsym", XtRString, (Cardinal) sizeof (char *),
	 (Cardinal) &yornsym_name, XtRString, (caddr_t) 0},
	
	{"ticksym", "Ticksym", XtRString, (Cardinal) sizeof (char *),
	 (Cardinal) &ticksym_name, XtRString, (caddr_t) 0},

	{"crosssym", "Crosssym", XtRString, (Cardinal) sizeof (char *),
	 (Cardinal) &crosssym_name, XtRString, (caddr_t) 0},

	{"oksym", "Oksym", XtRString, (Cardinal) sizeof (char *),
	 (Cardinal) &oksym_name, XtRString, (caddr_t) 0},
    };
    
    sysfont = (XFontStruct *) NULL;
    left_ptr = XtGetCursor (display, XC_left_ptr);
    
    XtGetApplicationResources (a_widget, (caddr_t) 0, resources, 
    	    	    	    	    	    	XtNumber (resources), NULL, 0);

    /* If no resource (-font or -fn) specified use default font (serif10) */
    
    if (sfont == NULL)
    	sysfont = XLoadQueryFont (display, "serif10");
    else
    	sysfont = XLoadQueryFont (display, sfont);
    
    /* If one of the fonts don't exist, use fixed.  If that isn't there
       we've had it */
       
    if (sysfont == NULL)
	sysfont = XLoadQueryFont (display, "fixed");
    
    if (sysfont == NULL)
    {
	(void) fprintf (stderr, "%s: Suitable font cannot be found - giving up.",
	    	    	    progname);
    	exit (2);
    }
}

/*
							*****************
							*		*
							*READWIDGETCOLOURS*
							*		*
							*****************
-------------------------------------------------------------------------
| Read a widget's background and foreground (if it has one) colours.	|
-------------------------------------------------------------------------
*/

void ReadWidgetColours (widget, fore, back)
Widget widget;
Pixel *fore, *back;
{
    Arg args[2];
    
    /* Set up some defaults just in case we can't read any values */
    
    *fore = BlackPixel (display, screen_number);
    *back = WhitePixel (display, screen_number);
    
    XtSetArg (args[0], XtNforeground, fore);
    XtSetArg (args[1], XtNbackground, back);

    XtGetValues (widget, args, 2);
}

/*
							*****************
							*		*
							*     USAGE	*
							*		*
							*****************
-------------------------------------------------------------------------
| Too few command line arguments supplied, print out a usage string and |
| exit.	    	    	    	    	    	    	    	    	|
-------------------------------------------------------------------------
*/
void Usage ()
{
    if (is_gs)
    	(void) fprintf (stderr, "%s: Usage: %s [-z] [-r cols lines] [-n title] [-t seconds] message\n", 
	    	    	    progname, progname);
    else
    	(void) fprintf (stderr, "%s: Usage: %s [-z] title message\n", progname, progname);
	
    exit (2);
}
