/*

Copyright 1988 by the University of Guelph

Permission to use, copy and modify this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation.
University of Guelph makes no representations about the suitability of
this software for any purpose.  It is provided "as is"
without express or implied warranty.

*/

/*
 * Directory browser: builds a tree widget of a dir. subtree and supports
 * dir ops on any directory in the tree
 * The set of ops are defined by cmd line options
 * Gets dir subtree and builds file name panel for file name selection
 */
#include <X11/Xos.h>
#include <stdio.h>
#include <sys/dir.h>
#include <sys/param.h>
#include <sys/stat.h>
#include <sys/signal.h>
#include <X11/Xlib.h>
#include <X11/Xproto.h>
#include <X11/cursorfont.h>
#include <X11/Xatom.h>
#include <X11/Intrinsic.h>
#include <X11/IntrinsicP.h>
#include <X11/Atoms.h>
#include <X11/Cardinals.h>
#include <X11/Core.h>
#include <X11/CoreP.h>
#include <X11/Shell.h>
#include <X11/Viewport.h>
#include <X11/Box.h>
#include <X11/Command.h>
#include <X11/Icon.h>
#include <X11/ICommand.h>
#include <X11/Tree.h>
#include "../include/tar.h"
#include "../include/help.h"
#include "../include/bmenu.h"
#include "../include/atoms.h"
#include "../include/gshdirs.h"
#include "../include/Xtty.h"
#include "../include/xgshconf.h"
#include "../include/xgshstate.h"
#include "../include/dirb.h"

/*
 * Global vars.
 */
Widget toplevel;
extern Widget viewbox_w;
extern char name_dialogresp[MAXLABEL+1];
extern NameList *chainlp;
extern Widget name_vieww;
extern Widget name_dialogw;
extern Widget name_dialtextw;
extern int name_flags;
extern int name_cnt;
extern Widget name_w;
extern Widget newicon_w;
extern Widget noname_labelw;
extern Widget creatpopup_text();
extern void namectrl_input();
extern void fullname_input();
extern void name_input();
extern Widget build_menu();
char *dirb_fgr, *dirb_bgr;
Boolean dirb_iconflg;
void help_call();
NameList *creat_namelist();
static Pixel dirbfgr, dirbbgr;
static int xerr();
static Boolean defaultFALSE = FALSE;
static char *dirb_topdir;
static Boolean dirb_rmdir, dirb_chdir, dirb_rm, dirb_select, dirb_mkdir, dirb_rmsubt;
static char *dirb_chdirwin;
static Window dirbchdirwin;
static Atom dirb_dirprop;
static int name_xpos, name_ypos;
XFontStruct *basefont;
static Widget vieww;
Widget dirb_formw;
static char *tree_ops[10];
static int tree_opref[10];
int cur_op;
static int tree_numops;

/* defines for treeops */
#define LIST	1
#define	SELECT	2
#define	RM	3
#define	RMDIR	4
#define	RMSUBT	5
#define	CHDIR	6
#define	MKDIR	7

/* Defines for name */
#define	NAME_UP		0x00000001
#define	NEWNAME_UP	0x00000002

static Widget treeopsw;
static XtTranslations cmdtrn, bboxtrn, dirtrn;
static Widget treew;
static char *abdir, *dirpos;
static DirList *curdirlp;
static DirList *enddirlp;
HelpList helphead, popuphead;
static NameList namehead, namesel;
NameList *endlp, *endname;
static DirList dirhead;
static char blkstr[OUTSTRL+1];
static int ablen;
static void getto_dir();
static void rebuild_tree();
static void get_tree();
static void pullup_ab();
static XrmOptionDescRec options[] = {
	{"-topdir", "*dirbtopdir", XrmoptionSepArg, NULL},
	{"-chdirwin", "*dirbchdirwin", XrmoptionSepArg, NULL},
	{"-dirbfgr", "*dirbfgr", XrmoptionSepArg, NULL},
	{"-dirbbgr", "*dirbbgr", XrmoptionSepArg, NULL},
	{"-rmdir",      "*dirbrmdirflg", XrmoptionNoArg,"on"},
#ifdef notdef
	{"-rmsubt", "*dirbrmsubtflg", XrmoptionNoArg, "on"},
#endif
	{"-chdir",  "*dirbchdirflg", XrmoptionNoArg, "on"},
	{"-mkdir", "*dirbmkdirflg", XrmoptionNoArg, "on"},
#ifdef notdef
	{"-select", "*dirbselectflg", XrmoptionNoArg, "on"},
#endif
	{"-rmfile", "*dirbrmflg", XrmoptionNoArg, "on"},
	{"-iconctrl", "*dirbiconflg", XrmoptionNoArg, "on"},
};
static XtResource appl_res[] = {
	{"dirbtopdir", "Dirbtopdir", XtRString, sizeof(char *),
	(Cardinal)&dirb_topdir, XtRString, NULL},
	{"dirbchdirwin", "Dirbchdirwin", XtRString, sizeof(char *),
	(Cardinal)&dirb_chdirwin, XtRString, NULL},
	{"dirbfgr", "Dirbfgr", XtRString, sizeof(char *),
	(Cardinal)&dirb_fgr, XtRString, "black"},
	{"dirbbgr", "Dirbbgr", XtRString, sizeof(char *),
	(Cardinal)&dirb_bgr, XtRString, "white"},
	{"dirbrmdirflg", "Dirbrmdirflg", XtRBoolean, sizeof(Boolean),
	(Cardinal)&dirb_rmdir,
	XtRBoolean, (caddr_t) &defaultFALSE},
	{"dirbrmsubtflg", "Dirbrmsubtflg", XtRBoolean, sizeof(Boolean),
	(Cardinal)&dirb_rmsubt,
	XtRBoolean, (caddr_t) &defaultFALSE},
	{"dirbchdirflg", "Dirbchdirflg", XtRBoolean, sizeof(Boolean),
	(Cardinal)&dirb_chdir,
	XtRBoolean, (caddr_t) &defaultFALSE},
	{"dirbmkdirflg", "Dirbmkdirflg", XtRBoolean, sizeof(Boolean),
	(Cardinal)&dirb_mkdir,
	XtRBoolean, (caddr_t) &defaultFALSE},
	{"dirbselectflg", "Dirbselectflg", XtRBoolean, sizeof(Boolean),
	(Cardinal)&dirb_select,
	XtRBoolean, (caddr_t) &defaultFALSE},
	{"dirbrmflg", "Dirbrmflg", XtRBoolean, sizeof(Boolean),
	(Cardinal)&dirb_rm,
	XtRBoolean, (caddr_t) &defaultFALSE},
	{"dirbiconflg", "Dirbrmflg", XtRBoolean, sizeof(Boolean),
	(Cardinal)&dirb_iconflg,
	XtRBoolean, (caddr_t) &defaultFALSE},
};
int get_name();
static int getfilenames();
static int getdirnames();

/*
 * Tree dir ops menu input
 * Do the operation
 */
static void tree_input(pos)
	int pos;
{
	int op, i;
	NameList *lp;
	static int xpos, ypos;
	static Arg getpos[] = {
		{XtNx,		(XtArgVal) &xpos},
		{XtNy,		(XtArgVal) &ypos},
	};
	static Arg setpos[] = {
		{XtNx,		(XtArgVal) NULL},
		{XtNy,		(XtArgVal) NULL},
	};

	cur_op = op = tree_opref[pos];
	lp = &namehead;
	i = 0;
	/* Start the op */
	switch(op) {
	case LIST:
	case SELECT:
		getfilenames((R_OK), ((~S_IFDIR) & S_IFMT), &lp, &i);
		endlp = lp;
		setnameget(&namehead, i, &namesel);
		break;
	case RM:
		getfilenames((W_OK), ((~S_IFDIR) & S_IFMT), &lp, &i);
		endlp = lp;
		setnameget(&namehead, i, &namesel);
		break;
	case RMDIR:
	case RMSUBT:
		getfilenames(W_OK, S_IFDIR, &lp, &i);
		endlp = lp;
		setnameget(&namehead, i, &namesel);
		break;
	case CHDIR:
		if (*abdir != '/' || dirbchdirwin == 0 ||
		    (i = strlen(abdir)) > XtDisplay(toplevel)->max_request_size) {
			err("Can't do Chdir");
			return;
		}
		XChangeProperty(XtDisplay(toplevel), dirbchdirwin, dirb_dirprop,
			XA_STRING, 8, PropModeReplace, abdir, i+1);
		break;
	case MKDIR:
		endlp = lp;
		chainlp = &namesel;
		namesel.l_next = NULL;
		name_cnt = 0;
		/* Pop up the new name panel */
		XtGetValues(name_w, getpos, 2);
		setpos[0].value = (XtArgVal)(xpos+30);
		setpos[1].value = (XtArgVal)(ypos+100);
		XtSetValues(name_dialogw, setpos, 2);
		XtTextErase(name_dialtextw);
		name_flags |= NEWNAME_UP;
		XtPopup(name_dialogw, XtGrabNone);
		warp_pointer(name_dialtextw);
		break;
	};
}

/*
 * Callback from dir cmd button, mostly cd to dir.
 */
static void getto_dir(w, p1, p2)
	Widget w;
	caddr_t p1, p2;
{
	register DirList *lp, *lp2;
	register char *p;
	Widget tw, pw;
static char dirpat[1025];

	/* Handle other input */
	lp = (DirList *)p1;
	if (*p2 != NULL) {
		if (*p2 == 'H') {
			popup_help(&(helphead), &(popuphead), w);
		}
		if (*p2 == 'P') {
			/* Popup the full name */
			pw = creatpopup_text(dirb_formw, lp->l_name, dirb_fgr, dirb_bgr,
				&tw);
			XtOverrideTranslations(tw, XtParseTranslationTable(
				"<Btn3Down>: enablenotify() \n\
				<Btn3Up>: notify(Down) disablenotify()"));
			XtAddCallback(tw, XtNcallback, fullname_input,
				(caddr_t) pw);
			popup_text(pw, -1, -1, 0);
		}
		return;
	}
	/*
	 * Set up pointers for traversal:
	 * lp - starts where you want to go
	 * lp2 - starts where you currently are
	 * both move up to common ancestor
	 * with lp leaving back trail in l_childir
	 * follow l_childir trail down.
	 */
	lp->l_childir = NULL;
	lp2 = curdirlp;
	/* if current below level of desired, move current up */
	while (lp2->l_level > lp->l_level) {
		chdir("..");
		p = dirpos-2;
		while (p > abdir && *p != '/')
			p--;
		if (*p == '/') {
			*++p = '\0';
			dirpos = p;
		}
		lp2 = lp2->l_pardir;
	}
	/* If desired below current, move desired up */
	while (lp2->l_level < lp->l_level) {
		lp->l_pardir->l_childir = lp;
		lp = lp->l_pardir;
	}
	/* Now at same level, move both up until common ancestor */
	while (lp2 != lp) {
		chdir("..");
		p = dirpos-2;
		while (p > abdir && *p != '/')
			p--;
		if (*p == '/') {
			*++p = '\0';
			dirpos = p;
		}
		lp2 = lp2->l_pardir;
		lp->l_pardir->l_childir = lp;
		lp = lp->l_pardir;
	}
	/* Now follow back trail down to desired */
	while (lp->l_childir != NULL) {
		lp = lp->l_childir;
		chdir(lp->l_name);
		while ((ablen-(dirpos-abdir)-2) < lp->l_len)
			pullup_ab();
		if (*(dirpos-1) != '/')
			*dirpos++ = '/';
		bcopy(lp->l_name, dirpos, lp->l_len);
		dirpos += lp->l_len;
		*dirpos++ = '/';
		*dirpos = '\0';
	}
	/* Finally save new current dir */
	curdirlp = lp;
}

/*
 * Called to expand the absolute path buffer (doubles each time)
 */
static void pullup_ab()
{
	int len;
	char *p;

	ablen *= 2;
	len = dirpos-abdir;
	p = XtMalloc(ablen+1);
	bcopy(abdir, p, len+1);
	XtFree(abdir);
	abdir = p;
	dirpos = p+len;
}

/*
 * Input to command panel control buttons
 */
static void cmdbut_input(w, p1, p2)
	Widget w;
	caddr_t p1, p2;
{
	int i;

	if (p2 != NULL) {
		if (*p2 == 'H') {
			popup_help(&(helphead), &(popuphead), w);
		}
		return;
	}
	i = (int) p1;
	switch(i) {
	case 0:
		exit();
	case 1:
		reset_names();
		reset_dir();
		break;
	case 2:
		reset_names();
		do_op();
		break;
	case 3:
		break;
	};
}

/*
 * Initialize the tree.
 */
init_tree()
{
	register DirList *lp;
	int i;
	Widget vw;
	Widget titw, fbw;
	XtTranslations viewtrn;
	static int wid, high;
	static Arg getsiz[] = {
		{XtNwidth,	(XtArgVal) &wid},
		{XtNheight,	(XtArgVal) &high},
	};
	static char cmdtrans[] =
		"<Btn3Down>:	enablenotify() \n\
		<Btn3Up>:	notify(Pop) disablenotify()";
	static char viewtrans[] =
		"<Btn2Down>:	enablenotify() \n\
		 <Btn2Up>:	notify(Help) disablenotify()";
	static char bboxtrans[] =
		"<Btn2Down>:	enablenotify() \n\
		 <Btn2Up>:	notify(Help) disablenotify()";
	static char dirtrans[] =
	"<Btn1Down>: enablenotify() notify() disablenotify() MenuPopup(Dirops) \n\
	<Btn3Down>: enablenotify() \n\
	<Btn3Up>:   notify(Pop) disablenotify() \n\
	<EnterWindow>:	highlight() \n\
	<LeaveWindow>:	unset(NoRedisplay) disablenotify() unhighlight()";
	static XtCallbackRec viewcall[] = {
		{help_call,	NULL},
		{NULL,		NULL},
	};
	static Arg viewlist[] = {
		{XtNborderColor,	(XtArgVal) NULL},
		{XtNbackground,		(XtArgVal) NULL},
		{XtNfromVert,		(XtArgVal) NULL},
		{XtNfromHoriz,		(XtArgVal) NULL},
		{XtNtop,		(XtArgVal) XtChainTop},
		{XtNallowVert,		(XtArgVal) True},
		{XtNallowHoriz,		(XtArgVal) True},
	};
	static Arg viewsiz[] = {
		{XtNwidth,		(XtArgVal) NULL},
	};
	static Arg formsiz[] = {
		{XtNheight,		(XtArgVal) NULL},
	};
	Widget cw1, cw2, cw3;

	/* Init global vars */
	name_w = NULL;
	dirbfgr = init_colour(dirb_fgr);
	dirbbgr = init_colour(dirb_bgr);
	namehead.l_next = NULL;
	endlp = &(namehead);
	for (i = 0; i < OUTSTRL; i++)
		blkstr[i] = ' ';
	blkstr[OUTSTRL] = '\0';
	i = 0;
	lp = &dirhead;
	dirhead.l_widg = NULL;
	dirhead.l_next = NULL;
	dirhead.l_pardir = NULL;
	viewtrn = XtParseTranslationTable(viewtrans);
	bboxtrn = XtParseTranslationTable(bboxtrans);
	cmdtrn = XtParseTranslationTable(cmdtrans);
	dirtrn = XtParseTranslationTable(dirtrans);
	title_creat(toplevel, dirb_fgr, dirb_bgr, 0,
		"Dirb", cmdbut_input, &(helphead),
		dirb_iconflg, NULL, NULL, 0, 0,
		&dirb_formw, &cw1, &cw2, &cw3, &fbw, &titw);
	/* and the viewport widget inside it */
	viewlist[0].value = (XtArgVal) dirbfgr;
	viewlist[1].value = (XtArgVal) dirbbgr;
	viewlist[2].value = (XtArgVal) cw1;
	vieww = XtCreateManagedWidget("view", viewportWidgetClass,
		dirb_formw, viewlist, XtNumber(viewlist));
}

reset_dir()
{

	namesel.l_selnext = NULL;
	endlp = &(namehead);
	name_cnt = 0;
}

/*
 * Get directory names from the subtree
 */
static int getdirnames(pdir, level, listp, dirname, num)
	DirList *pdir;
	int level;
	DirList **listp;
	char *dirname;
	int *num;
{
	register DirList *lp;
	register struct direct *dp, *dp2;
	register DirList *lp2;
	register int j;
	DIR *dirp, *dirp2;
	unsigned long ino;
	static struct stat sb;
	static XtCallbackRec cmdcall[] = {
		{getto_dir,	NULL},
		{NULL,		NULL},
	};
	static Arg cmdlist[] = {
		{XtNtranslations,	(XtArgVal) NULL},
		{XtNlabel,		(XtArgVal) NULL},
		{XtNcallback,		(XtArgVal) cmdcall},
	};
	static Arg setparent[] = {
		{XtNwidget,		(XtArgVal) NULL},
	};

	/* Chdir into the subdir. */
	if (access(dirname, (X_OK)) < 0)
		return(0);
	if (*dirname != '.' || *(dirname+1) != '\0') {
		if (chdir(dirname) < 0)
			return(0);
	}
	/* First, find out who we really are */
	if (stat(".", &sb) < 0)
		return(0);
	ino = sb.st_ino;
	if ((dirp = opendir(".")) == NULL)
		return(0);
	/* Initialize cmdlist fields that don't vary */
	cmdlist[0].value = (XtArgVal) dirtrn;
	lp2 = lp = *listp;
	j = *num;
	/* Loop thru a dir looking for names and dirs */
	while ((dp = readdir(dirp)) != NULL) {
		/* Now, check out the name to see if we want it */
		if (strcmp(".", dp->d_name) != 0 && strcmp("..", dp->d_name)
			!= 0 && stat(dp->d_name, &sb) >= 0 &&
			(sb.st_mode & S_IFDIR) &&
			access(dp->d_name, (X_OK)) == 0) {
			/* Iff its .. entry doesn't point back to me,
				forget it!! */
			if ((dirp2 = opendir(dp->d_name)) == NULL)
				continue;
			while ((dp2 = readdir(dirp2)) != NULL)
				if (strcmp(dp2->d_name, "..") == 0)
					break;
			if (dp2 == NULL || dp2->d_ino != ino) {
				closedir(dirp2);
				continue;
			}
			closedir(dirp2);
			/* Alloc DirList element, as required */
			lp->l_next = (DirList *)XtMalloc(sizeof(DirList));
			lp = lp->l_next;
			lp->l_childir = NULL;
			lp->l_next = NULL;
			/* Now set name and label */
			lp->l_level = level;
			lp->l_pardir = pdir;
			bcopy(dp->d_name, lp->l_name, dp->d_namlen+1);
			lp->l_len = dp->d_namlen;
			if (dp->d_namlen > MAXLABEL) {
				bcopy(dp->d_name, lp->l_label, MAXLABEL-2);
				lp->l_label[MAXLABEL-2] = lp->l_label[MAXLABEL-1] = '.';
				lp->l_label[MAXLABEL] = '\0';
			} else {
				bcopy(dp->d_name, lp->l_label, dp->d_namlen);
				bcopy(blkstr, lp->l_label+dp->d_namlen, MAXLABEL-dp->d_namlen);
				lp->l_label[MAXLABEL] = '\0';
			}
			/* And create the command button */
			cmdlist[1].value = (XtArgVal) lp->l_label;
			setparent[0].value = (XtArgVal) pdir->l_widg;
			XtSetValues(treew, setparent, 1);
			cmdcall[0].closure = (caddr_t) lp;
			lp->l_widg = XtCreateManagedWidget("cmd",
				commandWidgetClass, treew, cmdlist,
				XtNumber(cmdlist));
			j++;
		}
	}
	/* Update ret vals. */
	*num = j;
	*listp = lp;
	closedir(dirp);
	/* Iff subdirs, recurse thru subdirs */
	while (lp2 != lp) {
		lp2 = lp2->l_next;
		getdirnames(lp2, level+1, listp, lp2->l_name, num);
	}
	/* pop back up a dir level */
	if (*dirname != '.' || *(dirname+1) != '\0') {
		chdir("..");
	}
}

/*
 * Get file names in a dir
 */
static int getfilenames(acc_modes, modes, listp, num)
	int acc_modes;
	unsigned short modes;
	NameList **listp;
	int *num;
{
	register NameList *lp;
	register struct direct *dp;
	register int j;
	DIR *dirp;
	static struct stat sb;

	if ((dirp = opendir(".")) == NULL)
		return(0);
	lp = *listp;
	j = *num;
	/* Loop thru a dir looking for names and dirs */
	while ((dp = readdir(dirp)) != NULL) {
		/* Now, check out the name to see if we want it */
		if (stat(dp->d_name, &sb) < 0)
			continue;
		if (access(dp->d_name, acc_modes) == 0 &&
			(sb.st_mode & modes)) {
			/* If Dir . or .. skip */
			if ((sb.st_mode & S_IFDIR) &&
				(strcmp(".", dp->d_name) == 0 ||
				 strcmp("..", dp->d_name) == 0))
				continue;
			/* Alloc NameList element, as required */
			if (lp->l_next == NULL)
				lp = creat_namelist();
			else
				lp = lp->l_next;
			/* Now set name and label */
			bcopy((caddr_t)&sb, (caddr_t)&(lp->l_statb), sizeof(sb));
			bcopy(dp->d_name, lp->l_name, dp->d_namlen+1);
			if (dp->d_namlen > MAXLABEL) {
				bcopy(dp->d_name, lp->l_label, MAXLABEL-2);
				lp->l_label[MAXLABEL-2] = lp->l_label[MAXLABEL-1] = '.';
				lp->l_label[MAXLABEL] = '\0';
			} else {
				bcopy(dp->d_name, lp->l_label, dp->d_namlen);
				bcopy(blkstr, lp->l_label+dp->d_namlen, MAXLABEL-dp->d_namlen);
				lp->l_label[MAXLABEL] = '\0';
			}
			j++;
		}
	}
	/* Update ret vals. */
	*num = j;
	*listp = lp;
	closedir(dirp);
}

/*
 * Creates new NameList elements and fills in widgets
 *   widgets are not managed until setnameget does it
 */
NameList *creat_namelist()
{
	register NameList *lp, *lp2;
	register int i;
	NameList *lp3;
	Widget *wp, *wp2;
	Widget tw, fw, vw;
	char geom[50];
	int widv;
	static char viewtrans[] =
		"<Btn2Down>:	enablenotify() \n\
		 <Btn2Up>:	notify(Help) disablenotify()";
	static char bboxtrans[] =
		"<Btn2Down>:	enablenotify() \n\
		 <Btn2Up>:	notify(Help) disablenotify()";
	static XtCallbackRec	helpcall[] = {
		{ help_call,	NULL },
		{ NULL,		NULL },
	};
	static Arg viewlist[] = {
		{XtNborderColor,	(XtArgVal) NULL},
		{XtNbackground,		(XtArgVal) NULL},
		{XtNfromVert,		(XtArgVal) NULL},
		{XtNfromHoriz,		(XtArgVal) NULL},
		{XtNtop,		(XtArgVal) XtChainTop},
		{XtNallowVert,		(XtArgVal) True},
	};
	static Arg		viewtitlelist[] = {
		{XtNforeground,	(XtArgVal) NULL},
		{XtNbackground,	(XtArgVal) NULL},
		{XtNwidth,	(XtArgVal) NULL},
		{XtNlabel,	(XtArgVal) "Name Selections"},
	};
	static Arg		bboxlist[] = {
		{XtNborderWidth,	(XtArgVal)NULL},
		{XtNbackground,		(XtArgVal)NULL},
		{XtNtranslations,	(XtArgVal)NULL},
		{XtNwidth,		(XtArgVal)NULL},
		{XtNheight,		(XtArgVal)NULL},
		{XtNcallback,		(XtArgVal)helpcall},
	};
	static Arg popup_args[] = {
		{XtNx, (XtArgVal) NULL},
		{XtNy, (XtArgVal) NULL},
		{XtNgeometry, (XtArgVal) NULL},
		{XtNallowShellResize, (XtArgVal) False},
		{XtNsaveUnder, (XtArgVal) True},
	};
	static XtCallbackRec cmdcall[] = {
		{name_input,	NULL},
		{NULL,		NULL},
	};
	static Arg labellist[] = {
		{XtNforeground,	(XtArgVal) NULL},
		{XtNbackground, (XtArgVal) NULL},
		{XtNwidth,	(XtArgVal) NULL},
		{XtNfont,	(XtArgVal) NULL},
		{XtNborderWidth, (XtArgVal) 0},
	};
	static Arg nonamelist[] = {
		{XtNforeground,	(XtArgVal) NULL},
		{XtNbackground, (XtArgVal) NULL},
		{XtNwidth,	(XtArgVal) NULL},
		{XtNlabel,	(XtArgVal) NONAMEMSG},
	};
	static Arg cmdlist[] = {
		{XtNforeground,	(XtArgVal) NULL},
		{XtNbackground, (XtArgVal) NULL},
		{XtNwidth,	(XtArgVal) NULL},
		{XtNfont,	(XtArgVal) NULL},
		{XtNcallback,	(XtArgVal) cmdcall},
	};
	Widget cw1, cw2, cw3;

	/* If one exists, delete name panel */
	if (name_w != NULL) {
		XtDestroyWidget(name_w);
	}
	/* Create name selection popup panel */
	widv = basefont->max_bounds.width;
	labellist[2].value = (XtArgVal) (MAXPREFIX*widv+20);
	cmdlist[2].value = (XtArgVal) (MAXLABEL*widv+20);
	nonamelist[2].value = viewtitlelist[2].value = labellist[2].value+cmdlist[2].value;
	labellist[3].value = cmdlist[3].value = (XtArgVal) basefont;
	widv = viewtitlelist[2].value+40;
	sprintf(geom, "%dx%d+%d+%d", widv, NAMEHEIGHT, name_xpos, name_ypos);
	popup_args[2].value = (XtArgVal) geom;
	name_w = XtCreatePopupShell("names", transientShellWidgetClass,
		dirb_formw, popup_args, XtNumber(popup_args));
	title_creat(name_w, dirb_fgr, dirb_bgr, widv-10,
		"Files", namectrl_input, &(helphead),
		dirb_iconflg, NULL, NULL,
		0, 0,
		&fw, &cw1, &cw2, &cw3, &newicon_w, &tw);
	viewlist[0].value = (XtArgVal) dirbfgr;
	viewlist[1].value = (XtArgVal) dirbbgr;
	viewlist[2].value = (XtArgVal) cw1;
	name_vieww = vw = XtCreateManagedWidget("nview", viewportWidgetClass, fw,
		viewlist, XtNumber(viewlist));
	/* and a button box in the viewport for the names and prefixes */
	viewtitlelist[0].value = bboxlist[0].value = (XtArgVal) dirbfgr;
	viewtitlelist[1].value = bboxlist[1].value = (XtArgVal) dirbbgr;
	bboxlist[2].value = (XtArgVal) XtParseTranslationTable(bboxtrans);
	viewbox_w = XtCreateManagedWidget("viewb", boxWidgetClass, vw,
		bboxlist, XtNumber(bboxlist));
	add_help("Files.View", &helphead, viewbox_w);
	/* And title in buttonbox (mainly for width) */
	XtCreateManagedWidget("viewtitle", labelWidgetClass, viewbox_w,
		viewtitlelist, XtNumber(viewtitlelist));
	nonamelist[0].value = (XtArgVal) dirbfgr;
	nonamelist[1].value = (XtArgVal) dirbbgr;
	noname_labelw = XtCreateWidget("noname", labelWidgetClass, viewbox_w,
		nonamelist, XtNumber(nonamelist));
	/* Create NAMEBLOCK more namelist entries */
	lp2 = endname;
	labellist[0].value = (XtArgVal) dirbfgr;
	labellist[1].value = (XtArgVal) dirbbgr;
	cmdlist[0].value = (XtArgVal) dirbfgr;
	cmdlist[1].value = (XtArgVal) dirbbgr;
	for (i = 0; i < NAMEBLOCK; i++) {
		lp = (NameList *)XtMalloc(sizeof(NameList));
		if (i == 0)
			lp3 = lp;
		lp2->l_next = lp;
		lp2 = lp;
		lp->l_flags = 0;
	}
	endname = lp;
	lp->l_next = NULL;
	lp = namehead.l_next;
	i = 0;
	while (lp != NULL) {
		cmdcall[0].closure = (caddr_t) lp;
		lp->l_w = XtCreateWidget("labw", commandWidgetClass, viewbox_w,
			cmdlist, XtNumber(cmdlist));
		XtOverrideTranslations(lp->l_w, cmdtrn);
		lp = lp->l_next;
		i++;
	}
	lp = namehead.l_next;
	wp = wp2 = (Widget *)XtMalloc(i*sizeof(Widget));
	while (lp != NULL) {
		*wp++ = lp->l_w;
		lp = lp->l_next;
	}
	XtManageChildren(wp2, i);
	XtRealizeWidget(name_w);
	XtUnmanageChildren(wp2, i);
	return(lp3);
}

/*
 * The main procedure, get to correct dir. and call init_tree
 * followed by the input loop
 */
main(argc, argv)
	int argc;
	char *argv[];
{
	register char *p1, *p2;
	register int len;
	register int i;
	Boolean addslash;
	int wid, hig;
	Atom rcurs;
	static char helpname[MAXPATHLEN+1];

	/* First, find any geometry spec to use for info */
	name_xpos = name_ypos = 0;
	for (i = 0; i < (argc-1); i++) {
		if (strcmp(argv[i], "-geometry") == 0) {
			XParseGeometry(argv[i+1], &name_xpos, &name_ypos,
				&wid, &hig);
			break;
		}
	}
	name_xpos += 20;
	name_ypos += 15;
	/* Initialize Xt */
	toplevel = XtInitialize("main","DIrb",options,XtNumber(options),
		&argc, argv);
	XtGetApplicationResources(toplevel, 0, appl_res, XtNumber(appl_res),
		NULL, 0);
	XSetErrorHandler(xerr);
	/* Get the window that has the abdir property, iff any */
	if (dirb_chdirwin == NULL || sscanf(dirb_chdirwin, "%X", &dirbchdirwin)
		!= 1  ||
		(dirb_dirprop = XInternAtom(XtDisplay(toplevel),A_ABDIR,False))
		== None || (rcurs = XInternAtom(XtDisplay(toplevel),A_RESETCURSOR,
		False)) == None)
		dirbchdirwin = 0;
	/* Get font */
	basefont = XLoadQueryFont(XtDisplay(toplevel), FONT);
	if (dirb_topdir != NULL)
		if (chdir(dirb_topdir) < 0)
			dirb_topdir = NULL;
	if (dirb_topdir != NULL && *dirb_topdir == '/') {
		len = strlen(dirb_topdir);
		if (*(dirb_topdir+len-1) != '/') {
			len++;
			addslash = True;
		} else {
			addslash = False;
		}
		ablen = ((len/MYMAXPATHLEN)+1)*MYMAXPATHLEN;
		abdir = XtMalloc(ablen+1);
		if (addslash) {
			bcopy(dirb_topdir, abdir, len-1);
			*(abdir+len-1) = '/';
			*(abdir+len) = '\0';
		} else {
			bcopy(dirb_topdir, abdir, len+1);
		}
		dirpos = abdir+len;
	} else {
		ablen = MAXPATHLEN;
		abdir = XtMalloc(ablen+1);
		/* WRONG, an absolute path shouldn't start with . but */
		if (getwd(abdir) == 0)
			bcopy("./", abdir, 3);
		len = strlen(abdir);
		if (*(abdir+len-1) != '/') {
			*(abdir+len) = '/';
			*(abdir+len+1) = '\0';
			len++;
		}
		dirpos = abdir+len;
		dirb_topdir = XtMalloc(len+1);
		bcopy(abdir, dirb_topdir, len+1);
	}
	/* Init help library */
	strcpy(helpname, HELPDIR);
	strcat(helpname, "dirb.hlp");
	init_help(helpname, &helphead, &popuphead, dirb_fgr, dirb_bgr);
	endname = &(namehead);
	/* Build dir ops menu */
	tree_ops[0] = "List";
	tree_opref[0] = LIST;
	i = 1;
	if (dirb_select) {
		tree_opref[i] = SELECT;
		tree_ops[i++] = "Select";
	}
	if (dirb_chdir) {
		tree_opref[i] = CHDIR;
		tree_ops[i++] = "Chdir";
	}
	if (dirb_mkdir) {
		tree_opref[i] = MKDIR;
		tree_ops[i++] = "Mkdir";
	}
	if (dirb_rmdir) {
		tree_opref[i] = RMDIR;
		tree_ops[i++] = "Rmdir";
	}
	if (dirb_rm) {
		tree_opref[i] = RM;
		tree_ops[i++] = "Rm Files";
	}
	if (dirb_rmsubt) {
		tree_opref[i] = RMSUBT;
		tree_ops[i++] = "Rm Subtree";
	}
	tree_ops[i] = NULL;
	tree_numops = i;
	treeopsw = build_menu("Dirops", tree_ops,
		tree_numops, tree_input, dirb_fgr, dirb_bgr,
		100, BM_SPRUNG);
	init_tree();
	init_names();
	init_err(dirb_formw, False, dirb_fgr, dirb_bgr);
	help_setparent(dirb_formw);
	get_tree();
	creat_namelist();
	XtRealizeWidget(toplevel);
	/* Set help parent to other than toplevel so menu doesn't get lost */
	help_setparent(dirb_formw);
	/*
	 * Should not be necessary, but i'm paranoid
	 */
	if ((dirpos-abdir) <= MYMAXPATHLEN && *abdir == '/')
		chdir(abdir);
	/* Tell xgsh to reset cursor */
	if (dirbchdirwin != 0)
		XChangeProperty(XtDisplay(toplevel), dirbchdirwin, rcurs,
			XA_STRING, 8, PropModeReplace, "Default", 8);
	/* Set the cursor for a voyage.. */
	XDefineCursor(XtDisplay(toplevel),XtWindow(toplevel),
		XCreateFontCursor(XtDisplay(toplevel), XC_trek));
	XtMainLoop();
}

/*
 * Get a subtree and put up the widget
 */
static void get_tree()
{
	register int len;
	DirList *lp;
	int i;
	char *p;
	static struct stat sb;
	static XtCallbackRec cmdcall[] = {
		{getto_dir,	NULL},
		{NULL,		NULL},
	};
	static Arg cmdlist[] = {
		{XtNtranslations,	(XtArgVal) NULL},
		{XtNlabel,		(XtArgVal) NULL},
		{XtNcallback,		(XtArgVal) cmdcall},
	};
	static Arg bboxlist[] = {
		{XtNborderColor,	(XtArgVal) NULL},
		{XtNbackground,		(XtArgVal) NULL},
	};

	/* and the button box in the viewport */
	bboxlist[0].value = (XtArgVal) dirbfgr;
	bboxlist[1].value = (XtArgVal) dirbbgr;
	treew = XtCreateManagedWidget("bbox", treeWidgetClass,
		vieww, bboxlist, XtNumber(bboxlist));
	add_help("TreeView", &helphead, treew);
	i = 0;
	lp = &dirhead;
	cmdlist[0].value = (XtArgVal) dirtrn;
	/* Alloc DirList element, as required */
	lp->l_next = (DirList *)XtMalloc(sizeof(DirList));
	lp = lp->l_next;
	lp->l_childir = NULL;
	lp->l_next = NULL;
	/* Now set name and label */
	lp->l_level = 0;
	lp->l_pardir = &dirhead;
	/* Fill in the top dir name */
	p = dirpos-2;
	while (p > abdir && *p != '/')
		p--;
	/* Iff root dir */
	if (p < abdir) {
		p = abdir;
		len = 1;
	} else {
		p++;
		len = dirpos-p-1;
	}
	bcopy(p, lp->l_name, len);
	lp->l_name[len] = '\0';
	lp->l_len = len;
	if (len > MAXLABEL) {
		bcopy(p, lp->l_label, MAXLABEL-2);
		lp->l_label[MAXLABEL-2] = lp->l_label[MAXLABEL-1] = '.';
		lp->l_label[MAXLABEL] = '\0';
	} else {
		bcopy(p, lp->l_label, len);
		bcopy(blkstr, lp->l_label+len, MAXLABEL-len);
		lp->l_label[MAXLABEL] = '\0';
	}
	/* And create the command button */
	cmdlist[1].value = (XtArgVal) lp->l_label;
#ifdef notdef
	cmdlist[2].value = (XtArgVal) NULL;
#endif
	cmdcall[0].closure = (caddr_t) lp;
	lp->l_widg = XtCreateManagedWidget("cmd",
		commandWidgetClass, treew, cmdlist,
		XtNumber(cmdlist));
	curdirlp = lp;
	getdirnames(lp, 1, &lp, ".", &i);
	enddirlp = lp;
	reset_dir();
}

/*
 * Do the selected operation after name args selected
 */
do_op()
{
	register NameList *lp;

	lp = namesel.l_selnext;
	while (lp != NULL) {
		switch(cur_op) {
		case MKDIR:
			if (mkdir(lp->l_name, 0777) < 0)
				err("Can't create dir:%s",lp->l_name);
			else
				rebuild_tree(MKDIR, lp->l_name);
			break;
		case SELECT:
				err("Can't Send selection");
			break;
		case RM:
			if (unlink(lp->l_name) < 0)
				err("Can't Remove %s",lp->l_name);
			break;
		case RMDIR:
			if (rmdir(lp->l_name) < 0)
				err("Dir %s Non Empty", lp->l_name);
			else
				rebuild_tree(RMDIR, lp->l_name);
			break;
		case RMSUBT:
			err("Not yet supported");
			break;
		};
		lp = lp->l_selnext;
	}
	reset_dir();
}

/*
 * Catchall callback for help
 */
void help_call(w, p1, p2)
	Widget w;
	caddr_t p1, p2;
{

	if (p2 != NULL) {
		if (*p2 == 'H') {
			popup_help(&(helphead), &(popuphead), w);
		}
		return;
	}
}

/*
 * Rebuild the tree after an operation that has added/deleted dir(s)
 * Basically add/delete the leaf node
 */
static void rebuild_tree(op, name)
	int op;
	char *name;
{
	register DirList *lp, *olp;
	register int len;
	static XtCallbackRec cmdcall[] = {
		{getto_dir,	NULL},
		{NULL,		NULL},
	};
	static Arg cmdlist[] = {
		{XtNtranslations,	(XtArgVal) NULL},
		{XtNlabel,		(XtArgVal) NULL},
		{XtNcallback,		(XtArgVal) cmdcall},
	};
	static Arg setparent[] = {
		{XtNwidget,		(XtArgVal) NULL},
	};

	switch(op) {
	case MKDIR:
		lp = enddirlp;
		cmdlist[0].value = (XtArgVal) dirtrn;
		/* Alloc DirList element */
		lp->l_next = (DirList *)XtMalloc(sizeof(DirList));
		lp = lp->l_next;
		lp->l_childir = NULL;
		lp->l_next = NULL;
		/* Now set name and label */
		lp->l_level = curdirlp->l_level+1;
		lp->l_pardir = curdirlp;
		len = strlen(name);
		bcopy(name, lp->l_name, len+1);
		lp->l_len = len;
		if (len > MAXLABEL) {
			bcopy(name, lp->l_label, MAXLABEL-2);
			lp->l_label[MAXLABEL-2] = lp->l_label[MAXLABEL-1] = '.';
			lp->l_label[MAXLABEL] = '\0';
		} else {
			bcopy(name, lp->l_label, len);
			bcopy(blkstr, lp->l_label+len, MAXLABEL-len);
			lp->l_label[MAXLABEL] = '\0';
		}
		/* And create the command button */
		cmdlist[1].value = (XtArgVal) lp->l_label;
		setparent[0].value = (XtArgVal) curdirlp->l_widg;
		XtSetValues(treew, setparent, 1);
		cmdcall[0].closure = (caddr_t) lp;
		lp->l_widg = XtCreateManagedWidget("cmd",
			commandWidgetClass, treew, cmdlist,
			XtNumber(cmdlist));
		enddirlp = lp;
		break;
	case RMDIR:
		olp = curdirlp;
		lp = olp->l_next;
		/* Run down list to find it */
		while (lp != NULL) {
			if (lp->l_pardir == curdirlp && strcmp(lp->l_name,
				name) == 0) {
				olp->l_next = lp->l_next;
				if (lp == enddirlp)
					enddirlp = olp;
				XtDestroyWidget(lp->l_widg);
				XtFree((caddr_t) lp);
				break;
			}
			olp = lp;
			lp = lp->l_next;
		}
		break;
	};
}

/*
 * This function deals with X errors
 */
static int xerr(disp, errv)
	Display *disp;
	XErrorEvent *errv;
{
	char buf[256];

	switch (errv->error_code) {
	case BadAlloc:
		if (errv->request_code == X_ChangeProperty &&
			errv->resourceid == dirbchdirwin) {
			return;
		}
	default:
		XGetErrorText(disp, errv->error_code, buf, 256);
		serr("xerr err=%s\n", buf);
		break;
	};
}

