/*

Copyright 1988 by the University of Guelph

Permission to use, copy and modify this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation.
University of Guelph makes no representations about the suitability of
this software for any purpose.  It is provided "as is"
without express or implied warranty.

*/

/*
 * This function gets the appropriate vifconf.o config. loaded.
 * the "name" argument is the file name expected to be in dir.
 * CONFLIB.
 * NOT PORTABLE To Non 4bsd systems
 */

#include <X11/Xos.h>
#include <stdio.h>
#include <sys/dir.h>
#include <sys/param.h>
#include <X11/Xlib.h>
#include <sys/exec.h>
#include <nlist.h>
#include "../include/gshdirs.h"

/* Error messages */
#define FER_BADCONFIG	"Bad Config file format"
#define	FER_NOCONFIG	"Can't Find Config file"
#define	FER_NOMEMORY	"Can't Get Enough Memory"

/*
 * this is just copied out of <a.out.h>. Unfortunately the def'n of
 * struct nlist is different in a.out.h than nlist.h and as such
 * a.out.h cannot be included.
 */
struct relocation_info {
	int	r_address;	/* address which is relocated */
unsigned int	r_symbolnum:24,	/* local symbol ordinal */
		r_pcrel:1, 	/* was relocated pc relative already */
		r_length:2,	/* 0=byte, 1=word, 2=long */
		r_extern:1,	/* does not include value of sym referenced */
		:4;		/* nothing, yet */
};

/*
 * Global vars.
 */
static char conf_name[MAXPATHLEN+1] = { CONFLIB };

/*
 * Read in the .o file full of static data and relocate it to the
 * XtMalloc'd block
 */
char *get_conf(name, list_nl)
	char *name;
	struct nlist list_nl[];
{
	register int i;
	register char *ptr;
	register struct relocation_info *p2;
	u_long *p3;
	struct relocation_info *reloc;
	int fid;
	struct exec c_hd;

	strncat(conf_name, name, MAXPATHLEN-strlen(conf_name));
	conf_name[MAXPATHLEN] = '\0';
	if ((fid = open(conf_name, O_RDONLY, 0444)) < 0)
		serr(FER_NOCONFIG);
	if (read(fid, &c_hd, sizeof(c_hd)) != sizeof(c_hd))
		serr(FER_BADCONFIG);
	if (c_hd.a_magic != 0407 || c_hd.a_text != 0 || c_hd.a_bss != 0 ||
		c_hd.a_trsize != 0 ||
		c_hd.a_drsize == 0)
		serr(FER_BADCONFIG);
	if ((ptr = (caddr_t) malloc(c_hd.a_data)) == NULL)
		serr(FER_NOMEMORY);
	if (read(fid, ptr, c_hd.a_data) != c_hd.a_data)
		serr(FER_BADCONFIG);
	if((reloc=p2=(struct relocation_info*)malloc(c_hd.a_drsize))==NULL)
		serr(FER_NOMEMORY);
	if (read(fid, p2, c_hd.a_drsize) != c_hd.a_drsize)
		serr(FER_BADCONFIG);
	/* Call nlist to get the symbol table values */
	if (nlist(conf_name, list_nl) < 0)
		serr(FER_BADCONFIG);
	if ((list_nl[0].n_type & N_TYPE) != N_DATA)
		serr(FER_BADCONFIG);
	/* Loop through relocation info and do it */
	for (i = 0; i < c_hd.a_drsize; i += sizeof(struct relocation_info)) {
		if (p2->r_pcrel == 0) {
			if (p2->r_length != 2 || p2->r_symbolnum != N_DATA)
				serr(FER_BADCONFIG);
			p3 = (u_long *)(ptr+p2->r_address);
			*p3 += (u_long)ptr;
		}
		p2++;
	}
	free((caddr_t) reloc);
	return(ptr);
}

