/*

Copyright 1988 by the University of Guelph

Permission to use, copy and modify this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation.
University of Guelph makes no representations about the suitability of
this software for any purpose.  It is provided "as is"
without express or implied warranty.

*/

/*
 * Vif routines that are hooked into xterm
 */
#include <X11/Xos.h>
#include <stdio.h>
#include <setjmp.h>
#include <sys/dir.h>
#include <sys/ioctl.h>
#include <signal.h>
#include <sys/exec.h>
#include <sys/param.h>
#include <nlist.h>
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/IntrinsicP.h>
#include <X11/Atoms.h>
#include <X11/Cardinals.h>
#include <X11/Command.h>
#include <X11/ICommand.h>
#include <X11/Icon.h>
#include <X11/Box.h>
#include <X11/Scroll.h>
#include <X11/Shell.h>
#include <X11/Dialog.h>
#include <X11/DialogP.h>
#include <X11/LabelP.h>
#include "main.h"
#include "ptyx.h"
#include "data.h"
#include "vifconf.h"
#include "vif.h"
#include "defunct.h"
#include "yylook.h"
#include "tar.h"
#include "help.h"
#include "gshdirs.h"

extern WidgetClass xtermWidgetClass;
extern Widget toplevel;
extern Pixel init_colour();
extern void warp_pointer();
extern Boolean vif_defunct;

#define	dinput()		(bcnt-- > 0 ? *bptr++ : in_put())

#define XtNinternalBorder	"internalBorder"
/* Callback routines for various widgets */
void	vif_action();
void	vif_scroller();
void	vif_scrollpos();
void	vif_accept();
void	vif_help();
void	vif_cancel();
void	vif_yesno();
/* assorted other data items */
char *index();
struct vif_config	*vif_conf;
struct vif_act vif_actions[MAXACTIONS];
static HelpList vif_helphead, vif_popuphead;
static Widget vif_pagescrw;
struct vif_act *vif_initactp;
static float scr_oldpos = 0.5;
static struct yylookvars kbdyylook;
static int vif_xpos, vif_ypos;
static struct yylookvars *kbdlookvptr;
static struct yylookdfa *kbdyylookdfaptr;
static struct yylookvars ptyylook;
static struct yylookdfa *ptyylookdfaptr;
static char kbdcval = 0;
static Widget titlew;
static Widget vif_dialogw, vif_yesnow, vif_dialboxw, vif_yesnoboxw;
static Widget vif_yesbuttonw, vif_scrollw;
static struct vif_act *vif_curactp;
static char vif_dialogresp[MAXDIALOGRESP+1];
static Boolean vif_scrmousesens[5];
static Boolean vif_ttysens;
static void pointtocharpos();
XColor vif_cursfgr, vif_cursbgr;
static Pixel vif_fgrcolr, vif_bgrcolr;
int kbdgetc(), kbdputc();
char vif_outbuf[BUF_SIZE*2], *vif_outptr, vif_ptgetc;
int vif_outcnt;
static struct yylookvars *ptlookvptr;
static char *fnt;
static int border;
static int defborder = DEFBORDER;
static XtResource resources[] = {
{XtNfont, XtCFont, XtRString, sizeof(char *),
	(Cardinal)&fnt, XtRString,
	DEFFONT},
{XtNinternalBorder,XtCBorderWidth,XtRInt, sizeof(int),
	(Cardinal) &border,
	XtRInt, (caddr_t) &defborder},
};
static int height, fullwidth, num_buttons;
static Widget vif_buts[MAXBUTTONS];
static struct popupstuff {
	XtIntervalId timerid;
	Widget popupw;
	Widget popupsubw;
} popuptextdat, popupicondat;
static XtIntervalId vif_mousetimerid;
static void popup_timer();
static void mouse_timer();

/*
 * Call Exit to clean up
 */
int vif_exit()
{
	Exit(0);
}

/*
 * doinput() for filtering output to screen...
 */
char doinput()
{
	register struct vif_act *actp;
	int actv;
	Widget www;

	www = NULL;
	/* Iff no filter, just return dinput() */
	if ((vif_conf->vc_flags & VC_PTYFILTER) == 0)
		return(dinput());
	/* Iff buffered output, just return a char of it */
	if (vif_outcnt-- > 0)
		return(*vif_outptr++);
	vif_outcnt = 0;
	vif_outptr = vif_outbuf;
	/* loop on yylook() until output is available */
	while (vif_outcnt == 0) {
		ptlookvptr->no_next_char = 0;
		vif_ptgetc = dinput();
		/* look for all action regex matches */
		while ((actv = yylook(ptlookvptr)) > 0) {
			actv = *((ptyylookdfaptr->regextoaction)+actv);
			actp = &vif_actions[actv];
			actp->vac_matchstring = ptlookvptr->text;
			actp->vac_matchlen = ptlookvptr->leng;
			vif_action(www,(caddr_t)actp,(caddr_t)NULL);
		}
	}
	vif_outcnt--;
	return(*vif_outptr++);
}

/*
 * getc function for ptyylook()
 */
ptgetc()
{
	char cc;

	if (vif_ptgetc != 0)
		ptlookvptr->no_next_char = 1;
	cc = vif_ptgetc;
	vif_ptgetc = 0;
	return(cc & 0xff);
}

/*
 * putc function for ptyylook()
 */
ptputc(c)
	char c;
{
	if (vif_outcnt < (BUF_SIZE*2))
		vif_outbuf[vif_outcnt++] = c;
}
/*
 * Called from unparseputc() and does the same work, but through
 * the filter
 */
vif_unparseputc(c, fd)
	char c;
	int fd;
{
	register struct vif_act *actp;
	int retv;
	Widget www;

	if (!vif_ttysens)
		return;
	www = NULL;
	if (vif_conf->vc_flags & VC_KBFILTER) {
		kbdcval = c;
		kbdlookvptr->no_next_char = 0;
		/* Loop through the actions matched by yylook() */
		while ((retv = yylook(kbdlookvptr)) > 0) {
			retv = *((kbdyylookdfaptr->regextoaction)+retv);
			actp = &vif_actions[retv];
			actp->vac_matchstring = kbdlookvptr->text;
			actp->vac_matchlen = kbdlookvptr->leng;
			vif_action(www,(caddr_t)actp,(caddr_t)NULL);
		}
	} else {
		kbdputc(c);
	}
}

/* Input routine for keyboard filter */
kbdgetc()
{
	char cc;

	if (kbdcval != 0)
		kbdlookvptr->no_next_char++;
	cc = kbdcval;
	kbdcval = 0;
	return(cc & 0xff);
}

/* Keyboard send char to terminal emulation window routine */
kbdputc(c)
	char c;
{
	char	buf[2];
	register i = 1;
	register TScreen *screen = &term->screen;

	if((buf[0] = c) == '\r' && (term->flags & LINEFEED)) {
		buf[1] = '\n';
		i++;
	}
	if (write(screen->respond, buf, i) != i)
		Panic("unparseputc: error writing character\n", 0);
}

/*
 * Initialize the config and set up the widgets
 */
Widget vif_init(confilname, name, geom)
	char *confilname;
	char *name;
	char *geom;
{
	register struct vif_config *vc;
	register struct vif_sel *vsl;
	TScreen *screen;
	int			k;
	int width;
	int fwidth, fheight;
	XFontStruct *fnt_norm;
	XtTranslations ctrans;
	Widget cw;
	static Pixel fgr, bgr;
	/* lots of static structures for creating widgets */
	static char helpname[MAXPATHLEN+1];
	static char scrtrans[] =
	"<Btn1Down>:   StartScroll(Continuous) MoveThumb() \n\
	<Btn1Motion>: MoveThumb() \n\
	<Btn2Down>:   enablenotify() \n\
	<Btn2Up>:     notify(Help) disablenotify() \n\
	<LeaveWindow>: disablenotify() \n\
	<Btn1Up>:      NotifyThumb() EndScroll()";
	static XtCallbackRec	cmdcall[] = {
		{ vif_action,	NULL },
		{ NULL,		NULL },
	};
	static XtCallbackRec	textcall[] = {
		{ vif_accept,	NULL },
		{ NULL,		NULL },
	};
	static XtCallbackRec	labelcall[] = {
		{ vif_help,	NULL },
		{ NULL,		NULL },
	};
	static XtCallbackRec	scrcall[] = {
		{ vif_scroller,	NULL },
		{ NULL,		NULL },
	};
	static XtCallbackRec	scrnotifycall[] = {
		{ vif_help,	NULL },
		{ NULL,		NULL },
	};
	static XtCallbackRec	acceptcall[] = {
		{ vif_accept,	NULL },
		{ NULL,		NULL },
	};
	static XtCallbackRec	cancelcall[] = {
		{ vif_cancel,	NULL },
		{ NULL,		NULL },
	};
	static XtCallbackRec	yesnocall[] = {
		{ vif_yesno,	NULL },
		{ NULL,		NULL },
	};
	static Arg		acceptlist[] = {
		{XtNlabel,	(XtArgVal) "Accept"},
		{XtNcallback,	(XtArgVal) acceptcall},
		{XtNforeground,	(XtArgVal) NULL},
		{XtNbackground,	(XtArgVal) NULL},
	};
	static Arg		pagescrlist[] = {
		{XtNforeground,	(XtArgVal) NULL},
		{XtNbackground,	(XtArgVal) NULL},
		{XtNlabel,	(XtArgVal) PAGESCRMSG},
	};
	static Arg		cancellist[] = {
		{XtNlabel,	(XtArgVal) "Cancel"},
		{XtNcallback,	(XtArgVal) cancelcall},
		{XtNforeground,	(XtArgVal) NULL},
		{XtNbackground,	(XtArgVal) NULL},
	};
	static Arg		yeslist[] = {
		{XtNlabel,	(XtArgVal) "Yes"},
		{XtNcallback,	(XtArgVal) yesnocall},
		{XtNforeground,	(XtArgVal) NULL},
		{XtNbackground,	(XtArgVal) NULL},
	};
	static Arg		nolist[] = {
		{XtNlabel,	(XtArgVal) "No"},
		{XtNcallback,	(XtArgVal) yesnocall},
		{XtNforeground,	(XtArgVal) NULL},
		{XtNbackground,	(XtArgVal) NULL},
	};
	static Arg		cmdarglist[] = {
		{XtNlabel,	(XtArgVal) NULL},
		{XtNcallback,	(XtArgVal) cmdcall},
		{XtNforeground,	(XtArgVal) NULL},
		{XtNbackground,	(XtArgVal) NULL},
	};
	static Arg		cmdiconlist[] = {
		{XtNlabel,	(XtArgVal) NULL},
		{XtNcallback,	(XtArgVal) cmdcall},
		{XtNbitmapData, (XtArgVal) NULL},
		{XtNiconWidth, (XtArgVal) NULL},
		{XtNiconHeight, (XtArgVal) NULL},
		{XtNforeground,	(XtArgVal) NULL},
		{XtNbackground,	(XtArgVal) NULL},
	};
	static Arg		bbarglist[] = {
		{XtNx,			(XtArgVal)NULL},
		{XtNy,			(XtArgVal)NULL},
		{XtNwidth,		(XtArgVal)NULL},
		{XtNheight,		(XtArgVal)NULL},
		{XtNborderWidth,	(XtArgVal)NULL},
		{XtNbackground,		(XtArgVal)NULL},
		{XtNcallback,		(XtArgVal)labelcall},
	};
	static Arg		titlelist[] = {
		{XtNwidth,	(XtArgVal) NULL},
		{XtNheight,	(XtArgVal) VIF_TITLEH},
		{XtNlabel,	(XtArgVal) NULL},
		{XtNjustify,	(XtArgVal) XtJustifyLeft},
		{XtNforeground,	(XtArgVal) NULL},
		{XtNbackground,	(XtArgVal) NULL},
	};
	static Arg		scrarglist[] = {
		{XtNwidth,		(XtArgVal) VIF_SCROLLWIDTH},
		{XtNheight,		(XtArgVal)100},
		{XtNthumbProc,		(XtArgVal)scrcall},
		{XtNtop,		 (XtArgVal)NULL},
		{XtNshown,		(XtArgVal)NULL},
		{XtNorientation,	(XtArgVal)XtorientVertical},
		{XtNcallback,		(XtArgVal)scrnotifycall},
		{XtNtranslations,	(XtArgVal)NULL},
		{XtNforeground,		(XtArgVal) NULL},
		{XtNbackground,		(XtArgVal) NULL},
	};
	static Arg		termlist[] = {
		{XtNwidth,	(XtArgVal) NULL},
		{XtNheight,	(XtArgVal) NULL},
	};
	static Arg		dialoglist[] = {
		{XtNlabel,	(XtArgVal) "Dialog"},
		{XtNvalue,	(XtArgVal) vif_dialogresp},
		{XtNmaximumLength, (XtArgVal) MAXDIALOGRESP},
		{XtNcallback,	(XtArgVal) labelcall},
		{XtNforeground,	(XtArgVal) NULL},
		{XtNbackground,	(XtArgVal) NULL},
	};
	static Arg		yesnolist[] = {
		{XtNlabel,	(XtArgVal) NULL},
		{XtNcallback,	(XtArgVal) labelcall},
		{XtNforeground,	(XtArgVal) NULL},
		{XtNbackground,	(XtArgVal) NULL},
	};
	static Arg popup_args[] = {
		{XtNx, NULL},
		{XtNy, NULL},
		{XtNgeometry, NULL},
		{XtNallowShellResize, True},
		{XtNsaveUnder, True},
	};
	static Arg	textlist[] = {
		{XtNwidth,	(XtArgVal) NULL},
	};
	static Arg	labellist[] = {
		{XtNwidth,	(XtArgVal) NULL},
	};
	static Widget		bbw, bbw1, ww, termw, dw;
	static char str[1024];

	/* Set SIGUSR1 to exit */
	signal(SIGUSR1, vif_exit);
	kbdlookvptr = &kbdyylook;
	ptlookvptr = &ptyylook;
	/* call vif_getconf to read in the initialized structures */
	vif_getconf(confilname);
	vc = vif_conf;
	/* Get the help library */
	strcpy(helpname, HELPDIR);
	strcat(helpname, vc->vc_helplib);
	init_help(helpname, &vif_helphead, &vif_popuphead,
		vc->vc_helpfgr, vc->vc_helpbgr);
	/* mimic VTRealize to calculate xterm's size */
	XtGetApplicationResources(toplevel, 0, resources, XtNumber(resources),
		NULL, 0);
	/* do the XFont calls */
	if ((fnt_norm = XLoadQueryFont(XtDisplay(toplevel), fnt)) == NULL) {
		fwidth = 9;
		fheight = 14;
	} else {
		fwidth = fnt_norm->max_bounds.width;
		fheight = fnt_norm->max_bounds.ascent +
			    fnt_norm->max_bounds.descent;
	}
	XFreeFont(XtDisplay(toplevel), fnt_norm);
	/* set defaults */
	vif_xpos = 1; vif_ypos = 1; width = 80; height = 24;
	/* should have gotten "geom" from resource manager, but... */
	XParseGeometry(geom, &vif_xpos, &vif_ypos, &width, &height);
	width = width*fwidth+2*border;
	height = height*fheight+2*border;
	fullwidth = width+VIF_MARG;
	if (vc->vc_flags & VC_SCROLLBAR)
		fullwidth += VIF_SCROLLWIDTH;
	/* Create 2 boxes for doing layout, should be a constraint widget,
	   but i'm lazy and this works.. */
	bbarglist[2].value = (XtArgVal) fullwidth;
	bbarglist[3].value = (XtArgVal) 0;
	bbarglist[5].value = (XtArgVal) vif_bgrcolr;
	bbw1 = XtCreateManagedWidget("box", boxWidgetClass, toplevel,
		bbarglist, XtNumber(bbarglist));
	bbw = XtCreateManagedWidget("bbox", boxWidgetClass, bbw1,
		bbarglist, XtNumber(bbarglist));
	add_help("Top", &vif_helphead, bbw);
	/* create title widget, also used as popup area */
	titlelist[2].value = (XtArgVal) name;
	titlelist[0].value = (XtArgVal) fullwidth;
	titlelist[4].value = (XtArgVal) vif_fgrcolr;
	titlelist[5].value = (XtArgVal) vif_bgrcolr;
	titlew = XtCreateManagedWidget("title",labelWidgetClass,bbw,
		titlelist, XtNumber(titlelist));
	if (vc->vc_flags & VC_BUTTONS) {
		k = 0;
		vsl = &(vc->vc_selitem[0]);
		/* loop arround creating the button widgets */
		while (k < MAXBUTTONS && vsl->vsl_flags & VSL_VALID){
			cmdcall[0].closure = (caddr_t) &(vif_actions[
				vsl->vsl_action]);
			fgr = init_colour(vsl->vsl_fgr);
			bgr = init_colour(vsl->vsl_bgr);
			if (vsl->vsl_flags & VSL_ICON) {
				cmdiconlist[0].value = (XtArgVal)vsl->vsl_label;
				cmdiconlist[2].value = (XtArgVal)vsl->vsl_iconbits;
				cmdiconlist[3].value = (XtArgVal)vsl->vsl_iconwidth;
				cmdiconlist[4].value = (XtArgVal)vsl->vsl_iconheight;
				cmdiconlist[5].value = (XtArgVal) fgr;
				cmdiconlist[6].value = (XtArgVal) bgr;
				vif_buts[k] = XtCreateManagedWidget("icon",
					icommandWidgetClass,
					bbw,cmdiconlist,XtNumber(cmdiconlist));
			} else {
				cmdarglist[0].value = (XtArgVal)vsl->vsl_label;
				cmdarglist[2].value = (XtArgVal) fgr;
				cmdarglist[3].value = (XtArgVal) bgr;
				vif_buts[k] = XtCreateManagedWidget("cmd",
					commandWidgetClass,
					bbw, cmdarglist, XtNumber(cmdarglist));
			}
			strcpy(str, "But.");
			strcat(str, vsl->vsl_label);
			add_help(str, &vif_helphead, vif_buts[k]);
			if (vsl->vsl_flags & VSL_BOOLEAN) {
				XtOverrideTranslations(vif_buts[k],
				   XtParseTranslationTable(
				   "<Btn1Down>: enablenotify() \n\
				    <Leave>: unhighlight() disablenotify() \n\
				    <Btn2Down>: enablenotify() \n\
				    <Btn2Up>: notify(Help) disablenotify() \n\
				    <Btn1Up>:   toggle() notify() disablenotify()"));
				vif_actions[vsl->vsl_action].vac_flags |= VAC_BOOLEAN;
			} else {
				XtOverrideTranslations(vif_buts[k],
					XtParseTranslationTable(
					"<Btn2Down>: enablenotify() \n\
					 <Btn2Up>: notify(Help) disablenotify()"));
			}
			k++;
			vsl++;
		}
		num_buttons = k;
	}
	/* Iff config'd, create the scrollbar widget */
	if (vc->vc_flags & VC_SCROLLBAR) {
		fgr = init_colour(vc->vc_scrollfgr);
		bgr = init_colour(vc->vc_scrollbgr);
		scrarglist[1].value = (XtArgVal) height;
		scrarglist[3].value = 0.475;
		scrarglist[4].value = 0.5;
		scrarglist[7].value = (XtArgVal)
			XtParseTranslationTable(scrtrans);
		scrarglist[8].value = (XtArgVal) fgr;
		scrarglist[9].value = (XtArgVal) bgr;
		vif_scrollw = XtCreateManagedWidget("scrollbar", scrollbarWidgetClass,
			bbw1, scrarglist,
			XtNumber(scrarglist));
		add_help("Scroll", &vif_helphead, vif_scrollw);
		XtScrollBarSetThumb(vif_scrollw, 0.475, 0.0);
	} else
		vif_scrollw = (Widget) NULL;
	/* Create dialog and yes/no popup widgets */
	vif_dialogw = XtCreatePopupShell("dialog", transientShellWidgetClass,
		toplevel, popup_args, XtNumber(popup_args));
	fgr = init_colour(vc->vc_dialogfgr);
	bgr = init_colour(vc->vc_dialogbgr);
	dialoglist[4].value = (XtArgVal) fgr;
	dialoglist[5].value = (XtArgVal) bgr;
	vif_dialboxw = XtCreateManagedWidget("dbox", dialogWidgetClass, vif_dialogw,
		dialoglist, XtNumber(dialoglist));
	add_help("Dialog", &vif_helphead, vif_dialboxw);
	textlist[0].value = (XtArgVal) (fwidth*MAXDIALOGRESP+30);
	labellist[0].value = (XtArgVal) (fwidth*MAXDIALOGRESP+30);
	XtSetValues(((DialogWidget)vif_dialboxw)->dialog.valueW, textlist,
		XtNumber(textlist));
	XtAddCallbacks(((DialogWidget)vif_dialboxw)->dialog.valueW,
		XtNcallback, textcall);
	XtSetValues(((DialogWidget)vif_dialboxw)->dialog.labelW, labellist,
		XtNumber(labellist));
	fgr = init_colour(vc->vc_acceptfgr);
	bgr = init_colour(vc->vc_acceptbgr);
	acceptlist[2].value = (XtArgVal) fgr;
	acceptlist[3].value = (XtArgVal) bgr;
	cw = XtCreateManagedWidget("accept", commandWidgetClass, vif_dialboxw, acceptlist,
		XtNumber(acceptlist));
	add_help("Dialog.accept", &vif_helphead, cw);
	ctrans = XtParseTranslationTable(
		"<Btn2Down>: enablenotify() \n\
		<Btn2Up>: notify(Help) disablenotify()");
	XtOverrideTranslations(cw, XtParseTranslationTable(
		"<Btn1Up>: unset() notify() disablenotify() \n\
		<Btn2Down>: enablenotify() \n\
		<Btn2Up>: notify(Help) disablenotify()"));
	fgr = init_colour(vc->vc_cancelfgr);
	bgr = init_colour(vc->vc_cancelbgr);
	cancellist[2].value = (XtArgVal) fgr;
	cancellist[3].value = (XtArgVal) bgr;
	cw = XtCreateManagedWidget("cancel", commandWidgetClass, vif_dialboxw, cancellist,
		XtNumber(cancellist));
	add_help("Dialog.cancel", &vif_helphead, cw);
	XtOverrideTranslations(cw, ctrans);
	vif_yesnow = XtCreatePopupShell("yesno", transientShellWidgetClass,
		toplevel, popup_args, XtNumber(popup_args));
	fgr = init_colour(vc->vc_yesnofgr);
	bgr = init_colour(vc->vc_yesnobgr);
	yesnolist[2].value = (XtArgVal) fgr;
	yesnolist[3].value = (XtArgVal) bgr;
	vif_yesnoboxw = XtCreateManagedWidget("yesnobox", dialogWidgetClass, vif_yesnow,
		yesnolist, XtNumber(yesnolist));
	add_help("Yesno", &vif_helphead, vif_yesnoboxw);
	XtSetValues(((DialogWidget)vif_yesnoboxw)->dialog.labelW, labellist,
		XtNumber(labellist));
	yesnocall[0].closure = (caddr_t) 1;
	fgr = init_colour(vc->vc_yesfgr);
	bgr = init_colour(vc->vc_yesbgr);
	yeslist[2].value = (XtArgVal) fgr;
	yeslist[3].value = (XtArgVal) bgr;
	vif_yesbuttonw = XtCreateManagedWidget("yes", commandWidgetClass, vif_yesnoboxw, yeslist,
		XtNumber(yeslist));
	add_help("Yesno.yes", &vif_helphead, vif_yesbuttonw);
	yesnocall[0].closure = (caddr_t) NULL;
	XtOverrideTranslations(vif_yesbuttonw, ctrans);
	fgr = init_colour(vc->vc_nofgr);
	bgr = init_colour(vc->vc_nobgr);
	nolist[2].value = (XtArgVal) fgr;
	nolist[3].value = (XtArgVal) bgr;
	cw = XtCreateManagedWidget("no", commandWidgetClass, vif_yesnoboxw, nolist,
		XtNumber(nolist));
	add_help("Yesno.no", &vif_helphead, cw);
	XtOverrideTranslations(cw, ctrans);
	XtRealizeWidget(vif_dialogw);
	XtRealizeWidget(vif_yesnow);
	/* Create the text and icon popup shells */
	popuptextdat.popupw = XtCreatePopupShell("popupt", transientShellWidgetClass,
		toplevel, popup_args, XtNumber(popup_args));
	popuptextdat.popupsubw = XtCreateManagedWidget("popupsubw", labelWidgetClass,
		popuptextdat.popupw, NULL, 0);
	popupicondat.popupw = XtCreatePopupShell("popupi", transientShellWidgetClass,
		toplevel, popup_args, XtNumber(popup_args));
	popupicondat.popupsubw = (Widget) NULL;
	/* and finally the term emulation widget */
        termw = XtCreateManagedWidget(
	    "vt100", xtermWidgetClass, bbw1, NULL, 0);
	/* Now you can initialize the warp widget action values */
	init_warp(vc, termw);
	/* And Sensitize the mouse buttons on the tty screen */
	for (k = 0; k < 5; k++)
		vif_scrmousesens[k] = True;
	/* Sensitize tty */
	vif_ttysens = True;
	/* Set pagescroll as required */
	if (vc->vc_flags & VC_PAGESCROLL) {
		screen = &(((XtermWidget)termw)->screen);
		screen->pagecnt = 0;
		screen->pagemode = True;
		/* Create the popup text for scrolling */
		vif_pagescrw = XtCreatePopupShell("popscrt", transientShellWidgetClass,
			toplevel, popup_args, XtNumber(popup_args));
		pagescrlist[0].value = (XtArgVal) vif_bgrcolr;
		pagescrlist[1].value = (XtArgVal) vif_fgrcolr;
		cw = XtCreateManagedWidget("popscrsubw", labelWidgetClass,
			vif_pagescrw, pagescrlist, XtNumber(pagescrlist));
	}
	/* Initialize the Keyboard filter iff any */
	if (vc->vc_flags & VC_KBFILTER)
		yylookinit(kbdlookvptr,kbdyylookdfaptr,kbdgetc,kbdputc);
	/* Initialize the pseudo terminal stream filter, iff any */
	if (vc->vc_flags & VC_PTYFILTER)
		yylookinit(ptlookvptr,ptyylookdfaptr,ptgetc,ptputc);
	/* Finally, set any initial action and return termw */
	if (vc->vc_flags & VC_INITIALACT)
		vif_initactp = &vif_actions[vc->vc_initaction];
	else
		vif_initactp = (struct vif_act *) NULL;
	return(termw);
}

/*
 * Action routine called through the callback routines and filters
 * for configured actions
 */
void vif_action(w, app, calldat)
	Widget w;
	caddr_t app;
	caddr_t calldat;
{
	register struct vif_act *ap;
	register TScreen *screen = &term->screen;
	register int i;
	int mask;
	char *st;
	Window ww;
	static char ptext[1024];
	static int xpos, ypos, wid;
	static Pixel fgr, bgr;
	static Arg	setargl[] = {
		{XtNlabel,	(XtArgVal) NULL},
		{XtNforeground, (XtArgVal) NULL},
		{XtNbackground, (XtArgVal) NULL},
	};
	static Arg	seticonl[] = {
		{XtNbitmapData,	(XtArgVal) NULL},
		{XtNiconWidth,	(XtArgVal) NULL},
		{XtNiconHeight, (XtArgVal) NULL},
		{XtNforeground, (XtArgVal) NULL},
		{XtNbackground, (XtArgVal) NULL},
	};
	static Arg	getpos[] = {
		{XtNwidth,	(XtArgVal) &wid},
		{XtNforeground, (XtArgVal) &fgr},
		{XtNbackground, (XtArgVal) &bgr},
	};
	static Arg	setpos[] = {
		{XtNx,		(XtArgVal) NULL},
		{XtNy,		(XtArgVal) NULL},
	};
	unsigned long tim;

	/* Deal with other input that isn't activate action */
	if (calldat != NULL) {
		if (*calldat == 'H') {
			popup_help(&vif_helphead, &vif_popuphead, w);
		}
		return;
	}
	/* Deal with action activations */
	ap = (struct vif_act *) app;
	/* Change button and scrollbar sensitivity (must be first) */
	if (ap->vac_flags & VAC_SETSENSTV) {
		int sens;

		if (vif_scrollw != NULL) {
			sens = ap->vac_setsensitive[0];
			/* Iff BOOLEAN on do state inverse */
			if ((ap->vac_flags & VAC_BOOLEAN) && ap->vac_boolstate) {
				switch (sens) {
				case SEN_ON:
					sens = SEN_OFF;
					break;
				case SEN_OFF:
					sens = SEN_ON;
					break;
				};
			}
			if (sens == SEN_ON &&
				!XtIsSensitive(vif_scrollw))
				XtSetSensitive(vif_scrollw, True);
			if (sens == SEN_OFF &&
				XtIsSensitive(vif_scrollw))
				XtSetSensitive(vif_scrollw, False);
		}
		sens = ap->vac_setsensitive[1];
		/* Iff BOOLEAN on do state inverse */
		if ((ap->vac_flags & VAC_BOOLEAN) && ap->vac_boolstate) {
			switch (sens) {
			case SEN_ON:
				sens = SEN_OFF;
				break;
			case SEN_OFF:
				sens = SEN_ON;
				break;
			};
		}
		if (sens == SEN_ON)
			vif_ttysens = True;
		if (sens == SEN_OFF)
			vif_ttysens = False;
		for (i = 2; i <= 6; i++) {
			sens = ap->vac_setsensitive[i];
			/* Iff BOOLEAN on do state inverse */
			if ((ap->vac_flags & VAC_BOOLEAN) && ap->vac_boolstate) {
				switch (sens) {
				case SEN_ON:
					sens = SEN_OFF;
					break;
				case SEN_OFF:
					sens = SEN_ON;
					break;
				};
			}
			if (sens == SEN_ON)
				vif_scrmousesens[i-2] = True;
			if (sens == SEN_OFF)
				vif_scrmousesens[i-2] = False;
		}
		for (i = 7; i <= (num_buttons+6); i++) {
			sens = ap->vac_setsensitive[i];
			/* Iff BOOLEAN on do state inverse */
			if ((ap->vac_flags & VAC_BOOLEAN) && ap->vac_boolstate){
				switch (sens) {
				case SEN_ON:
					sens = SEN_OFF;
					break;
				case SEN_OFF:
					sens = SEN_ON;
					break;
				};
			}
			if (sens == SEN_ON &&
				!XtIsSensitive(vif_buts[i-7]))
				XtSetSensitive(vif_buts[i-7], True);
			if (sens == SEN_OFF &&
				XtIsSensitive(vif_buts[i-7]))
				XtSetSensitive(vif_buts[i-7], False);
		}
	}
	/* Send chars down pty to client action */
	if (ap->vac_flags & VAC_PTYCHARS) {
		if (ap->vac_flags & VAC_BOOLEAN) {
			if (ap->vac_boolstate) {
				st = ap->vac_boolstring;
				ap->vac_boolstate = 0;
			} else {
				st = ap->vac_instring;
				ap->vac_boolstate++;
			}
		} else {
			st = ap->vac_instring;
		}
		write(screen->respond,st,strlen(st));
	}
	/* Pop up a text string */
	if ((ap->vac_flags & VAC_POPUPTEXT) && popuptextdat.timerid == NULL) {
		struct popupstuff *pp = &popuptextdat;
		char *p, *pos;
		int len;

		XtGetValues(toplevel, getpos, XtNumber(getpos));
		/* Iff from a filter, fill in matchstring */
		if (w == NULL && (p = index(ap->vac_popuptext, '^')) != NULL &&
			ap->vac_matchlen > 0) {
			pos = ptext;
			if (p > ap->vac_popuptext) {
				len = p-ap->vac_popuptext;
				bcopy(ap->vac_popuptext, pos, len);
				pos += len;
			}
			bcopy(ap->vac_matchstring, pos, ap->vac_matchlen);
			pos += ap->vac_matchlen;
			if (*(p+1) != '\0') {
				len = strlen(++p);
				bcopy(p, pos, len);
				pos += len;
			}
			*pos = '\0';
			setargl[0].value = (XtArgVal) ptext;
		} else {
			setargl[0].value = (XtArgVal) ap->vac_popuptext;
		}
		setargl[1].value = (XtArgVal) bgr;
		setargl[2].value = (XtArgVal) fgr;
		XtSetValues(pp->popupsubw, setargl, 3);
		tim = (ap->vac_popuptime < VIF_POPUPMINTIME) ?
			VIF_POPUPMINTIME : ap->vac_popuptime;
		XTranslateCoordinates(XtDisplay(toplevel), XtWindow(toplevel),
			RootWindowOfScreen(XtScreen(toplevel)), 0, 0, &xpos, &ypos, &ww);
		setpos[0].value = (XtArgVal) (xpos+wid/2);
		setpos[1].value = (XtArgVal) (ypos+VIF_TITLEH/2);
		XtSetValues(pp->popupw, setpos, 2);
		XtPopup(pp->popupw, XtGrabNone);
		XSync(XtDisplay(toplevel), False);
		pp->timerid = XtAddTimeOut(tim, popup_timer, (caddr_t) pp);
	}
	/* Pop up an icon */
	if ((ap->vac_flags & VAC_POPUPICON) && popupicondat.timerid == NULL) {
		struct popupstuff *pp = &popupicondat;

		if (pp->popupsubw != NULL) {
			XtUnmanageChild(pp->popupsubw);
			XtDestroyWidget(pp->popupsubw);
		}
		XtGetValues(toplevel, getpos, XtNumber(getpos));
		seticonl[0].value = (XtArgVal) ap->vac_popupicon;
		seticonl[1].value = (XtArgVal) ap->vac_popupiconwidth;
		seticonl[2].value = (XtArgVal) ap->vac_popupiconheight;
		seticonl[3].value = (XtArgVal) bgr;
		seticonl[4].value = (XtArgVal) fgr;
		pp->popupsubw = XtCreateManagedWidget("popupi", iconWidgetClass,
			pp->popupw, seticonl, 5);
		tim = (ap->vac_popuptime < VIF_POPUPMINTIME) ?
			VIF_POPUPMINTIME : ap->vac_popuptime;
		XTranslateCoordinates(XtDisplay(toplevel), XtWindow(toplevel),
			RootWindowOfScreen(XtScreen(toplevel)), 0, 0, &xpos, &ypos, &ww);
		setpos[0].value = (XtArgVal) (xpos+wid-ap->vac_popupiconwidth-14);
		setpos[1].value = (XtArgVal) (ypos+7+(VIF_TITLEH-ap->vac_popupiconheight)/2);
		XtSetValues(pp->popupw, setpos, 2);
		XtPopup(pp->popupw, XtGrabNone);
		XSync(XtDisplay(toplevel), False);
		pp->timerid = XtAddTimeOut(tim, popup_timer, (caddr_t) pp);
	}
	/* Change the pointer cursor */
	if (ap->vac_flags & VAC_NEWMOUSE) {
		XDefineCursor(XtDisplay(toplevel), XtWindow(toplevel),
			ap->vac_newmouse);
		XFlush(XtDisplay(toplevel));
		if (vif_mousetimerid != NULL) {
			XtRemoveTimeOut(vif_mousetimerid);
			vif_mousetimerid = NULL;
		}
		if (ap->vac_mousetime != 0)
			vif_mousetimerid = XtAddTimeOut(ap->vac_mousetime,
				mouse_timer, (caddr_t) NULL);
	}
	/* Put chars out on terminal emulation screen */
	if (ap->vac_flags & VAC_VTCHARS) {
		int l;

		l = strlen(ap->vac_outstring);
		if (l > 0) {
			if (bcnt == 0)
				bptr = buffer;
			if (l > (2*BUF_SIZE-(bcnt+(bptr-buffer))))
				l = 2*BUF_SIZE-(bcnt+(bptr-buffer));
			bcopy(ap->vac_outstring, bptr+bcnt, l);
			bcnt += l;
		}
	}
	/* Pop up a dialog box */
	if (ap->vac_flags & VAC_DIALOGBOX) {
		DialogWidget dw;
		char *p, *pos;
		int len;

		vif_curactp = ap;
		if (re_comp(ap->vac_dialogregex) == 0) {
			dw = (DialogWidget) vif_dialboxw;
			/* Iff from a filter, fill in matchstring */
			if (w == NULL && (p = index(ap->vac_dialogstring, '^')) != NULL &&
				ap->vac_matchlen > 0) {
				pos = ptext;
				if (p > ap->vac_dialogstring) {
					len = p-ap->vac_dialogstring;
					bcopy(ap->vac_dialogstring, pos, len);
					pos += len;
				}
				bcopy(ap->vac_matchstring, pos, ap->vac_matchlen);
				pos += ap->vac_matchlen;
				if (*(p+1) != '\0') {
					len = strlen(++p);
					bcopy(p, pos, len);
					pos += len;
				}
				*pos = '\0';
				setargl[0].value = (XtArgVal) ptext;
			} else {
				setargl[0].value = (XtArgVal) ap->vac_dialogstring;
			}
			XtSetValues(dw->dialog.labelW, setargl, 1);
			XTranslateCoordinates(XtDisplay(toplevel), XtWindow(toplevel),
			RootWindowOfScreen(XtScreen(toplevel)), 0, 0, &xpos, &ypos, &ww);
			setpos[0].value = (XtArgVal)(xpos+30);
			setpos[1].value = (XtArgVal)(ypos+100);
			XtSetValues(vif_dialogw, setpos, 2);
			XtTextErase(dw->dialog.valueW);
			XtPopup(vif_dialogw, XtGrabExclusive);
			warp_pointer(dw->dialog.valueW);
		}
	}
	/* Pop up a yes/no box */
	if (ap->vac_flags & VAC_YESNOBOX) {
		DialogWidget dw;
		char *p, *pos;
		int len;

		vif_curactp = ap;
		dw = (DialogWidget) vif_yesnoboxw;
		/* Iff from a filter, fill in matchstring */
		if (w == NULL && (p = index(ap->vac_yesnoquery, '^')) != NULL &&
			ap->vac_matchlen > 0) {
			pos = ptext;
			if (p > ap->vac_yesnoquery) {
				len = p-ap->vac_yesnoquery;
				bcopy(ap->vac_yesnoquery, pos, len);
				pos += len;
			}
			bcopy(ap->vac_matchstring, pos, ap->vac_matchlen);
			pos += ap->vac_matchlen;
			if (*(p+1) != '\0') {
				len = strlen(++p);
				bcopy(p, pos, len);
				pos += len;
			}
			*pos = '\0';
			setargl[0].value = (XtArgVal) ptext;
		} else {
			setargl[0].value = (XtArgVal) ap->vac_yesnoquery;
		}
		XtSetValues(dw->dialog.labelW, setargl, 1);
		XTranslateCoordinates(XtDisplay(toplevel), XtWindow(toplevel),
			RootWindowOfScreen(XtScreen(toplevel)), 0, 0, &xpos, &ypos, &ww);
		setpos[0].value = (XtArgVal)(xpos+30);
		setpos[1].value = (XtArgVal)(ypos+50);
		XtSetValues(vif_yesnow, setpos, 2);
		XtPopup(vif_yesnow, XtGrabExclusive);
		warp_pointer(vif_yesbuttonw);
	}
	/* And warp the pointer to a widget (must be last) */
	if (ap->vac_flags & (VAC_WARPPBOOL|VAC_WARPPOINTER)) {
		if (ap->vac_flags & VAC_BOOLEAN) {
			if (!(ap->vac_boolstate)) {
				if (ap->vac_flags & VAC_WARPPBOOL)
					warp_pointer(ap->vac_warpwidget);
			} else {
				if (ap->vac_flags & VAC_WARPPOINTER)
					warp_pointer(ap->vac_warpwidget);
			}
		} else {
			if (ap->vac_flags & VAC_WARPPOINTER)
				warp_pointer(ap->vac_warpwidget);
		}
	}
}

#define SCROLLACEL	50

/*
 * Handle scrollbar callback, essentially N calls to action based
 * on acceleration parameters and offset.
 */
void vif_scroller(w, val, newpos)
	Widget w;
	caddr_t val;
	float newpos;
{
	register struct vif_config *vc = vif_conf;
	register int cnt;
	register TScreen *screen = &term->screen;
	int num;
	float diff;
	struct vif_act *ap;

	diff = newpos-0.475;
	if (diff > 0.0) {
		ap = &vif_actions[vc->vc_scrollup];
		if (vc->vc_scrollacel == 1)
			num = 1;
		else
			num = (int)(diff * vc->vc_scrollacel * 2.0);
	} else if (diff < 0.0) {
		ap = &vif_actions[vc->vc_scrolldown];
		if (vc->vc_scrollacel == 1)
			num = 1;
		else
			num = (int)((-diff) * vc->vc_scrollacel * 2.0);
	} else
		return;
	for (cnt = 0; cnt < num; cnt++)
		vif_action(w, (caddr_t)ap, (caddr_t) NULL);
	XtScrollBarSetThumb(w, 0.475, 0.0);
}

/*
 * Callback to pop up help windows, used when a widget has no other
 * callback routine
 */
void vif_help(w, val, val2)
	Widget w;
	caddr_t val;
	caddr_t val2;
{
	if (val2 != NULL) {
		if (*val2 == 'H') {
			popup_help(&vif_helphead, &vif_popuphead, w);
		}
		return;
	}
}

/*
 * Callback from accept button on dialog box
 */
void vif_accept(w, p1, p2)
	Widget w;
	caddr_t p1, p2;
{
	register struct vif_act *ap;
	TScreen *screen = &term->screen;
	char *sval;
	char *pp;
	DialogWidget dw;
	LabelWidget lw;
	static char *labelptr;
	static Pixel fgr, bgr;
	static char errstr[1024];
	static Arg	getargl[] = {
		{XtNlabel,	(XtArgVal)&labelptr},
		{XtNforeground, (XtArgVal)&fgr},
		{XtNbackground, (XtArgVal)&bgr},
	};
	static Arg	setargl[] = {
		{XtNlabel,	(XtArgVal) NULL},
		{XtNforeground, (XtArgVal) NULL},
		{XtNbackground, (XtArgVal) NULL},
	};

	/* Handle non-select input */
	if (p2 != NULL) {
		if (*p2 == 'H') {
			popup_help(&vif_helphead, &vif_popuphead, w);
		}
		return;
	}
	/* Get the string */
	sval = XtDialogGetValueString(vif_dialboxw);
	ap = vif_curactp;
	/* See if it passes the regular expression */
	if (re_exec(sval)) {
		/* and send it down the pty iff it does */
		pp = index(ap->vac_dialogresp, '^');
		if (pp != NULL && pp > ap->vac_dialogresp)
			write(screen->respond, ap->vac_dialogresp, pp-ap->vac_dialogresp);
		write(screen->respond, sval, strlen(sval));
		if (pp != NULL && *(pp+1) != '\0')
			write(screen->respond, pp+1, strlen(pp+1));
		XtPopdown(vif_dialogw);
	} else {
		/* Pop up match pattern in rev video and wait for new string */
		dw = (DialogWidget) vif_dialboxw;
		lw = (LabelWidget) dw->dialog.labelW;
		sprintf(errstr, "Bad Match %s", ap->vac_dialogregex);
		XtGetValues(lw, getargl, XtNumber(getargl));
		setargl[0].value = (XtArgVal) errstr;
		setargl[1].value = (XtArgVal) bgr;
		setargl[2].value = (XtArgVal) fgr;
		XtSetValues(lw, setargl, XtNumber(setargl));
		/* Kludge, but how else do i get the string redrawn */
		(*(lw->core.widget_class->core_class.expose))(lw, (XEvent *) NULL, (Region) NULL);
		XFlush(XtDisplay(lw));
		/* wait a bit */
		sleep(1);
		XtTextErase(((DialogWidget)vif_dialboxw)->dialog.valueW);
		setargl[0].value = (XtArgVal) labelptr;
		setargl[1].value = (XtArgVal) fgr;
		setargl[2].value = (XtArgVal) bgr;
		XtSetValues(lw, setargl, XtNumber(setargl));
	}
}

/*
 * Callback routine for Cancel dialog box
 */
void vif_cancel(w, p1, p2)
	Widget w;
	caddr_t p1, p2;
{

	/* Handle non-select input */
	if (p2 != NULL) {
		if (*p2 == 'H') {
			popup_help(&vif_helphead, &vif_popuphead, w);
		}
		return;
	}
	/* pop it down */
	XtPopdown(vif_dialogw);
}

/*
 * Callback routine for yes/no dialog box
 */
void vif_yesno(w, dat, p2)
	Widget w;
	caddr_t dat, p2;
{
	TScreen *screen = &term->screen;

	/* Handle non-select input */
	if (p2 != NULL) {
		if (*p2 == 'H') {
			popup_help(&vif_helphead, &vif_popuphead, w);
		}
		return;
	}
	/* Write yes or no string to pty */
	if (dat != NULL)
		write(screen->respond, vif_curactp->vac_yesstring, strlen(vif_curactp->vac_yesstring));
	else
		write(screen->respond, vif_curactp->vac_nostring, strlen(vif_curactp->vac_nostring));
	XtPopdown(vif_yesnow);
}

static struct nlist vif_nl[] = {
	{ "_vifconf", 0, 0, 0, 0, },
	{ "_kbdyylookdfa", 0, 0, 0, 0, },
	{ "_ptyylookdfa", 0, 0, 0, 0, },
	{ "", 0, 0, 0, 0, }};
char *get_conf();
/*
 * Get config for this vif
 */
vif_getconf(confnam)
	char *confnam;
{
	register int i;
	register struct vif_actc *vp;
	register struct vif_act *va;
	int j;
	Pixmap pm;
	XColor exact;
	char *ptr;

	/* Call get conf to read in the .o file */
	ptr = get_conf(confnam, vif_nl);
	if ((vif_conf = (struct vif_config *)(ptr+vif_nl[0].n_value)) == NULL)
		serr("No vif_conf in config");
	if ((kbdyylookdfaptr = (struct yylookdfa *)(ptr+vif_nl[1].n_value))
		== NULL && (vif_conf->vc_flags & VC_KBFILTER))
		serr("No kbd filter in config");
	if ((ptyylookdfaptr = (struct yylookdfa *)(ptr+vif_nl[2].n_value))
		== NULL && (vif_conf->vc_flags & VC_PTYFILTER))
		serr("No pty filter in config");
	vp = vif_conf->vc_actions;
	va = vif_actions;
	/* Initialize the default pixel colours */
	vif_fgrcolr = init_colour(vif_conf->vc_fgr);
	vif_bgrcolr = init_colour(vif_conf->vc_bgr);
	/* And get colours for cursors */
	XAllocNamedColor(XtDisplay(toplevel), DefaultColormapOfScreen(XtScreen(toplevel)),
		vif_conf->vc_cursfgr, &vif_cursfgr, &exact);
	XAllocNamedColor(XtDisplay(toplevel), DefaultColormapOfScreen(XtScreen(toplevel)),
		vif_conf->vc_cursbgr, &vif_cursbgr, &exact);
	/* Initialize the vif_actions table using vif_actc table */
	for (i = 0; i < MAXACTIONS; i++) {
		if (vp->va_flags & VAC_VALID) {
			va->vac_flags = vp->va_flags;
			va->vac_instring = vp->va_instring;
			va->vac_boolstring = vp->va_boolstring;
			va->vac_outstring = vp->va_outstring;
			va->vac_dialogstring = vp->va_dialogstring;
			va->vac_dialogregex = vp->va_dialogregex;
			va->vac_dialogresp = vp->va_dialogresp;
			va->vac_yesnoquery = vp->va_yesnoquery;
			va->vac_yesstring = vp->va_yesstring;
			va->vac_nostring = vp->va_nostring;
			va->vac_popuptext = vp->va_popuptext;
			va->vac_popuptime = vp->va_popuptime;
			va->vac_popupicon = vp->va_popupiconbits;
			va->vac_popupiconwidth = vp->va_popupiconwidth;
			va->vac_popupiconheight = vp->va_popupiconheight;
			va->vac_mousetime = vp->va_mousetime;
			if (vp->va_flags & VAC_NEWMOUSE) {
				pm = XCreateBitmapFromData(XtDisplay(toplevel),
					RootWindowOfScreen(XtScreen(toplevel)),
					vp->va_mousebits,
					vp->va_mousewidth, vp->va_mouseheight);
				va->vac_newmouse = XCreatePixmapCursor(
					XtDisplay(toplevel), pm, None, &vif_cursfgr,
					&vif_cursbgr, vp->va_mousehotx,
					vp->va_mousehoty);
				XFreePixmap(XtDisplay(toplevel), pm);
			}
			if (vp->va_flags & VAC_SETSENSTV) {
				for (j = 0; j < (MAXBUTTONS+7); j++) {
					va->vac_setsensitive[j] = vp->va_setsensitive[j];
				}
			}
		}
		va++;
		vp++;
	}
}

/*
 * Handle mouse input on the screen window
 */
vif_screenbutton(event)
	register XButtonEvent *event;
{
	register TScreen *screen = &term->screen;
	int r, c, dr, dc;
	register int i;
	register char *cpt, *rpt;
	struct vif_act *actp;
	Widget www;

	www = (Widget) 0xffffffff;
	pointtocharpos(event->y, event->x, &r, &c);
	switch (event->button) {
	case Button1:
	if (!vif_scrmousesens[0])
		return;
	if (vif_conf->vc_flags & VC_MOUSEPOS) {
		if (r != screen->cur_row) {
			for (i = 0; i < screen->cur_col; i++)
				write(screen->respond, "\033OD", 3);
			dr = r-screen->cur_row;
			if (dr < 0) {
				dr = -dr;
				rpt = "\033OA";
			} else {
				rpt = "\033OB";
			}
			for (i = 0; i < dr; i++)
				write(screen->respond, rpt, 3);
			for (i = 0; i < c; i++)
				write(screen->respond, "\033OC", 3);
		} else {
			dc = c-screen->cur_col;
			if (dc < 0) {
				dc = -dc;
				cpt = "\033OD";
			} else {
				cpt = "\033OC";
			}
			for (i = 0; i < dc; i++)
				write(screen->respond, cpt, 3);
		}
	}
	break;
	case Button2:
	if (!vif_scrmousesens[1])
		return;
	if (vif_conf->vc_flags & VC_MOUSE2) {
		/* put r, c in action struct. */
		actp = &vif_actions[vif_conf->vc_screenmouse2];
		actp->vac_row = r;
		actp->vac_col = c;
		vif_action(www, (caddr_t) actp, (caddr_t) NULL);
	}
	break;
	case Button3:
	if (!vif_scrmousesens[2])
		return;
	if (vif_conf->vc_flags & VC_MOUSE3) {
		/* put r, c in action struct. */
		actp = &vif_actions[vif_conf->vc_screenmouse3];
		actp->vac_row = r;
		actp->vac_col = c;
		vif_action(www, (caddr_t) actp, (caddr_t) NULL);
	}
	break;
	case Button4:
	if (!vif_scrmousesens[3])
		return;
	if (vif_conf->vc_flags & VC_MOUSE4) {
		/* put r, c in action struct. */
		actp = &vif_actions[vif_conf->vc_screenmouse4];
		actp->vac_row = r;
		actp->vac_col = c;
		vif_action(www, (caddr_t) actp, (caddr_t) NULL);
	}
	break;
	case Button5:
	if (!vif_scrmousesens[4])
		return;
	if (vif_conf->vc_flags & VC_MOUSE5) {
		/* put r, c in action struct. */
		actp = &vif_actions[vif_conf->vc_screenmouse5];
		actp->vac_row = r;
		actp->vac_col = c;
		vif_action(www, (caddr_t) actp, (caddr_t) NULL);
	}
	break;
	};
}

/*
 * Timeout on popup, just erase
 */
static void popup_timer(pd, tid)
	caddr_t pd;
	XtIntervalId *tid;
{
	register struct popupstuff *pp;

	pp = (struct popupstuff *)pd;
	if (pp->timerid == *tid) {
		pp->timerid = NULL;
		XtPopdown(pp->popupw);
	}
}

/*
 * Timeout on new mouse, just Undefine cursor
 */
static void mouse_timer()
{
	XUndefineCursor(XtDisplay(toplevel), XtWindow(toplevel));
	XFlush(XtDisplay(toplevel));
}

/*
 * Poke timer queue. (won't be necessary iff xterm starts using XtNextEvent)
 * THIS IS A MAJOR KLUDGE, NOTE THAT NextEvent.c is identical to distribution
 * except that "TimerQueue" is NOT declared static so i can extern it here..
 * This is yanked directly out of Xt...
 */
#define IS_AFTER(t1, t2) (((t2).tv_sec > (t1).tv_sec) \
	|| (((t2).tv_sec == (t1).tv_sec)&& ((t2).tv_usec > (t1).tv_usec)))
typedef struct _TimerEventRec {

        struct timeval   te_timer_value;
	struct _TimerEventRec *te_next;
	Display *te_dpy;
	XtTimerCallbackProc	te_proc;
	caddr_t	te_closure;
}TimerEventRec;
extern TimerEventRec *TimerQueue;

/*
 * Poke the timer queue
 * This is just the loop in XtNextEvent(), but since xterm doesn't call
 * XtNextEvent(), I have to do it here..
 */
void vif_poketimer()
{
    register TimerEventRec *te_ptr;
    struct timeval  cur_time;
    struct timezone cur_timezone;

	(void) gettimeofday (&cur_time, &cur_timezone);
	if (TimerQueue!= NULL) {	/* check timeout queue */
		while(IS_AFTER (TimerQueue->te_timer_value, cur_time)) {
			te_ptr = TimerQueue;
			TimerQueue = TimerQueue->te_next;
			te_ptr->te_next = NULL;
			TeCallProc(te_ptr);
			XtFree((char*)te_ptr);
		}
	}
}

/*
 * Initialize the vac_warpwidget values
 */
init_warp(vc, termw)
	struct vif_config *vc;
	Widget termw;
{
	register struct vif_actc *vp;
	register int j, i;
	register struct vif_sel *vsl;
	struct vif_act *va;
	Widget w;

	vp = vc->vc_actions;
	va = vif_actions;
	/* Loop through the actions and find the widget id to warp to */
	for (i = 0; i < MAXACTIONS; i++) {
		w = (Widget) NULL;
		if ((vp->va_flags & (VAC_VALID|VAC_WARPPOINTER)) ==
			(VAC_VALID|VAC_WARPPOINTER)) {
			if (strcmp(vp->va_warpwidgetname, "Term") == 0) {
				w = termw;
			} else if (strcmp(vp->va_warpwidgetname, "Scroll") == 0) {
				w = vif_scrollw;
			} else {
				vsl = vc->vc_selitem;
				for (j = 0; j < num_buttons; j++) {
					if (strcmp(vp->va_warpwidgetname,
						vsl->vsl_label) == 0) {
						w = vif_buts[j];
						break;
					}
					vsl++;
				}
			}
			if (w != NULL)
				va->vac_warpwidget = w;
			else
				va->vac_flags &= ~VAC_WARPPOINTER;
		}
		va++;
		vp++;
	}
}


/*
 * Snitched out of xterm V10R4 to do page scrolling
 * Called directly from Index() in cursor.c
 */
vif_index(screen, amount)
register TScreen	*screen;
register int	amount;
{
	register int lines, j;
	register char *str;
	int n;
	char buf;
	Window ww;
	XEvent ev;
	XButtonEvent *bev;
	static int xpos, ypos, wid;
	static Arg getpos[] = {
		{XtNwidth, (XtArgVal) &wid},
	};
	static Arg setpos[] = {
		{XtNx,	(XtArgVal) NULL},
		{XtNy,	(XtArgVal) NULL},
	};

	/* 
	 * indexing when below scrolling region is cursor down.
	 * if cursor high enough, no scrolling necessary.
	 */
	if (screen->cur_row > screen->bot_marg
	 || screen->cur_row + amount <= screen->bot_marg) {
		if(screen->pagemode)
			screen->pagecnt += amount;
		CursorDown(screen, amount);
		return;
	}

	CursorDown(screen, j = screen->bot_marg - screen->cur_row);
	amount -= j;
	if((lines = screen->bot_marg - screen->top_marg - 1)
	 <= 0)
		lines = 1;
	if(!screen->pagemode || (amount + screen->pagecnt) <= lines) {
		if(screen->pagemode)
			screen->pagecnt += amount;
		Scroll(screen, amount);
		return;
	}
	bev = (XButtonEvent *)&ev;
	ioctl(screen->respond, TIOCSTOP, NULL);
	if(screen->cursor_state)
		HideCursor();
	if((j = lines - screen->pagecnt) > 0) {
		Scroll(screen, j);
		amount -= j;
	}
	/* Loop scrolling out pages until no more output ready */
	do {
		if(screen->scroll_amt)
			FlushScroll(screen);
		j = FALSE;
		/* Pop up, press button for more mesg. */
		XtGetValues(toplevel, getpos, XtNumber(getpos));
		XTranslateCoordinates(XtDisplay(toplevel), XtWindow(toplevel),
			RootWindowOfScreen(XtScreen(toplevel)), 0, 0, &xpos, &ypos, &ww);
		setpos[0].value = (XtArgVal) (xpos+wid/2);
		setpos[1].value = (XtArgVal) (ypos+VIF_TITLEH/2);
		XtSetValues(vif_pagescrw, setpos, 2);
		XtPopup(vif_pagescrw, XtGrabNone);
		/* Loop arround until scroll continue input */
		do {
			XNextEvent(screen->display, &ev);
			switch((int)ev.type) {
			 /* <cr> scroll one line, otherwise scroll a page */
			 case KeyPress:
				str = &buf;
				n = XLookupString(&ev, str, 1, NULL, NULL);
				if(n > 0) {
					if(*str == '\r')
						screen->pagecnt = (lines - 1);
					else if(*str < ' ' || *str == '\177') {
						screen->pagecnt = 0;
						Input(&term->keyboard, screen,
						 &ev);
						ioctl(screen->respond, TIOCSTOP,
						 NULL);
					} else
						screen->pagecnt = 0;
				} else
					screen->pagecnt = 0;
				j = TRUE;
				break;
			case ButtonPress:
				/*
				 * For mouse button presses in term window:
				 * Button1 - scroll a page
				 * Button2 - scroll half a page
				 * Button3 - scroll a line
				 */
				if (bev->window == XtWindow(term)) {
					switch (bev->button) {
					case Button2:
						screen->pagecnt = lines/2;
						break;
					case Button3:
						screen->pagecnt = lines-1;
						break;
					default:
						screen->pagecnt = 0;
					};
					j = TRUE;
				} else {
					XtDispatchEvent(&ev);
				}
				break;
			case ButtonRelease:
				if (bev->window == XtWindow(term))
					break;
			 default:
				XtDispatchEvent(&ev);
				break;
			}
		} while(!j);
		/* Pop down, press button for more mesg. */
		XtPopdown(vif_pagescrw);
		j = lines - screen->pagecnt;
		if(j > amount)
			j = amount;
		Scroll(screen, j);
		screen->pagecnt += j;
	} while((amount -= j) > 0);
	ioctl(screen->respond, TIOCSTART, NULL);
}

/*
 * Convert point coords to char. pos on screen
 */
static void pointtocharpos(y, x, r, c)
register int y, x;
int *r, *c;
/* Convert pixel coordinates to character coordinates.
   Columns are clipped between to be 0 or greater, but are not clipped to some
       maximum value. */
{
	register TScreen *screen = &term->screen;
	register row, col;

	row = (y - screen->border) / FontHeight(screen);
	if(row < 0)
		row = 0;
	else if(row > screen->max_row)
		row = screen->max_row;
	col = (x - screen->border - screen->scrollbar) / FontWidth(screen);
	if(col < 0)
		col = 0;
	else if(col > screen->max_col+1) {
		col = screen->max_col+1;
	}
	*r = row;
	*c = col;
}

/*
 * Called to pop up the defunct msg
 */
vif_defunctmsg()
{
	register LabelWidget lw = (LabelWidget) titlew;
	static char namestr[81], *nameptr;
	static Pixel fgr, bgr;
	static Arg getstr[] = {
		{XtNlabel,	(XtArgVal) &nameptr},
		{XtNforeground,	(XtArgVal) &fgr},
		{XtNbackground,	(XtArgVal) &bgr},
	};
	static Arg setstr[] = {
		{XtNlabel,	(XtArgVal) namestr},
		{XtNforeground,	(XtArgVal) NULL},
		{XtNbackground,	(XtArgVal) NULL},
	};

	if (vif_defunct) {
		XtGetValues(lw, getstr, XtNumber(getstr));
		strncpy(namestr, nameptr, 80);
		strncat(namestr, DEFUNCTMSG, 80);
		namestr[80] = '\0';
		setstr[1].value = (XtArgVal) bgr;
		setstr[2].value = (XtArgVal) fgr;
		XtSetValues(lw, setstr, XtNumber(setstr));
		/* Kludge, but how else do i get the string redrawn */
		(*(lw->core.widget_class->core_class.expose))(lw, (XEvent *) NULL, (Region) NULL);
		XFlush(XtDisplay(lw));
	}
}

