/*

Copyright 1988 by the University of Guelph

Permission to use, copy and modify this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation.
University of Guelph makes no representations about the suitability of
this software for any purpose.  It is provided "as is"
without express or implied warranty.

*/

/*
 * This is loosely based on Xttylib.c in X 10.4
 * These routines pass around a pointer to a TTYWindow:
 *
 * typedef struct _TTYWindow {
 * 	Window w;		The window id
 *	int pid;		The pid of the subprocess xterm
 *	short file;		The file id of the tty to read/write characters to/from
 * } TTYWindow;
 *
 */

#include <X11/Xos.h>
#include <stdio.h>
#include <signal.h>
#include <sys/ioctl.h>
#include <sys/param.h>
#include <sgtty.h>
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include "../include/Xtty.h"
#include "../include/gshdirs.h"


static int ttyfds = -1;

TTYWindow *CreateTTYWindow(omask, targp)
	int omask;
	char *targp;
{
	TTYWindow *t;
	char **argp;

	if ((t = (TTYWindow *) malloc(sizeof(TTYWindow))) ==
		NULL) return NULL;

	/* Iff not open yet, open /dev/tty */
	if (ttyfds == -1)
		ttyfds = open("/dev/tty", O_RDWR, 0777);
	argp = &targp;
	if (Start_slave_xterm(t, omask,
		argp) == 0) {
	    free((char *)t);
	    return NULL;
	}

	return t;
}

int ttyMasterPty;
int keepMasterOpen = 0;

int Start_slave_xterm(t, omask, argp)
	TTYWindow *t;
	int omask;
	char **argp;
{
#define BUFSIZE 20
#define	LISTSIZE 40
#define	TIMOUT	15
/* States for sync scan */
#define LOOKSYNC	1
#define	GETSYNC		2
#define	GETWIN		3

	char ttyName[BUFSIZE];
	char Sbuf[BUFSIZE], sizeBuf[BUFSIZE],
		inputBuffer[BUFSIZE];
	char *outp[LISTSIZE];
	char outpath[MAXPATHLEN];
	char c;
	int len;
	int state, i;
	int ofd;
	Boolean notdone;
	struct sgttyb ttyb;
	struct timeval tmv;
	fd_set readfd;
	int numsel;
	int (*ofunc)();

	strcpy(outpath, XDIR);
	strcat(outpath, "vif");
	/*
	 * Disassociate from /dev/tty so that the pty becomes the
	 * controlling terminal for clients of this vif
	 */
	ioctl(ttyfds, TIOCNOTTY, 0);
	ttyMasterPty = GetPty(ttyName);
	if (ttyMasterPty == -1) return 0;

	/*
	 * And do a vhangup() to clean it up
	 */
	ofunc = signal(SIGHUP, SIG_IGN);
	ttyName[5] = 't';
	ofd = t->file = open(ttyName, O_RDWR, 0);
	if (t->file >= 0)
		vhangup();
	signal(SIGHUP, ofunc);
#ifndef ULTRIX
	t->file = open(ttyName, O_RDWR, 0);
	close(ofd);
#endif
	if ((t->pid = vfork()) < 0) return 0;

	if (t->pid == 0) {
	    close(t->file);
	    sigsetmask(omask);
	    sprintf(Sbuf, "-S%c%c%d", ttyName[8], ttyName[9], ttyMasterPty);
	    outp[0] = "xterm";
	    outp[1] = Sbuf;
	    i = 2;
	    while (i < LISTSIZE && *argp != NULL) {
		outp[i++] = *argp++;
	    }
	    if (i >= LISTSIZE)
		i = LISTSIZE-1;
	    outp[i] = NULL;

	    execv(outpath, outp);
	    _exit();

	} else {

#ifdef notdef
	    /* Open the slave end of the pty */

	    ttyName[5] = 't';	/* Change /dev/pty?? to /dev/tty?? */

	    t->file = open(ttyName, O_RDWR, 0);
#endif
	    
	    if (t->file < 0) {
		    close(ttyMasterPty);
		/* Couldn't open the tty--better get rid of the process */
		kill (t->pid, SIGKILL);
		return 0;
	    }

	    ioctl(t->file, TIOCGETP, &ttyb);
	    ttyb.sg_flags |= RAW;
	    ioctl(t->file, TIOCSETN, &ttyb);
	    /* Read the windowid from the pty */

	    tmv.tv_usec = 0;
	    tmv.tv_sec = TIMOUT;
	    FD_ZERO(&readfd);
	    FD_SET(t->file, &readfd);
	    state = LOOKSYNC;
	    notdone = True;
	    while (notdone) {
		while ((numsel = select(t->file+1, &readfd, NULL, NULL, &tmv)) != 1) {
			if (numsel == 0) {
				    close(ttyMasterPty);
				    close(t->file);
					kill(t->pid, SIGKILL);
					return 0;
			}
			FD_SET(t->file, &readfd);
		}
		if (read(t->file, &c, 1) <= 0) {
		    close(ttyMasterPty);
		    close(t->file);
			kill(t->pid, SIGKILL);
			return 0;
		}
		/* Scan thru sync chars for window id. */
		switch (state) {
		case LOOKSYNC:
			if (c == SYNCHAR)
				state = GETSYNC;
			break;
		case GETSYNC:
			if (c == SYNCHAR2) {
				state = GETWIN;
				len = 0;
			}
			break;
		case GETWIN:
			inputBuffer[len++] = c;
			if (len == sizeof(Window))
				notdone = False;
			break;
		};
	    }
	    if (!keepMasterOpen) close(ttyMasterPty);
	    /* Flush the rest of the garbahge */

	    ioctl(t->file, TIOCFLUSH, (struct sgttyb *) NULL);

	    ttyb.sg_flags &= ~RAW;
	    ioctl(t->file, TIOCSETN, &ttyb);
	    /* the data consists of a binary window ID */
	    t->w = *(Window *)inputBuffer;
	}
	return 1;
#undef BUFSIZE
}

int GetPty(name)
	char *name;
{
	register int devindex, letter;
	int fd;

	strcpy(name, "/dev/ptyp0");

	for (letter = 0; letter < 4; letter++) {
	    name[8] = "pqrs"[letter];
	    
	    for (devindex = 0; devindex < 16; devindex++) {
		name[9] = "0123456789abcdef"[devindex];
		if ((fd = open (name, O_RDWR, 0600)) >= 0) return fd;
	    }
	}
	
	return -1;
}	

