/*

Copyright 1988 by the University of Guelph

Permission to use, copy and modify this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation.
University of Guelph makes no representations about the suitability of
this software for any purpose.  It is provided "as is"
without express or implied warranty.

*/

/*
 * Here is the main line...
 */
#include <X11/Xos.h>
#include <stdio.h>
#include <pwd.h>
#include <sys/signal.h>
#include <sys/param.h>
#include <sys/resource.h>
#include <sys/stat.h>
#include <nlist.h>
#include <X11/Xproto.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/cursorfont.h>
#include <X11/Intrinsic.h>
#include <X11/Atoms.h>
#include <X11/Cardinals.h>
#include <X11/Command.h>
#include <X11/ICommand.h>
#include <X11/Label.h>
#include <X11/Form.h>
#include "../cursors/hour.crs"
#include "../cursors/fullhour.crs"
#include "../icons/reset.icn"
#include "../icons/cancel.icn"
#include "../icons/accept.icn"
#include "../include/tar.h"
#include "../include/help.h"
#include "../include/Xtty.h"
#include "../include/atoms.h"
#include "../include/xgshconf.h"
#include "../include/xgshstate.h"
#include "../include/xgsherr.h"
#include "../include/gshdirs.h"

/*
 * Global vars.
 */
Widget toplevel;		/* top level widget */
GshState	gshstate;
GshConf		*gconfptr;
char	**environ;
int		childsig();
int		xerr();
static char *xgshconf_file;
static Boolean xgshlogin_flg;
static Boolean defaultFALSE = FALSE;
static char disp_ev[256];
static char *xgsh_envir[NENVIR+1];
static Atom resetcursoratom;
static void chdir_prop();
static XrmOptionDescRec options[] = {
	{"-config", "*xgshconf", XrmoptionSepArg, NULL},
	{"-L",      "*xgshloginflg", XrmoptionNoArg,	"off"},
};
static XtResource appl_res[] = {
	{"xgshconf", "Xgshconfile", XtRString, sizeof(char *),
	(Cardinal)&xgshconf_file, XtRString, "defconf.xgsh"},
	{"xgshloginflg", "Xgshloginflg", XtRBoolean, sizeof(Boolean),
	(Cardinal)&xgshlogin_flg,
	XtRBoolean, (caddr_t) &defaultFALSE},
};
extern PidList *menu_pidp;
extern Boolean allocerr;
extern char blkstr[OUTSTRL+1];
extern void help_call();
extern Pixel init_colour();
extern NameList *creat_namelist();
char winstr[50];

/*
 * This main() just calls a series of fuctions to do the work.
 */
main(argc, argv, env)
	int argc;
	char *argv[];
	char **env;
{

	setup(argc, argv);
	init_wins(argc, argv);
	init_topl();
	init_err(gshstate.gs_toplw, (gconfptr->gc_flags & G_ICONERR), gconfptr->gc_errfgr,
		gconfptr->gc_errbgr);
	help_setparent(gshstate.gs_toplw);
	init_exec();
	init_cmds();
	init_names();
	input_loop();
}

char *get_conf();
static struct nlist xgsh_nl[2] = {
	{ "_gshconf", 0, 0, 0, 0, },
	{ "", 0, 0, 0, 0, }};

/*
 * Main input loop, basically just use Xt
 */
input_loop()
{
	register int i;
	register GshState *gs = &gshstate;
	register XAnyEvent *aev;
	register XButtonPressedEvent *be;
	register PidList *pidp;
	XEvent ev;
	Boolean dispatch;
	int omask;
	static char curd[MYMAXPATHLEN+1];
	static int xpos, ypos, high, brdw;
	static Arg getrec[] = {
		{XtNx,		(XtArgVal) &xpos},
		{XtNy,		(XtArgVal) &ypos},
		{XtNheight,	(XtArgVal) &high},
		{XtNborderWidth, (XtArgVal) &brdw},
	};
	static Arg setpos[] = {
		{XtNx,		(XtArgVal) NULL},
		{XtNy,		(XtArgVal) NULL},
	};

	XtRealizeWidget(toplevel);
	/* Set up property change for topl window for abdir */
	gs->gs_chdirwin = XtWindow(gs->gs_toplw);
	sprintf(winstr, "%X", gs->gs_chdirwin);
	XtAddEventHandler(gs->gs_toplw, PropertyChangeMask, False, chdir_prop,
		NULL);
	gs->gs_abdiratom = XInternAtom(gs->gs_disp, A_ABDIR, False);
	resetcursoratom = XInternAtom(gs->gs_disp, A_RESETCURSOR, False);
	/* Pop up first cmd panel */
	i = gs->gs_curtoplevel = gconfptr->gc_firstop;
	if (gconfptr->gc_flags & G_CHDIR) {
		change_dir(i);
	} else {
		if (getwd(curd) == 0)
			curd[0] = '\0';
		gsh_chdir(curd);
	}
	XtGetValues(gs->gs_toplw, getrec, XtNumber(getrec));
	if (gs->gs_toplnum > 1) {
		if (XtIsSensitive(gs->gs_topw[i]))
			XtSetSensitive(gs->gs_topw[i], False);
	}
	setpos[0].value = (XtArgVal) xpos;
	setpos[1].value = (XtArgVal) ypos+high+1;
	XtSetValues(gs->gs_cmdw[i], setpos, 2);
	XtPopup(gs->gs_cmdw[i], XtGrabNone);
	if ((gs->gs_namehead.l_next = creat_namelist()) == NULL)
		ferr(FER_NOMEMORY);
	if (gconfptr->gc_flags & G_WARPPOINTER)
		warp_pointer(gs->gs_defcmdw[i]);
	be = (XButtonPressedEvent *) &ev;
	/* Main input loop */
	aev = (XAnyEvent *) &ev;
	for (;;) {
		XtNextEvent(aev);
		if ((be->type == ButtonPress || be->type == ButtonRelease) &&
			XtWindowToWidget(gs->gs_disp, be->window) == NULL) {
			dispatch = False;
			XAllowEvents(gs->gs_disp, AsyncPointer,
				CurrentTime);
			XFlush(gs->gs_disp);
		} else {
			dispatch = True;
		}
		/* Kludge city.. i grab button3 presses on vif windows here */
		if (!dispatch && be->type == ButtonPress && be->button == Button3) {
			if (menu_pidp == NULL) {
				omask = sigblock(sigmask(SIGCHLD));
				pidp = gs->gs_pidlist.next;
				while (pidp != NULL) {
					if ((pidp->flags & C_TTY)
					&& pidp->ttywin != NULL
					&& pidp->ttywin->w == be->window) {
						_XtPopup(gs->gs_procmenuw, XtGrabExclusive,
							TRUE);
						menu_pidp = pidp;
						break;
					}
					pidp = pidp->next;
				}
				sigsetmask(omask);
			}
		}
		if (dispatch)
			XtDispatchEvent(aev);
	}
}

static char *fakeargv[] = {
	"xgsh",
	"-display",
	"unix:0",
	0 };
/*
 * Does assorted setup activities not related to windows and panels.
 */
setup(argc, argv)
	int argc;
	char *argv[];
{
	register int i;
	register char **env;
	register char **ev;
	GshState *gs = &gshstate;
	GshConf *gc;
	char *ptr;
	Boolean loginflg;
	int logargc;
	char **logargv;

	signal(SIGCHLD, childsig);
	/* iff this is a login shell */
	if (*argv[0] == '-' && argc == 1) {
		appl_res[0].default_addr = argv[0]+1;
		logargc = 3;
		logargv = fakeargv;
		signal(SIGINT, SIG_IGN);
		signal(SIGQUIT, SIG_IGN);
		loginflg = True;
	} else {
		loginflg = False;
		logargc = argc;
		logargv = argv;
	}
	/* Initialize Xt */
	toplevel = XtInitialize("main","XGsh",options,XtNumber(options),
		&logargc, logargv);
	XtGetApplicationResources(toplevel, 0, appl_res, XtNumber(appl_res),
		NULL, 0);
	ptr = get_conf(xgshconf_file, xgsh_nl);
	gc = gconfptr = (GshConf *)(ptr+xgsh_nl[0].n_value);
	if (loginflg) {
		/* set up environment list */
		i = 0;
		ev = gc->gc_envir;
		while (*ev != NULL && i < (NENVIR-1))
			xgsh_envir[i++] = *ev++;
		sprintf(disp_ev, "DISPLAY=%s", DisplayString(XtDisplay(toplevel)));
		xgsh_envir[i++] = disp_ev;
		env = environ;
		while (i < NENVIR && *env != NULL) {
			if (strncmp(**env, "HOME=", 5) == 0)
				xgsh_envir[i++] = *env;
			if (i < NENVIR && strncmp(**env, "USER=", 5) == 0)
				xgsh_envir[i++] = *env;
			env++;
		}
		xgsh_envir[i] = NULL;
		environ = xgsh_envir;
		login_exec();
	}
}

/*
 * Logout function. Good-bye
 */
gshlogout()
{
	register int i, j;
	PidList *pidp;
	GshState *gs = &gshstate;
	struct rusage cusg, usg;
	int tim, ctim;

	signal(SIGCHLD, SIG_IGN);
	if (gs->gs_logfile != NULL) {
		fprintf(gs->gs_logfile,"inputs=%d topls=%d cmds=%d errs=%d helps=%d mjobs=%d pipes=%d\n",
			gs->gs_slog.sl_inputs, gs->gs_slog.sl_chtopls,
			gs->gs_slog.sl_cmds, gs->gs_slog.sl_errs, gs->gs_slog.sl_helps, gs->gs_slog.sl_mjobs,
			gs->gs_slog.sl_pipes);
		if (gconfptr->gc_flags & G_HISTSTATS) {
			for (i = 0; i < NTOPLEVEL; i++)
				if (gconfptr->gc_level[i].l_flags & L_VALID) {
					fprintf(gs->gs_logfile, "%s: ",
					    gconfptr->gc_level[i].l_label);
					for (j = 0; j < NCMD; j++)
						fprintf(gs->gs_logfile, " %d",
						    gs->gs_slog.sl_hist[i][j]);
					fprintf(gs->gs_logfile, "\n");
				}
		}
		getrusage(RUSAGE_CHILDREN, &cusg);
		getrusage(RUSAGE_SELF, &usg);
		ctim = cusg.ru_utime.tv_sec+cusg.ru_stime.tv_sec+
			((cusg.ru_utime.tv_usec+cusg.ru_stime.tv_usec+500000)/
			1000000);
		tim = usg.ru_utime.tv_sec+usg.ru_stime.tv_sec+
			((usg.ru_utime.tv_usec+usg.ru_stime.tv_usec+500000)/
			1000000);
		fprintf(gs->gs_logfile, "cpu times %d+%d = %d\n", tim, ctim, tim+ctim);
		fclose(gs->gs_logfile);
	}
	pidp = gs->gs_pidlist.next;
	while (pidp != NULL) {
		if ((pidp->flags & C_TTY) && (pidp->ttywin != NULL)) {
			/* Make sure vif not stopped */
			kill(pidp->ttywin->pid, SIGCONT);
			kill(pidp->ttywin->pid, SIGUSR1);
		}
		if (pidp->flags & C_DIRB)
			kill(pidp->pid, SIGKILL);
		else if (pidp->flags & (C_TTY|C_ICONW))
			killpg(pidp->pid, SIGKILL);
		else
			killpg(pidp->pid, SIGHUP);
		pidp = pidp->next;
	}
	XUndefineCursor(gs->gs_disp, gs->gs_rootwin);
	XCloseDisplay(gs->gs_disp);
	XFlush(gs->gs_disp);
	exit();
}

/*
 * This function deals with X errors
 */
xerr(disp, errv)
	Display *disp;
	XErrorEvent *errv;
{
	char buf[256];

	switch (errv->error_code) {
	case BadAlloc:
		if (errv->request_code == X_ChangeProperty &&
			errv->resourceid == gshstate.gs_chdirwin) {
			allocerr = True;
			return;
		}
	default:
		XGetErrorText(disp, errv->error_code, buf, 256);
		fprintf(stderr,"xerr err=%s req=%d win=0x%x\n",
			buf, errv->request_code, errv->resourceid);
		break;
	};
}

/*
 * Login exec performs login functions like get /bin/login
 */
login_exec()
{
	if ((gconfptr->gc_flags & G_LOGINCMD) &&
	  gconfptr->gc_logincmd != NULL && *(gconfptr->gc_logincmd) != '\0')
		system(gconfptr->gc_logincmd);
}

/*
 * Initialize the windows required.
 */
init_wins(argc, argv)
	int argc;
	char *argv[];
{
	register GshState *gs = &gshstate;
	register GshConf *gc = gconfptr;
	register int i;
	Pixmap pixm;
	XColor fgr, bgr, exact;
	char *ptr;
	struct passwd *pwp;
	static char helplib[MYMAXPATHLEN+1];

	if ((pwp = getpwuid(getuid())) == NULL)
		serr(FER_NOHOMEDIR);
	gs->gs_homedir = pwp->pw_dir;
	umask(gc->gc_umask);
	if (gc->gc_logfile != NULL && *gc->gc_logfile != '\0') {
		gs->gs_logfile = fopen(gc->gc_logfile, "a");
	}
	/* Set gshstate values for handy things */
	gs->gs_disp = XtDisplay(toplevel);
	gs->gs_screen = XtScreen(toplevel);
#ifndef DEBUG
	XSetErrorHandler(xerr);
#else
	XSynchronize(gs->gs_disp, 1);
#endif
	gs->gs_rootwin = RootWindowOfScreen(gs->gs_screen);
	gs->gs_dispwidth = WidthOfScreen(gs->gs_screen);
#ifdef VR100
	/* dumb kludge to reduce 1024->960 for VR100 monitors on Xqvss */
	gs->gs_dispwidth -= 64;
#endif
	gs->gs_dispheight = HeightOfScreen(gs->gs_screen);
	gs->gs_dispcolorm = DefaultColormapOfScreen(gs->gs_screen);
	/* Get a fixed width base font */
	if ((gs->gs_basefont = XLoadQueryFont(gs->gs_disp, FONT)) == NULL)
		serr(FER_NOBASEFONT);
	XAllocNamedColor(gs->gs_disp, gs->gs_dispcolorm, gc->gc_cursorfgr, &fgr, &exact);
	XAllocNamedColor(gs->gs_disp, gs->gs_dispcolorm, gc->gc_cursorbgr, &bgr, &exact);
	gs->gs_defcursor = XCreateFontCursor(gs->gs_disp, XC_top_left_arrow);
	XRecolorCursor(gs->gs_disp, gs->gs_defcursor, &fgr, &bgr);
	gs->gs_leftcursor = XCreateFontCursor(gs->gs_disp, XC_top_left_corner);
	XRecolorCursor(gs->gs_disp, gs->gs_leftcursor, &fgr, &bgr);
	pixm = XCreateBitmapFromData(gs->gs_disp, gs->gs_rootwin,
		fullhour_bits, fullhour_width, fullhour_height);
	gs->gs_fullhrcursor = XCreatePixmapCursor(gs->gs_disp, pixm, None, &fgr, &bgr,
		fullhour_x_hot, fullhour_y_hot);
	XFreePixmap(gs->gs_disp, pixm);
	pixm = XCreateBitmapFromData(gs->gs_disp, gs->gs_rootwin,
		hour_bits, hour_width, hour_height);
	gs->gs_hrcursor = XCreatePixmapCursor(gs->gs_disp, pixm, None, &fgr, &bgr,
		hour_x_hot, hour_y_hot);
	XFreePixmap(gs->gs_disp, pixm);
	XDefineCursor(gs->gs_disp, gs->gs_rootwin, gs->gs_defcursor);
	/* Initialize help library */
	strcpy(helplib, HELPDIR);
	strncat(helplib, gc->gc_helplib, MYMAXPATHLEN);
	helplib[MYMAXPATHLEN] = '\0';
	init_help(helplib, &(gs->gs_helphead), &(gs->gs_popuphead),
		gc->gc_helpfgr, gc->gc_helpbgr);
	/* Initialize global vars */
	gs->gs_curtoplevel = gc->gc_firstop;
	for (i = 0; i < OUTSTRL; i++)
		blkstr[i] = ' ';
	blkstr[OUTSTRL] = '\0';
}

/*
 * Event handler for property change
 */
static void chdir_prop(w, p1, pev)
	Widget w;
	caddr_t p1;
	XPropertyEvent *pev;
{
	register GshState *gs = &gshstate;
	Atom rtyp;
	int rfmt;
	int ritem, rrem;
	char *p;

	/* Check for Property change on dirbwin */
	if (pev->type == PropertyNotify && pev->window == gs->gs_chdirwin &&
		pev->state == PropertyNewValue) {
		if (pev->atom == gs->gs_abdiratom) {
			XGetWindowProperty(gs->gs_disp, gs->gs_chdirwin,
			gs->gs_abdiratom, 0, MYMAXPATHLEN/4, False,
			XA_STRING, &rtyp, &rfmt, &ritem, &rrem,
			&p);
			if (rtyp == XA_STRING && rfmt == 8
				&& rrem == 0 &&
				ritem > 0) {
				if (chdir(p) < 0)
					err("Can't chdir %s",p);
				else
					gsh_dispdir();
			}
		} else if (pev->atom == resetcursoratom) {
			XDefineCursor(gs->gs_disp, gs->gs_rootwin,
				gs->gs_defcursor);
		}
	}
}

