/* pbmenlarge.c - read a portable bitmap and enlarge it N times
**
** Copyright (C) 1988 by Jef Poskanzer.
**
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted, provided
** that the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation.  This software is provided "as is" without express or
** implied warranty.
*/

#include <stdio.h>
#include "pbm.h"

main( argc, argv )
int argc;
char *argv[];
    {
    FILE *ifd;
    bit **bits, **newbits;
    int argn, n, rows, cols, row, col, subrow, subcol;
    char *usage = "usage:  %s [-N] [pbmfile]\n";

    argn = 1;
    n = 2;

    if ( argn < argc )
	{
	if ( argv[argn][0] == '-' )
	    {
	    if ( sscanf( &(argv[argn][1]), "%d", &n ) != 1 )
		{
		fprintf( stderr, usage, argv[0] );
		exit( 1 );
		}
	    if ( n < 2 )
		{
		fprintf( stderr, usage, argv[0] );
		exit( 1 );
		}
	    argn++;
	    }
	}

    if ( argn == argc )
	ifd = stdin;
    else
	{
	ifd = fopen( argv[argn], "r" );
	if ( ifd == NULL )
	    {
	    fprintf( stderr, "%s: can't open.\n", argv[argn] );
	    exit( 1 );
	    }
	argn++;
	}

    if ( argn != argc )
	{
	fprintf( stderr, usage, argv[0] );
	exit( 1 );
	}

    bits = pbm_readpbm( ifd, &cols, &rows );
    if ( ifd != stdin )
	fclose( ifd );

    newbits = pbm_allocarray( cols * n, rows * n );

    for ( row = 0; row < rows; row++ )
        for ( col = 0; col < cols; col++ )
	    for ( subrow = 0; subrow < n; subrow++ )
		for ( subcol = 0; subcol < n; subcol++ )
		    newbits[row * n + subrow][col * n + subcol] =
			bits[row][col];

    pbm_writepbm( stdout, newbits, cols * n, rows * n );

    exit( 0 );
    }
