/* xbmtopbm.c - read an X bitmap file and produce a portable bitmap
**
** Copyright (C) 1988 by Jef Poskanzer.
**
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted, provided
** that the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation.  This software is provided "as is" without express or
** implied warranty.
*/

#include <stdio.h>
#include <sys/types.h>
#include "pbm.h"

main( argc, argv )
int argc;
char *argv[];
    {
    FILE *ifd;
    bit **bits;
    int rows, cols, row, col, charcount;
    char *data, mask;

    if ( argc > 2 )
	{
	fprintf( stderr, "usage: %s [bitmapfile]\n", argv[0] );
	exit( 1 );
	}
    
    if ( argc == 2 )
	{
	ifd = fopen( argv[1], "r" );
	if ( ifd == NULL )
	    {
	    fprintf( stderr, "%s: can't open.\n", argv[1] );
	    exit( 1 );
	    }
	}
    else
	ifd = stdin;

    if ( ReadBitmapFile( ifd, &cols, &rows, &data ) < 0 )
	{
	fprintf( stderr, "%s: can't load.\n", argv[1] );
	exit( 1 );
	}

    if ( ifd != stdin )
	fclose( ifd );

    bits = pbm_allocarray( cols, rows );

    for ( row = 0; row < rows; row++ )
	{
	charcount = 0;
	mask = 1;
	for ( col = 0; col < cols; col++ )
	    {
	    if ( charcount >= 8 )
		{
		data++;
		charcount = 0;
		mask = 1;
		}
	    bits[row][col] = ( *data & mask ) ? 1 : 0;
	    charcount++;
	    mask = mask << 1;
	    }
	data++;
	}

    pbm_writepbm( stdout, bits, cols, rows );

    exit( 0 );
    }


#ifdef	OS_SYSV
#include <string.h>
#else	OS_SYSV
#include <strings.h>
#endif	OS_SYSV

#define MAX_LINE 81

int
ReadBitmapFile( stream, widthP, heightP, dataP )
FILE *stream;
int *widthP, *heightP;
char **dataP;
    {
    char line[MAX_LINE], name_and_type[MAX_LINE];
    char *ptr, *t;
    int bytes, bytes_per_line, value, version10p, raster_length, padding;

    *widthP = *heightP = -1;

    for ( ; ; )
	{
	if ( ! fgets( line, MAX_LINE, stream ) )
	    break;
	if ( strlen( line ) == MAX_LINE - 1 )
	    {
	    fprintf( stderr, "Line too long.\n" );
	    return -1;
	    }

	if (sscanf(line, "#define %s %d", name_and_type, &value) == 2)
	    {
#ifdef	OS_SYSV
	    if ( ! (t = strrchr( name_and_type, '_' )) )
#else	OS_SYSV
	    if ( ! (t = rindex( name_and_type, '_' )) )
#endif	OS_SYSV
		t = name_and_type;
	    else
		t++;
	    if ( ! strcmp( "width", t ) )
		*widthP = value;
	    if ( ! strcmp( "height", t ) )
		*heightP = value;
	    continue;
	    }
	
	if ( sscanf( line, "static short %s = {", name_and_type ) == 1 )
	    {
	    version10p = 1;
	    break;
	    }
	else if ( sscanf( line, "static char %s = {", name_and_type ) == 1 )
	    {
	    version10p = 0;
	    break;
	    }
	else
	    continue;
	}
 
#ifdef	OS_SYSV
    if ( ! (t = strrchr( name_and_type, '_' )) )
#else	OS_SYSV
    if ( ! (t = rindex( name_and_type, '_' )) )
#endif	OS_SYSV
	t = name_and_type;
    else
	t++;
    
    if ( *widthP == -1 )
	{
	fprintf( stderr, "Invalid width.\n" );
	return -1;
	}
    if ( *heightP == -1 )
	{
	fprintf( stderr, "Invalid height.\n" );
	return -1;
	}

    padding = 0;
    if ( ((*widthP % 16) >= 1) && ((*widthP % 16) <= 8) && version10p )
	padding = 1;

    bytes_per_line = (*widthP+7)/8 + padding;
    
    raster_length =  bytes_per_line * *heightP;
    *dataP = (char *) malloc( raster_length );
    if ( ! *dataP )
	{
	fprintf( stderr, "Not enough memory.\n" );
	return -1;
	}

    if ( version10p )
	for ( bytes = 0, ptr = *dataP; bytes < raster_length; bytes += 2 )
	    {
	    if ( fscanf( stream, " 0x%x%*[,}]%*[ \n]", &value ) != 1 )
		{
		fprintf( stderr, "Error scanning bits item.\n" );
		return -1;
		}
	    *(ptr++) = value & 0xff;
	    if ( (! padding) || ((bytes+2) % bytes_per_line) )
		*(ptr++) = value >> 8;
	    }
	else
	    for ( bytes = 0, ptr = *dataP; bytes < raster_length; bytes++ )
		{
		if ( fscanf( stream, " 0x%x%*[,}]%*[ \n]", &value ) != 1 )
		    {
		    fprintf( stderr, "Error scanning bits item.\n" );
		    return -1;
		    }
		*(ptr++) = value;
		}

    return 0;
    }
