/*
 * Copyright 1988 Anant Agarwal
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation.  No representations about the suitability of this software
 * for any purpose.  It is provided "as is" without express or implied 
 * warranty.
 *
 * Author:  Anant Agarwal, MIT Laboratory for Computer Science
 */

#include <stdio.h>
#include "defs.h"
#include "structs.h"
#include "plot.h"

#define BUFFERSIZE	65536
									
static char *inBuffer;
static char *inBufferend = 0;
static char *inBufferptr = 0;
 
public char *GetSp(size)
int size;
{
char *SpPtr;

	if (size > BUFFERSIZE)
	{
		fprintf(stderr,"GetSp error: asking for too much at once\n");
		exit(1);
	}
    	if ((inBufferptr + size) > inBufferend)
	{								
	    	inBuffer = malloc(BUFFERSIZE);
	    	if (inBuffer == nil)
		{	
			fprintf(stderr,"GetSp error: ran out of memory \n");
			exit(1);		
	    	}
	    	else
		{
		    	inBufferptr = inBuffer;				
			inBufferend = inBuffer + BUFFERSIZE;
		    	SpPtr = inBufferptr;
			inBufferptr += size;
	    	}
	}
	else
	{
	    	SpPtr = inBufferptr;
		inBufferptr += size;
	}								
	return(SpPtr);
}


GetNewObjcurobj() 						
{									
	curobj++;							
	obj[curobj] = (LocalObjectType *) GetSp(sizeof(LocalObjectType)); 
}

