/*
 * Copyright 1988 Anant Agarwal
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation.  No representations about the suitability of this software
 * for any purpose.  It is provided "as is" without express or implied 
 * warranty.
 *
 * Author:  Anant Agarwal, MIT Laboratory for Computer Science
 */

#include <strings.h>	
#include <stdio.h>
#include <math.h>
#include "plotio.h"
#include "defs.h"
#include "structs.h"
#include "plot.h"

extern FILE *fout, *fps, *fin;
extern String infile, outfile, psfile;

extern double getdegrees(), atan(), charheight(),charwidth(),log10(),mylog();

/* psf stuff */
prologue()
{
char c;

	if (doc == 0) /* print only if not document */
	{
		if ((fps = fopen(psfile,"r"))  == NULL)
		{
			fprintf(stderr,"splot: psfile %s not found\n",psfile);
			exit(1);
		}
			/* has psf routines to be included */
		fprintf(fout,"%s\n","%!");
		fprintf(fout,"\n");
	}
	if (landscape)
		fprintf(fout , "560 0 translate 90 rotate\n");
	xtranslate = xtranslate * 72.0;
	ytranslate = ytranslate * 72.0;
	if ((xtranslate != 0.0)||(ytranslate != 0.0))
		fprintf(fout , "%f %f translate\n",xtranslate, ytranslate);
	if ((xpress != 1.0)||(ypress != 1.0))
		fprintf(fout , "%f %f scale\n",xpress, ypress);

	if (doc == 0) /* only if not document */
	{
		while ((c = fgetc(fps)) != EOF)
			fputc(c,fout);
		fclose(fps);
	}
}

epilogue()
{
	if (doc == 0)
		fprintf(fout,"showpage\n");
	fclose(fout);
}
