/* 
 *	FIG : Facility for Interactive Generation of figures
 *
 *	Copyright (c) 1985 by Supoj Sutanthavibul (supoj@sally.UTEXAS.EDU)
 *	January 1985.
 *	1st revision : Aug 1985.
 *
 *	%W%	%G%
*/
#include "fig.h"
#include "resources.h"
#include "const.h"
#include "func.h"
#include "paintop.h"

static int	cur_grid = -1;
extern int	CANVAS_WIDTH, CANVAS_HEIGHT;

#ifndef	X11
static PIXRECT	h_grid_pr, v_grid1_pr, v_grid2_pr;

init_grid()
{
	int	x, y;

	h_grid_pr = mem_create(CANVAS_WIDTH, 1, 1);
	v_grid1_pr = mem_create(1, CANVAS_HEIGHT, 1);
	v_grid2_pr = mem_create(1, CANVAS_HEIGHT, 1);
	for (x = 4; x < CANVAS_WIDTH; x +=5)
	    pr_put(h_grid_pr, x, 0, 1);
	for (x = 0, y = 4; y <= CANVAS_HEIGHT; x++, y +=5)
	    if (x == 3)
		x = -1;
	    else
		pr_put(v_grid1_pr, 0, y, 1);
	for (x = 0, y = 4; y <= CANVAS_HEIGHT; x++, y +=5)
	    if (x == 7)
		x = -1;
	    else
		pr_put(v_grid2_pr, 0, y, 1);
	}

setup_grid(grid)
int	grid;
{
	if (cur_grid == grid) {
	    cur_grid = -1;
	    }
	else {
	    if (grid == F_GRID1)
		put_msg("Quarter inch GRID");
	    else
		put_msg("Half inch GRID");
	    if (cur_grid != -1) {
		draw_grid(cur_grid);
		}
	    cur_grid = grid;
	    }
	draw_grid(grid);
	}


draw_grid(grid)
int	grid;
{
	int 		x, y, resolution;
	PIXRECT		v_grid_pr;

	if (grid == F_GRID1) {
	    v_grid_pr = v_grid1_pr;
	    resolution = PIX_PER_INCH / 4;
	    }
	else {
	    v_grid_pr = v_grid2_pr;
	    resolution = PIX_PER_INCH / 2;
	    }

	/*  vertical grid  */
	for (x = resolution - 1; x <= CANVAS_WIDTH; x += resolution)
	    pw_write(canvas_pixwin, x, 0, 1, CANVAS_HEIGHT, INV_PAINT, 
			v_grid_pr, 0, 0);

	/*  horizontal grid  */
	for (y = resolution - 1; y <= CANVAS_HEIGHT; y += resolution)
	    pw_write(canvas_pixwin, 0, y, CANVAS_WIDTH, 1, INV_PAINT, 
			h_grid_pr, 0, 0);
	}

redisplay_grid()
{
	if (cur_grid == -1) return;
	draw_grid(cur_grid);
	}

#else

#define null_width 32
#define null_height 32
static char null_bits[null_width * null_height / 8] = { 0 };

#define quarter_width 20
#define quarter_height 20
static char quarter_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x42, 0x08};

#define half_width 40
#define half_height 40
static char half_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x10, 0x42, 0x08, 0x21, 0x84};

static Pixmap	null_pm, quarter_pm, half_pm;

init_grid()
{
	long	bg, fg;
	Arg	tmp_arg[3];

	XtSetArg(tmp_arg[0], XtNbackground, &bg);
	XtSetArg(tmp_arg[1], XtNforeground, &fg);
	XtGetValues(canvas_sw, tmp_arg, 2);
	
	null_pm = XCreatePixmapFromBitmapData(tool_d, canvas_pixwin,
		null_bits, null_width, null_height,
		fg, bg,	DefaultDepthOfScreen(tool_s));
	quarter_pm = XCreatePixmapFromBitmapData(tool_d, canvas_pixwin,
		quarter_bits, quarter_width, quarter_height,
		fg, bg,	DefaultDepthOfScreen(tool_s));
	half_pm = XCreatePixmapFromBitmapData(tool_d, canvas_pixwin,
		half_bits, half_width, half_height,
		fg, bg,	DefaultDepthOfScreen(tool_s));
}

setup_grid(grid)
	int		grid;
{
	static Arg	grid_args[] =
	{
		{ XtNbackgroundPixmap, (XtArgVal)NULL },
	};

	if (grid == cur_grid)
	{
		grid_args[0].value = (XtArgVal)null_pm;
		grid = -1;
	}
	if (grid == F_GRID1)
		grid_args[0].value = (XtArgVal)quarter_pm;
	else if (grid == F_GRID2)
		grid_args[0].value = (XtArgVal)half_pm;
	cur_grid = grid;
	XtSetValues(canvas_sw, grid_args, XtNumber(grid_args));
}

redisplay_grid()
{
}
#endif	X11
