/* $Header: obj_box.c,v 1.2 88/08/19 00:00:51 moraes Exp $ */
/*
 *  The box object routines
 */
#include <strings.h>
#include <sys/types.h>
#include <stdio.h>

#include "xpic.h"
#include "windows.h"
#include "gels.h"
#include "draw.h"
#include "assert.h"

static int x1, y1, x2, y2;			/* Corners of box, ellipse, ends of line */
static int xmin, xmax, ymin, ymax;	/* Bounding box */

box_event(evtype, mx, my)
{
	switch(evtype) {
	case MOTION | START_MODE:
	case RIGHT  | START_MODE:
	case MIDDLE | START_MODE:
	case REDRAW | START_MODE:
	case RIGHT  | END_MODE:
		break;
	case MOTION | END_MODE:
		box(picWin, x1, y1, x2, y2, gcInvert);
		x2 = mx;
		y2 = my;
		box(picWin, x1, y1, x2, y2, gcInvert);
		break;
	case LEFT | START_MODE:
		x1 = x2 = mx;
		y1 = y2 = my;
		drawingMode = END_MODE;
		box(picWin, x1, y1, x2, y2, gcInvert);
		break;
	case LEFT | END_MODE:
		box(picWin, x1, y1, x2, y2, gcInvert);
		x2 = mx;
		y2 = my;
		xmin = MIN(x1, mx);
		xmax = MAX(x1, mx);
		ymin = MIN(y1, my);
		ymax = MAX(y1, my);
		box(picWin, x1, y1, x2, y2, gcNormal);
		AddBoxGel(&(CurrentCell->gelList), xmin, ymin, xmax, ymax,
		 line_type | fill_type, lineThickness);
		FreeGel(CurrentCell->undoList);
		CurrentCell->undoList = NULL;
		CurrentCell->undo = 1;
		CurrentCell->saved |= MODIFIED;
		drawingMode = START_MODE;
		break;
	case MIDDLE | END_MODE:
		box(picWin, x1, y1, x2, y2, gcInvert);
		drawingMode = START_MODE;
		break;
	case REDRAW | END_MODE:
		box(picWin, x1, y1, x2, y2, gcInvert);
		break;
	default:
#ifdef DEBUG
		sprintf(errstring, "Hey! Unknown BOX mode %d", drawingMode);
		message(errstring);
#endif
		break;
	}
	ASSERT(allock(), "box_event");
}


box_abort()
{
	box_event((MIDDLE | drawingMode), 0, 0);
}
	

box_adj(evtype, gel, mx, my)
int evtype;
Gel *gel;
int mx, my;
{
	static Gel *boxgel;
	/*
	 *  Will not need to process MOTION|START_MODE, RIGHT|START_MODE,
	 *  REDRAW|START_MODE - these are taken care of in
	 *  the adj_element routine.
	 */
	switch(evtype) {
	case MOTION | END_MODE:
		box(picWin, x1, y1, x2, y2, tmpGcInvert);
		x2 = mx;
		y2 = my;
		box(picWin, x1, y1, x2, y2, tmpGcInvert);
		break;
	case LEFT | START_MODE:
		GetBoxCorners(&x1, &y1, &x2, &y2, &gel->b_box, mx, my);
		boxgel = gel;
		drawingMode = END_MODE;
		setwidth(tmpGcNormal, boxgel->linewidth);
		setwidth(tmpGcInvert, boxgel->linewidth);
		SETDASHES(tmpGcNormal, getlinestyle(boxgel->attributes))
		SETDASHES(tmpGcInvert, getlinestyle(boxgel->attributes))
		box(picWin, x1, y1, x2, y2, tmpGcInvert);
		break;
	case LEFT | END_MODE:
		box(picWin, x1, y1, x2, y2, tmpGcInvert);
		x2 = mx;
		y2 = my;
		xmin = MIN(x1, mx);
		xmax = MAX(x1, mx);
		ymin = MIN(y1, my);
		ymax = MAX(y1, my);
		box(picWin, x1, y1, x2, y2, tmpGcNormal);
		AddBoxGel(&(CurrentCell->gelList), xmin, ymin, xmax, ymax,
		 boxgel->attributes, boxgel->linewidth);
		FreeGel(CurrentCell->undoList);
		CurrentCell->undoList = boxgel;
		boxgel = NULL;
		CurrentCell->undo = 1;
		CurrentCell->saved |= MODIFIED;
		drawingMode = START_MODE;
		break;
	case RIGHT | END_MODE:
	case MIDDLE | END_MODE:
		box(picWin, x1, y1, x2, y2, tmpGcInvert);
		GelDraw(boxgel, DRAW);
		PushUnderUndo(&(CurrentCell->gelList), boxgel, CurrentCell->undo);
		boxgel = NULL;
		if (evtype == (MIDDLE | END_MODE))
			ClearGelFlags(CurrentCell->gelList);
		drawingMode = START_MODE;
		break;
	case MIDDLE | START_MODE:
		ClearGelFlags(CurrentCell->gelList);
		break;
	case REDRAW | END_MODE:
		box(picWin, x1, y1, x2, y2, tmpGcInvert);
		break;
	default:
#ifdef DEBUG
		sprintf(errstring, "Hey! Unknown mode %d in box_adj", 
		 evtype);
		message(errstring);
#endif
		break;
	}
	ASSERT(allock(), "box_adj");
}
