/* $Header: util.c,v 1.3 88/08/31 23:45:52 moraes Exp $ */
/*
 *  Generally useful procedures
 */
/* This file contains code from the JOVE screen editor */

/************************************************************************
 * JOVE is Copyright (C) 1986 by Jonathan Payne.  JOVE is               *
 * provided to you without charge, and with no warranty.  You may give  *
 * away copies of JOVE, including sources, provided that this notice is *
 * included in all the files.                                           *
 ************************************************************************/

/*
 *  Modified by Mark Moraes for use in a widget for the X Windows System
 *  Version 11. This file is still independent of the X Windows System.
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/param.h>
#include <errno.h>
#include <pwd.h>
#ifdef XPIC
#include <X11/Xos.h>
#else
#include <strings.h>
#endif

/* This must be the path of the user's home directory */
extern char *homeDir;

char *StripName(name)
char *name;
{
	char *begin = rindex (name, '/');
	char *end, *result;
	int length;

	begin = (begin ? begin+1 : name);
	end = index (begin, '.');
	length = (end ? (end - begin) : strlen (begin));
	if ((result = (char *) malloc (length + 1)) == 0)
		return(0);
	strncpy (result, begin, length);
	result [length] = '\0';
	return (result);
}

/* Get a user's home directory */
get_hdir(user, buf)
register char	*user,
				*buf;
{
	struct passwd	*pw;

	/* Rewind the passwd file - we may have searched once already */
	(void) setpwent();
	if (((pw = getpwnam(user)) != NULL) && (pw->pw_dir != NULL)) {
			strcpy(buf, pw->pw_dir);
			return;
	}
}

/* Replace ~/ with homeDir/ and ~user/ with get_hdir/ */
PathParse(name, intobuf)
char	*name,
		*intobuf;
{
	intobuf[0] = '\0';
	if (*name == '\0')
		return;

	if (*name == '~') {
		if (name[1] == '/' || name[1] == '\0') {
			strcpy(intobuf, homeDir);
			name++;
		} else {
			char	*uendp = index(name, '/'),
					unamebuf[32];

			if (uendp == 0)
				uendp = name + strlen(name);
			name = name + 1;
			null_ncpy(unamebuf, name, uendp - name);
			get_hdir(unamebuf, intobuf);
			name = uendp;
		}
	} else if (*name == '\\')
		name++;
	(void) strcat(intobuf, name);
}

file_backup(fname, defaultmode)
char *fname;
u_short defaultmode;
{
	char	*s;
	register int	i;
	int	fd1,
		fd2;
	char	tmp1[BUFSIZ],
			tmp2[BUFSIZ];
	int	mode;
	
	strcpy(tmp1, fname);
	
	if ((s = rindex(tmp1, '/')) == NULL)
		sprintf(tmp2, "#%s~", fname);
	else {
		*s++ = '\0';
		sprintf(tmp2, "%s/#%s~", tmp1, s);
	}

	if ((fd1 = open(fname, 0)) < 0)
		return;

	if (defaultmode == 0)
		mode = 0666;
	else
		mode = defaultmode;
		
	if ((fd2 = creat(tmp2, mode)) < 0) {
		(void) close(fd1);
		return;
	}

	while ((i = read(fd1, tmp1, sizeof(tmp1))) > 0)
		write(fd2, tmp1, i);

	(void) fsync(fd2);	/* Write that file! */
	(void) close(fd2);
	(void) close(fd1);
}


null_ncpy(to, from, n)
char	*to,
		*from;
{
	(void) strncpy(to, from, n);
	to[n] = '\0';
}

