.TH RCMD X
.SH NAME
rcmd - run a remote command in the background, without stdout and stderr.
.SH SYNOPSIS
.B rcmd
remotehost command
.SH DESCRIPTION
.I Rcmd
runs the given 
.I command 
on the specified
.I remotehost
via 
.I rsh
but by redirecting stdout and stderr to /dev/null, and running command
in the background, it results in the rsh exiting and closing the
connection, leaving the command as a daemon on the remote machine.
This is useful only for commands that have no use for stdout and
stderr like most X Windows applications.
.SH EXAMPLE
.nf
rcmd godzilla /local/bin/X11/xterm -display ${HOST}:0 -geometry 80x50+3-3 -ls
.fi
.sp
will run xterm on the remote machine 
.I godzilla
with the display on the current HOST (assuming the environment variable 
HOST is set to `hostname`).
.SH BUGS
The remote command has no way of notifying the user about error
conditions, except through logs.
