# include <X11/Intrinsic.h>
# include <X11/StringDefs.h>
# include <X11/Command.h>
# include <X11/Form.h>
# include <stdio.h>

# include "globs.h"
# include "layo.h"

static Arg		quit_form_args[] = {
	{ XtNborderWidth,	(XtArgVal) 0 },
	{ XtNresizable,		(XtArgVal) TRUE }
};

void
quit_button_setup(name, ly, top_shell)
	char		*name;
	layoptr		ly;
	Widget		top_shell;
{
	extern void	quit_proc();
	extern void	revert_proc();
	Widget		quit_form;
	Widget		quit_button;
	Widget		revert_button;
	Arg		arg;

	quit_form = XtCreateManagedWidget("quitForm", formWidgetClass,
					  ly->ly_parent,
					  (ArgList) quit_form_args,
					  XtNumber(quit_form_args));

	if (ly->ly_horiz != (Widget) NULL) {
		XtSetArg(arg, XtNfromHoriz, ly->ly_horiz);
		XtSetValues(quit_form, &arg, 1);
	}
	if (ly->ly_vert != (Widget) NULL) {
		XtSetArg(arg, XtNfromVert, ly->ly_vert);
		XtSetValues(quit_form, &arg, 1);
	}

	XtSetArg(arg, XtNvertDistance, 0);
	XtSetValues(quit_form, &arg, 1);
	XtSetArg(arg, XtNhorizDistance, 0);
	XtSetValues(quit_form, &arg, 1);

	add_form(quit_form);

	quit_button = XtCreateManagedWidget("quitButton", commandWidgetClass,
					    quit_form, (ArgList) NULL, 0);

	XtAddCallback(quit_button, XtNcallback, quit_proc,
		      (caddr_t) top_shell);
	XtSetArg(arg, XtNlabel, name);
	XtSetValues(quit_button, &arg, 1);

	revert_button = XtCreateManagedWidget("revertButton",
					      commandWidgetClass,
					      quit_form, (ArgList) NULL, 0);

	XtAddCallback(revert_button, XtNcallback, revert_proc,
		      (caddr_t) top_shell);
	XtSetArg(arg, XtNlabel, "revert");
	XtSetValues(revert_button, &arg, 1);
	XtSetArg(arg, XtNfromHoriz, quit_button);
	XtSetValues(revert_button, &arg, 1);

	XtSetSensitive(revert_button, False);	/* no reverting yet */

	ly->ly_vert = quit_button;
	ly->ly_parent = quit_form;
}

static void
quit_proc(w, client_data, call_data)
	Widget		w;
	caddr_t		client_data;
	caddr_t		call_data;
{
	XtDestroyWidget((Widget) client_data);
	exit(0);
}

static void
revert_proc(w, client_data, call_data)
	Widget		w;
	caddr_t		client_data;
	caddr_t		call_data;
{
	return;
}
