# include <X11/Intrinsic.h>
# include <stdio.h>

# include "globs.h"
# include "xget.h"

int
get_click() {
	XKeyboardState	state;

	XGetKeyboardControl(dpy, &state);

	return(state.key_click_percent);
}

int
get_repeat() {
	XKeyboardState	state;

	XGetKeyboardControl(dpy, &state);

	return(state.global_auto_repeat);
}

int
get_bell_vol() {
	XKeyboardState	state;

	XGetKeyboardControl(dpy, &state);

	return(state.bell_percent);
}

unsigned int
get_bell_pitch() {
	XKeyboardState	state;

	XGetKeyboardControl(dpy, &state);

	return(state.bell_pitch);
}

unsigned int
get_bell_dur() {
	XKeyboardState	state;

	XGetKeyboardControl(dpy, &state);

	return(state.bell_duration);
}

int
get_mouse_num() {
	int	acc_num;
	int	dummy;

	XGetPointerControl(dpy, &acc_num, &dummy, &dummy);

	return(acc_num);
}

int
get_mouse_denom() {
	int	acc_denom;
	int	dummy;

	XGetPointerControl(dpy, &dummy, &acc_denom, &dummy);

	return(acc_denom);
}

int
get_mouse_thresh() {
	int	thresh;
	int	dummy;

	XGetPointerControl(dpy, &dummy, &dummy, &thresh);

	return(thresh);
}

int
get_screen_blank(value)
	int	value;
{
	int timo, interval, blank, expose;

	XGetScreenSaver(dpy, &timo, &interval, &blank, &expose);
	return(blank);
}

int
get_screen_expose(value)
	int	value;
{
	int timo, interval, blank, expose;

	XGetScreenSaver(dpy, &timo, &interval, &blank, &expose);
	return(expose);
}

int
get_screen_timo(value)
	int	value;
{
	int timo, interval, blank, expose;

	XGetScreenSaver(dpy, &timo, &interval, &blank, &expose);
	return(timo);
}

int
get_screen_cycle(value)
	int	value;
{
	int timo, interval, blank, expose;

	XGetScreenSaver(dpy, &timo, &interval, &blank, &expose);
	return(interval);
}
