/*
 *  A slight variation on Dave Rosenthal's Hello World program. See his
 *  paper in Usenix Winter 87 for more info. - Mark Moraes.
 */
#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Command.h>

static char *string;
static void click();

XtCallbackRec callbacks[] = {
    {click, NULL},
    {NULL, NULL},
}; 

Arg wargs[] = {
    XtNlabel,	(XtArgVal) NULL,
    XtNcallback, (XtArgVal) callbacks,
};

/* ARGSUSED */
static void click(w, clientdata, calldata)
Widget w;
caddr_t clientdata;
caddr_t calldata;
{
    exit(0);
}


main(argc, argv)
    int argc;
    char **argv;
{
    Widget      toplevel;

    /*
     *  Create the Widget that represents the window.
     */
    toplevel = XtInitialize(argv[0], "XString", NULL, 0, &argc, argv);

    if (argc < 2) {
    	(void) fprintf(stderr, "Usage: %s [Xt options] string\n", argv[0]);
	exit(-1);
    } else {
    	int i, len;
	char **cp;
	for(len = 0, i = 1, cp = &argv[1]; i < argc; i++, cp++)
		len += strlen(*cp) + 1;
	string = XtMalloc(len + 1);
	for(i = 1, cp = &argv[1]; i < argc; i++, cp++) {
		(void) strcat(string, *cp);
		(void) strcat(string, " ");
	}
    	XtSetArg(wargs[0], XtNlabel, string);
    }

    /*
     *  Create a Command button Widget to display the string, using
     *  wargs to set the string as its value. The callback will ensure
     *  it goes away when the button is clicked.
     */
    (void) XtCreateManagedWidget(argv[0], commandWidgetClass,
			   toplevel, wargs, XtNumber(wargs));

    /*
     *  Create the windows, and set their attributes according
     *  to the Widget data.
     */
    XtRealizeWidget(toplevel);

    /*
     *  Now process the events.
     */
    XtMainLoop();
}
