# include <X11/Intrinsic.h>
# include <X11/StringDefs.h>
# include <X11/Command.h>
# include <X11/Form.h>
# include <stdio.h>

# include "home_globs.h"

static char label_text[] = "xtools";

static Arg label_args[] = {
	{ XtNlabel,		(XtArgVal) label_text },
	{ XtNborderWidth,	(XtArgVal) 0 },
};

static int label_args_n = XtNumber(label_args);

Widget		quit_button;

Widget
home_setup(parent)
	Widget		parent;
{
	Widget		home_form;
	Widget		label_widget;
	Widget		help_button;
	Arg		args[1];

	home_form = XtCreateWidget("home", formWidgetClass, parent,
				   NULL, 0);

	label_widget = XtCreateManagedWidget("home", labelWidgetClass,
					     home_form, label_args,
					     label_args_n);

	quit_button = XtCreateManagedWidget("quit", commandWidgetClass,
					    home_form, quit_button_args,
					    quit_button_args_n);
	XtSetArg(args[0], XtNfromVert, label_widget);
	XtSetValues(quit_button, args, 1);
	XtAddCallback(quit_button, XtNcallback, quit_func,
		      (caddr_t) home_form);

	help_button = XtCreateManagedWidget("help", commandWidgetClass,
					    home_form, help_button_args,
					    help_button_args_n);
	XtSetArg(args[0], XtNfromHoriz, quit_button);
	XtSetValues(help_button, args, 1);
	XtSetArg(args[0], XtNfromVert, label_widget);
	XtSetValues(help_button, args, 1);
	XtAddCallback(help_button, XtNcallback, help_func,
		      (caddr_t) home_form);

	return(home_form);
}
