# include <X11/Intrinsic.h>
# include <X11/StringDefs.h>
# include <X11/Command.h>
# include <X11/Shell.h>
# include <X11/Form.h>
# include <stdio.h>

# include "home_globs.h"
# include "globs.h"

# include "xtools.xbm"

String			display_name;
static Widget		top_shell;

static XrmOptionDescRec options[] = {
	{ "-file",	"file",		XrmoptionSepArg,	NULL },
	{ "-debug",	"debug",	XrmoptionIsArg,		"False" },
};

static XtResource	resources[] = {
	{ "file", "file", XtRString, sizeof(char *), (Cardinal) &file,
		  XtRString, NULL },
	{ "debug", "debug", XtRBoolean, sizeof(Boolean), (Cardinal) &debug,
		  XtRBoolean, 0 },
};

Widget
top_setup(argc, argv)
	int		argc;
	char		**argv;
{
	Widget		top_form;
	Arg		args[1];

	top_shell = XtInitialize("top", "XTools", options,
				 XtNumber(options), &argc, argv );
	if (argc != 1)
		usage();

	XtGetApplicationResources(top_shell, (caddr_t) NULL, resources,
				  XtNumber(resources), NULL, 0);

	XtSetArg(args[0], XtNiconPixmap,
		 XCreateBitmapFromData(XtDisplay(top_shell),
				       XtScreen(top_shell)->root,
				       xtools_bits, xtools_width,
				       xtools_height));
	XtSetValues(top_shell, args, 1);

	XtSetArg(args[0], XtNallowShellResize, True);
	XtSetValues(top_shell, args, 1);

# ifdef use_popup
	top_form = top_shell;
# else /* use_popup */
	top_form = XtCreateManagedWidget("top", formWidgetClass, top_shell,
				  NULL, 0);

	XtSetArg(args[0], XtNallowShellResize, True);
	XtSetValues(top_form, args, 1);
# endif /* use_popup */

	display_name = XDisplayString(XtDisplay(top_shell));

	return(top_form);
}

void
top_start(home_form)
	Widget		home_form;
{
	XtManageChild(home_form);
	XtRealizeWidget(top_shell);
}
