/* 
 * PGLTrans.c - Handle global and local transform requests
 * 
 * Copyright 1988
 * Center for Information Technology Integration (CITI)
 * Information Technology Division
 * University of Michigan
 * Ann Arbor, Michigan
 *
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby
 * granted, provided that the above copyright notice appear in all
 * copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the names of
 * CITI or THE UNIVERSITY OF MICHIGAN not be used in advertising or
 * publicity pertaining to distribution of the software without
 * specific, written prior permission.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS." CITI AND THE UNIVERSITY OF
 * MICHIGAN DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN
 * NO EVENT SHALL CITI OR THE UNIVERSITY OF MICHIGAN BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

#include "pexDICE.h"

PexGlobalTransform (pexi, matrix)
    register pexC *pexi;
    pexMatrix matrix;
{
    register Display *dpy = pexi->phigsDisplay;
    register pexRenderOutputCommandsReq *req;
    pexGlobalTransform oc;
    int one_shot = 0;

    if( ( req = pexi->curRenderOut ) == 0 )
    {
	PexRenderOutputCommands(pexi);
	one_shot++;
	req = pexi->curRenderOut;
    }

    oc.head.elementType = OCGlobalTransform;
    oc.head.length = sizeof (pexGlobalTransform)>>2;
    bcopy ((char *)matrix, (char *)oc.matrix, sizeof (pexMatrix));

    req->numCommands++;

    pexPackData (pexi, (char *)(&oc), sizeof(pexGlobalTransform));
    req->length	+= sizeof (pexGlobalTransform)>>2;

    if ( one_shot )
	PexEndRendComm(pexi);
}



PexLocalTransform (pexi, compType, matrix)
    register pexC *pexi;
    pexComposition compType;
    pexMatrix matrix;
{
    register Display *dpy = pexi->phigsDisplay;
    register pexRenderOutputCommandsReq *req;
    pexLocalTransform oc;
    int one_shot = 0;

    if( ( req = pexi->curRenderOut ) == 0 )
    {
	PexRenderOutputCommands(pexi);
	one_shot++;
	req = pexi->curRenderOut;
    }

    oc.head.elementType = OCLocalTransform;
    oc.head.length = sizeof (pexLocalTransform)>>2;
    oc.compType = compType;
    bcopy ((char *)matrix, (char *)oc.matrix, sizeof (pexMatrix));

    req->numCommands++;

    pexPackData (pexi, (char *)(&oc), sizeof(pexLocalTransform));
    req->length	+= sizeof (pexLocalTransform)>>2;

    if ( one_shot )
	PexEndRendComm(pexi);
}
