/* 
 * PText.c - Handle annotated text requests
 * 
 * Copyright 1988
 * Center for Information Technology Integration (CITI)
 * Information Technology Division
 * University of Michigan
 * Ann Arbor, Michigan
 *
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby
 * granted, provided that the above copyright notice appear in all
 * copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the names of
 * CITI or THE UNIVERSITY OF MICHIGAN not be used in advertising or
 * publicity pertaining to distribution of the software without
 * specific, written prior permission.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS." CITI AND THE UNIVERSITY OF
 * MICHIGAN DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN
 * NO EVENT SHALL CITI OR THE UNIVERSITY OF MICHIGAN BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

#include "pexDICE.h"

PexAnnoText( pexi, text, origin, offset )
    register pexC *pexi;
    char *text;
    pexCoord3D *origin, *offset;
{
    register Display *dpy = pexi->phigsDisplay;
    register pexRenderOutputCommandsReq *req;
    CARD16 textlen;
    pexAnnotationText oc;
    long nbytes;
    register CARD16 nwords;
    int one_shot = 0;

    if( ( req = pexi->curRenderOut ) == 0 )
    {
	PexRenderOutputCommands(pexi);
	one_shot++;
	req = pexi->curRenderOut;
    }

    textlen = strlen (text);
    nwords = (sizeof (pexAnnotationText) + textlen + 3)>>2;
    nbytes = nwords << 2;

    oc.head.elementType = OCAnnotationText;
    oc.head.length = nwords;		    /* round nbytes up to 4 */
    oc.origin = *origin;
    oc.offset = *offset;
    oc.string.length = textlen;

    req->numCommands++;

    pexPackData( pexi, (char *)(&oc), sizeof(pexAnnotationText) );
    pexPackData( pexi, text, nbytes - sizeof(pexAnnotationText) );
    req->length	+= nwords;

    if ( one_shot )
	PexEndRendComm(pexi);
}
