/* 
 * p2tst.c - A test client program
 * 
 * Copyright 1988
 * Center for Information Technology Integration (CITI)
 * Information Technology Division
 * University of Michigan
 * Ann Arbor, Michigan
 *
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby
 * granted, provided that the above copyright notice appear in all
 * copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the names of
 * CITI or THE UNIVERSITY OF MICHIGAN not be used in advertising or
 * publicity pertaining to distribution of the software without
 * specific, written prior permission.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS." CITI AND THE UNIVERSITY OF
 * MICHIGAN DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN
 * NO EVENT SHALL CITI OR THE UNIVERSITY OF MICHIGAN BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

#include <stdio.h>
#include "X11/Xlib.h"
#include "X11/Xatom.h"
#include "PEXprotostr.h"
#include "PEXcolors.h"
#include <errno.h>
#include "phigs.h"

extern int errno;

#include "pexDICE.h"

extern int pexfg;
extern int redisp;

pexCoord3D vertices[12] = {
{	 0.00000,	 0.00000,	-1.11803    },
{	 .309017,	 .951057,	-.500000    },
{	-.809017,	 .587785,	-.500000    },
{	-.809017,	-.587785,	-.500000    },
{	 .309017,	-.951057,	-.500000    },
{	 1.00000,	 0.00000,	-.500000    },
{	-1.00000,	 0.00000,	 .500000    },
{	-.309017,	 .951057,	 .500000    },
{	 .809017,	 .587785,	 .500000    },
{	 .809017,	-.587785,	 .500000    },
{	-.309017,	-.951057,	 .500000    },
{	 0.00000,	 0.00000,	 1.11803    }
};

int polys[12][5] = {
{	    2,    3,    4,    5,   6,  },
{	    7,    8,    9,   10,  11,  },
{	    1,    6,    9,    8,   3,  },
{	   12,   10,    5,    4,   7,  },
{	    1,    2,    8,    7,   4,  },
{	   12,    9,    6,    5,  11,  },
{	    1,    3,    7,   11,   5,  },
{	   12,    8,    2,    6,  10,  },
{	    1,    4,   11,   10,   6,  },
{	   12,    7,    3,    2,   9,  },
{	    1,    5,   10,    9,   2,  },
{	   12,   11,    4,    3,   8,  }
};    

pexCoord3D polylines[12][6];

makeData()
{
    int i, j;

    for ( i = 0; i < 12; i++ )
    {
	for ( j = 0; j < 5; j++ )
	    polylines[i][j] = vertices[polys[i][j] - 1];
	polylines[i][5] = polylines[i][0];
    }
}

	/* Global Phigs variables */
Pint		error;		/* error indicator	*/
Ppoint3		vrp;		/* view reference point	*/
Pvector3	vpn, nvpn;	/* view plane normal	*/
Pvector3	vup;		/* view up vector	*/
Pviewrep3 	viewrep;	/* Phigs view representation */

Pmatrix3
    rotx, roty, rotz; /* y rotation matrix	*/
pexC *pexi = NULL;

void DrawTheThing()
{
    int i;

    redisp = 0;
    
    /* Begin the PEX rendering */
    
    PexBeginRendering(pexi);
    
    /* Draw the cube */
    PexRenderOutputCommands(pexi); 
    
    for ( i = 0; i < 6; i++ )
	PexFillAreaWithData(pexi, 0, 0, 0, 5, polylines[i], 0, 0, 0, 0);
    
    PexEndRendComm(pexi);
    
    /* End the PEX rendering */
    PexEndRendering(pexi);
    
    XFlush(pexi->phigsDisplay);
};

PexFormInit(dpy, window, argc, argv)
Display *dpy;
Window  window;
char **argv;
{
    XEvent pe;
    XExposeEvent *ee;
    
    Pviewmapping3 map;		/* view mapping structure */

    pexi = popenphigs(dpy, window, argc, argv);
    popenws(pexi, 0, 0, 0);
    
    /* Set up the PHIGS view */
    vrp.x = 0.0; vrp.y = 0.0; vrp.z = 0.0;
    vpn.x = 1.0; vpn.y = 2.0; vpn.z = 3.0;
    vup.x = 0.0; vup.y = 1.0; vup.z = 0.0;
    
    pevalvieworientationmatrix3(&vrp, &vpn, &vup, 
				&error, viewrep.orientation_matrix);
    
    map.window.xmin = -1.5;	map.window.ymin = -1.5;
    map.window.xmax =  1.5;	map.window.ymax =  1.5;
    map.view_plane = 1.5;
    map.back_plane = -3.0;
    map.front_plane = 3.0;
    
    map.viewport.xmin= 0.0; map.viewport.ymin= 0.0; map.viewport.zmin= -1.0;
    map.viewport.xmax= 1.0; map.viewport.ymax= 1.0; map.viewport.zmax= 0.0;
    map.prp.x = 0.0; map.prp.y = 0.0; map.prp.z = 20.0;
    map.proj = PPERSPECTIVE; 
    
    pevalviewmappingmatrix3(&map, &error, viewrep.mapping_matrix);
    
    viewrep.clip_xy = PCLIP;
    viewrep.clip_back = PCLIP;
    viewrep.clip_front = PCLIP;
    viewrep.clip_limit.xmin = map.viewport.xmin;
    viewrep.clip_limit.xmax = map.viewport.xmax;
    viewrep.clip_limit.ymin = map.viewport.ymin;
    viewrep.clip_limit.ymax = map.viewport.ymax;
    viewrep.clip_limit.zmin = map.viewport.zmin;
    viewrep.clip_limit.zmax = map.viewport.zmax;
    
    psetviewrep3(pexi, 1, &viewrep );
    psetviewind(pexi, 1);
    
    makeData();

    SetPexSurfaceFlags(pexi);
    PexSurfaceColorIndex(pexi, pexMagenta);

    DrawTheThing();
}


void rotatex(incx)
float incx;
{
    /* Set up a new PHIGS view */

    protatex( incx, &error, rotx );
    PexLocalTransform(pexi, PostConcatenate, rotx);
    
    if ( redisp++ > 5 )
	DrawTheThing();
}

void rotatey(incy)
float incy;
{
    /* Set up a new PHIGS view */
    protatey( incy, &error, roty );
    PexLocalTransform(pexi, PostConcatenate, roty);

    if ( redisp++ > 5 )
	DrawTheThing();
}

void rotatez(incz)
float incz;
{
    /* Set up a new PHIGS view */

    protatez( incz, &error, rotz );
    PexLocalTransform(pexi, PostConcatenate, rotz);

    if ( redisp++ > 5 )
	DrawTheThing();
}


void translatex(incx)
float incx;
{
    /* set up a new PHIGS view */
    vrp.x -= 3.0 * incx;
    pevalvieworientationmatrix3(&vrp, &vpn, &vup, 
				&error, viewrep.orientation_matrix);
    
    psetviewrep3( pexi, 1, &viewrep );
    if ( redisp++ > 5 )
	DrawTheThing();
}

void translatey(incy)
float incy;
{
    /* set up a new PHIGS view */
    vrp.y -= 3.0 * incy;
    pevalvieworientationmatrix3(&vrp, &vpn, &vup, 
				&error, viewrep.orientation_matrix);
    
    psetviewrep3( pexi, 1, &viewrep );
    if ( redisp++ > 5 )
	DrawTheThing();
}

    


void translatez(incz)
float incz;
{
    /* set up a new PHIGS view */
    vrp.z -= 3.0 * incz;
    pevalvieworientationmatrix3(&vrp, &vpn, &vup, 
				&error, viewrep.orientation_matrix);
    
    psetviewrep3( pexi, 1, &viewrep );
    if ( redisp++ > 5 )
	DrawTheThing();
}

