/*
Copyright 1987 by Digital Equipment Corporation, Maynard, Massachusetts,

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the name of Digital not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
*/
/*
 *
 * LIGHT_EXAMPLE.C
 *
 *	This was an example program for the VAXstation 8000 workstation.
 *	It demonstrated the use of SGR routines to create a shaded
 *	object with different surface properties and specularity.
 *	But we stole the sphere generating code to use as a test program for
 *	PEX!  We like the recursive generation of a sphere with normals.
 *	
 * HISTORY:
 *
 *	xx-XXX-1987	Created by Doug Kraft
 *	19-Jan-1988	Peter N. Alduino  add header, print out explanation of
 *					what this program does.
 *	25-Jan-1988	PNA	add copyright header.
 *	Sometime in July 1988  CPJ kluged and killed code to get it to send
 *				PEX! 
 */


/* 
 * sphere_pgm.c - A test client program
 * 
 * Copyright 1988
 * Center for Information Technology Integration (CITI)
 * Information Technology Division
 * University of Michigan
 * Ann Arbor, Michigan
 *
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby
 * granted, provided that the above copyright notice appear in all
 * copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the names of
 * CITI or THE UNIVERSITY OF MICHIGAN not be used in advertising or
 * publicity pertaining to distribution of the software without
 * specific, written prior permission.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS." CITI AND THE UNIVERSITY OF
 * MICHIGAN DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN
 * NO EVENT SHALL CITI OR THE UNIVERSITY OF MICHIGAN BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

#include <stdio.h>
#include "PEXcolors.h"

#include "pexDICE.h"

#include "Xlib.h"
#include "Xutil.h"
extern int errno;

#define RAD(x) ((x) * 0.0174533)     /* convert degrees to radians */
#define DEGREE(x) ((x) * 57.2958)    /* convert radians to degrees */
#define TRANSLATION_FACTOR  0.002
#define SCALE_FACTOR	    0.005
#define	ROTATION_FACTOR     (RAD(1.0))
#define MAX_C 65535.0		     /* max value for x color 	   */

typedef int	Handle;
typedef struct {
	unsigned	status;
	float		x, y, z, w;
	unsigned	nstatus;
	float		nx, ny, nz, nw;
	} Vector;

static int 	MainWindow, SubWindow2d;
static Display *display;
static int 	context;
static Handle	handle;
static Handle	h_root;
static Handle	h_rotation, h_scale, h_translation;
static Handle	h_perspective;
static float	translation_vector[3] = {0.0, 0.0, 0.0};
static float	scale_vector[3] = {0.4, 0.4, 0.4};
static float	rotation_matrix[4][4];

static float	matrix[4][4];
static float	normal_matrix[4][4];

static XEvent	Event;

static Colormap color_map8;
static GC	light_gc, dark_gc;
#define		DARK_COLOR 0
#define		LIGHT_COLOR 1


main(argc, argv)
    int argc;
    char *argv[];
{
    XEvent pe;
    XExposeEvent *ee;
    XConfigureEvent *ce;
    
    /* Phigs variables */
    Ppoint3 vrp;		/* view reference point	*/
    Pvector3 vpn, nvpn;		/* view plane normal	*/
    Pvector3 vup;		/* view up vector	*/
    Pint error;			/* error indicator	*/
    Pmatrix3 roty;		/* y rotation matrix	*/
    Pviewmapping3 map;		/* view mapping structure */
    Pviewrep3 viewrep;		/* Phigs view representation */
    
    pexC *pexi;
    
    smoothflag = 1;
    solidflag = 1;
    
    pexi = popenphigs(0, 0, argc, argv);
    popenws(pexi, 0, 0, 0);
    
    /* Set up the PHIGS view */
    vrp.x = 0.0; vrp.y = 0.0; vrp.z = 0.0;
    vpn.x = 1.0; vpn.y = 2.0; vpn.z = 3.0;
    vpn.x = 0.0; vpn.y = 0.0; vpn.z = 1.0;
    vup.x = 0.0; vup.y = 1.0; vup.z = 0.0;
    
    pevalvieworientationmatrix3(&vrp, &vpn, &vup, 
		&error, viewrep.orientation_matrix);
    
    map.window.xmin = -2.0;	map.window.ymin = -2.0;
    map.window.xmax =  2.0;	map.window.ymax =  2.0;
    map.view_plane = 2.0;
    map.back_plane = -4.0;
    map.front_plane = 4.0;
    
    map.viewport.xmin= 0.0; map.viewport.ymin= 0.0; map.viewport.zmin= -1.0;
    map.viewport.xmax= 1.0; map.viewport.ymax= 1.0; map.viewport.zmax= 0.0;
    map.prp.x = 0.0; map.prp.y = 0.0; map.prp.z = 20.0;
    map.proj = PPERSPECTIVE; 
    
    pevalviewmappingmatrix3(&map, &error, viewrep.mapping_matrix);
    
    viewrep.clip_xy = PCLIP;
    viewrep.clip_back = PCLIP;
    viewrep.clip_front = PCLIP;
    viewrep.clip_limit.xmin = map.viewport.xmin;
    viewrep.clip_limit.xmax = map.viewport.xmax;
    viewrep.clip_limit.ymin = map.viewport.ymin;
    viewrep.clip_limit.ymax = map.viewport.ymax;
    viewrep.clip_limit.zmin = map.viewport.zmin;
    viewrep.clip_limit.zmax = map.viewport.zmax;
    
    psetviewind(pexi, 1);
    psetviewrep3(pexi, 1, &viewrep );
    
    protatey(10.0 * 3.1415 / 180.0, &error, roty);

    SetPexSurfaceFlags(pexi);
    PexLineColorIndex(pexi, pexYellow); 
    PexSurfaceColorIndex(pexi, pexMagenta);
    
    while(1)
    {
	
	/* this should get first exposure event */    
        XNextEvent(pexi->phigsDisplay, &pe);
	
        switch (pe.type)
	{
	case Expose:
	    ee = (XExposeEvent *) &pe;
	    while (ee->count)
	    {
		XNextEvent(pexi->phigsDisplay, &pe);       
                ee = (XExposeEvent *) &pe;
            }
	    
	case ConfigureNotify:
	    ce = (XConfigureEvent *) &pe;
            pexi->winx = ce->x;
            pexi->winy = ce->y;
            pexi->winw = ce->width;
            pexi->winh = ce->height;
	    break;
	}
	   
        while (! XPending(pexi->phigsDisplay))
        {
	    /* Begin the PEX rendering */
	    PexBeginRendering(pexi);
	    
	    /* Draw the sphere */
	    PexRenderOutputCommands(pexi);

	    sphere(2,pexi);

	    PexEndRendComm(pexi);
	    
	    /* End the PEX rendering */
	    PexEndRendering(pexi);
	    
	    /* Flush X and wait a bit. */
	    XFlush(pexi->phigsDisplay);
	    XSync(pexi->phigsDisplay);

	    PexLocalTransform(pexi, PostConcatenate, roty);
        }
    }
}



/*
 *  Creates "spheres".
 *
 *  The spheres are created with icosohedrons placed inside the
 *  sphere with the vertices of the icosohedron touching the surface
 *  of the sphere.
 *
 *  An icosohedron is an object with 20 faces, each face being an
 *  equilateral triangle. The frequency of the icosohedron tells how
 *  many segments each edge of the object is divided into. For
 *  example, in a 2 frequency icosohedron, each edge is divided into
 *  2 segments. The end of each segment is then "pushed" out to the
 *  surface of the sphere. The ends of the segments are then connected
 *  to form new a triangle. Each face of the original icosohedron is
 *  divided into 4 subtriangles. The resulting object is thus a closer
 *  approximation to a sphere.
 *
 *  A 4 frequency icosohedron has each edge divided into 4 segments
 *  resulting in 16 subtriangles for each origianal face or a total
 *  of 320 faces.
 *
 *  Etc.
 *
 *
 *  The 12 points of the original icosohedron are statically declared. 
 *  The points consist of a "north pole"  and "south pole", 5 points in 
 *  the middle of the northern hemisphere, and 5 in the southern.
 *
 *  A one frequency icosohedron is made by using these points directly.
 *
 *  Each higher frequency is made by taking each of the 20 faces in turn and
 *  calculating and displaying the subtriangles.
 *
 *  The "type" parameter gives the number of levels or recursion. A
 *  type 0 results in a 1 frequency icosohedron, a type 1 = 2 frequency,
 *  type 3 = 4 frequency, type 4 = 8 frequency, type 5 = 16 frequency, 
 *  type 6 = 32 frequency, etc. An arbitrary but high limit is set at
 *  type 10 (512 frequency)
 */
sphere(type,pexi)
int	type;	
    pexC *pexi;
{
static float north_pole[3] =  { 0.0,          1.0,          0.0	 	 };
static float north_mid_1[3] = { -.8502257312, 0.4474898274, 0.2762550862 };
static float north_mid_2[3] = { 0.0,          0.4474898274, 0.8939802384 };
static float north_mid_3[3] = { 0.8502257312, 0.4474898274, 0.2762550862 };
static float north_mid_4[3] = { 0.5254684000, 0.4474898274, -.7232452054 };
static float north_mid_5[3] = { -.5254684000, 0.4474898274, -.7232452054 };
static float south_mid_1[3] = { -.8502257312, -.4474898274, -.2762550862 };
static float south_mid_2[3] = { -.5254684000, -.4474898274, 0.7232452054 };
static float south_mid_3[3] = { 0.5254684000, -.4474898274, 0.7232452054 };
static float south_mid_4[3] = { 0.8502257312, -.4474898274, -.2762550862 };
static float south_mid_5[3] = { 0.0,          -.4474898274, -.8939802384 };
static float south_pole[3] =  { 0.0,         -1.0,          0.0	  	 };
unsigned 	style;


		/* north cap  */
		sphere_side(type,pexi, north_pole, north_mid_1, north_mid_2);
		sphere_side(type,pexi, north_pole, north_mid_2, north_mid_3);
		sphere_side(type,pexi, north_pole, north_mid_3, north_mid_4);
		sphere_side(type,pexi, north_pole, north_mid_4, north_mid_5);
		sphere_side(type,pexi, north_pole, north_mid_5, north_mid_1);
	
		/* mid section */
/*		sphere_side(type,pexi, north_mid_1, south_mid_1, south_mid_2);
		sphere_side(type,pexi, north_mid_2, south_mid_2, south_mid_3);
		sphere_side(type,pexi, north_mid_3, south_mid_3, south_mid_4);
		sphere_side(type,pexi, north_mid_4, south_mid_4, south_mid_5); */
		sphere_side(type,pexi, north_mid_5, south_mid_5, south_mid_1);
	
		sphere_side(type,pexi, south_mid_1, north_mid_1, north_mid_5);
/*		sphere_side(type,pexi, south_mid_2, north_mid_2, north_mid_1); */
		sphere_side(type,pexi, south_mid_3, north_mid_3, north_mid_2);
/*		sphere_side(type,pexi, south_mid_4, north_mid_4, north_mid_3); */
		sphere_side(type,pexi, south_mid_5, north_mid_5, north_mid_4);

		/* south cap */

/*		sphere_side(type,pexi, south_mid_1, south_pole, south_mid_2);
		sphere_side(type,pexi, south_mid_2, south_pole, south_mid_3);
		sphere_side(type,pexi, south_mid_3, south_pole, south_mid_4);
		sphere_side(type,pexi, south_mid_4, south_pole, south_mid_5);
		sphere_side(type,pexi, south_mid_5, south_pole, south_mid_1);
*/
	return(handle);
}


/*
 * If this is the last level of recursion, this routine calls the triangle
 * creation routine. Otherwise, it calculates the 4 sub triangles 
 * and calls itself with one less level of recursion.
 */
sphere_side(recursion,pexi, first, second, third)
int	recursion;		/* level of recursion	*/
    pexC *pexi;
float 	first[3];		/* top point */
float 	second[3];		/* lower right point */
float 	third[3];		/* lower left point */

{
float	mid1[3], mid2[3], mid3[3];

	if(recursion == 0)
	{
		make_triangle(pexi,first, second, third);
		return(1);
	}

	/* calculate midpoints		*/
	midpoint(first, second, mid1);
	midpoint(second, third, mid2);
	midpoint(third, first, mid3);

	/* middle triangle		 */
	sphere_side(recursion - 1,pexi, mid1, mid2, mid3);

	/* top triangle			 */
	sphere_side(recursion - 1,pexi, first, mid1, mid3);

	/* bottom right triangle	 */
	sphere_side(recursion - 1,pexi, mid1, second, mid2);

	/* bottom left triangle		 */
	sphere_side(recursion - 1,pexi, mid3, mid2, third);

}

/*
 * Create the actual polygons for the sphere.
 */
make_triangle(pexi,first, second, third)
    pexC *pexi;
float	first[3], second[3], third[3];
{
float	unit[3];
unsigned flags;
Handle	handle;
unsigned num_of_vectors, negate;
float	plane_equation[4];
Vector 	vectors[3];
pexCoord3D vertices[3];
pexCoord3D normals[3];
int i,j;

	vectors[0].x = first[0];
	vectors[0].y = first[1];
	vectors[0].z = first[2];
	vectors[0].w = 1.0;

	unit[0] = first[0];
	unit[1] = first[1];
	unit[2] = first[2];
	unitlength(display, context, unit);

	vectors[0].nx = unit[0];
	vectors[0].ny = unit[1];
	vectors[0].nz = unit[2];
	vectors[0].nw = 1.0;


	vectors[1].x = second[0];
	vectors[1].y = second[1];
	vectors[1].z = second[2];
	vectors[1].w = 1.0;

	unit[0] = second[0];
	unit[1] = second[1];
	unit[2] = second[2];
	unitlength(display, context, unit);

	vectors[1].nx = unit[0];
	vectors[1].ny = unit[1];
	vectors[1].nz = unit[2];
	vectors[1].nw = 1.0;

	vectors[2].x = third[0];
	vectors[2].y = third[1];
	vectors[2].z = third[2];
	vectors[2].w = 1.0;

	unit[0] = third[0];
	unit[1] = third[1];
	unit[2] = third[2];
	unitlength(display, context, unit);
	vectors[2].nx = unit[0];
	vectors[2].ny = unit[1];
	vectors[2].nz = unit[2];
	vectors[2].nw = 1.0;

	num_of_vectors = 3;
	for(i=0;i<num_of_vectors;i++){
	j=i;
	vertices[i].x=vectors[j].x;
	vertices[i].y=vectors[j].y;
	vertices[i].z=vectors[j].z;

	normals[i].x=vectors[j].nx;
	normals[i].y=vectors[j].ny;
	normals[i].z=vectors[j].nz;
	}
	negate = 0;
	flags = 0;
        PexFillAreaWithData(pexi,Convex,RgbFloat,SurfaceEdgeSolid,num_of_vectors,
	vertices,normals,NULL,NULL,NULL);
}

/*
 * Calculates the mid-point between two points. The "return" values
 * are the globally defined variables x, y, and z.
 */
midpoint(first, second, middle)
float	first[3], second[3], middle[3];
{
float mid_cord[3];		/* mid point of the chord */ 
float mid_cord_r;		/* distance from the center to mid point */
float ratio;			/* ratio of mid_cord_r to sphere radius */

	middle[0] = (first[0] + second[0]) / 2;
	middle[1] = (first[1] + second[1]) / 2;
	middle[2] = (first[2] + second[2]) / 2;
	unitlength(display, context, middle);
}
static unitlength(a,b,zz)
int *a,*b;
float zz[3];
{
float denom;
double sqrt();
denom=sqrt((zz[0]*zz[0]) +( zz[1]*zz[1]) + (zz[2]*zz[2]));
if (denom!=0.0){
zz[0]/= denom;
zz[1]/= denom;
zz[2]/= denom;
}
}
