/* 
 * miannotext.c - Machine Independant Annotated Text drawing function 
 * 
 * Copyright 1988
 * Center for Information Technology Integration (CITI)
 * Information Technology Division
 * University of Michigan
 * Ann Arbor, Michigan
 *
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby
 * granted, provided that the above copyright notice appear in all
 * copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the names of
 * CITI or THE UNIVERSITY OF MICHIGAN not be used in advertising or
 * publicity pertaining to distribution of the software without
 * specific, written prior permission.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS." CITI AND THE UNIVERSITY OF
 * MICHIGAN DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN
 * NO EVENT SHALL CITI OR THE UNIVERSITY OF MICHIGAN BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

#include <stdio.h>
#include "X.h"
#include "pixmap.h"
#include "gcstruct.h"
#include "extnsionst.h"
#include "dix.h"
#include "dixstruct.h"
#include "resource.h"
#include "colormap.h"

#include "PEX.h"
#include "PEXproto.h"
#include "pubstr.h"
#include "annotext.h"
#include "renderer.h"
#include "colortable.h"
#include "mipex.h"

/*****************************************************************
 * TAG( miPexAnnotatedText3D )
 * 
 * Draws annotated text through X Windows calls to maintain compatibility
 * with X machines which have no PEX dd layer.
 * 
 * Inputs:
 * 	pRend - ptr to a renderer
 * 	pStuff - ptr to an annotated text struct
 * Outputs:
 * 	an integer error code or zero.
 * Assumptions:
 *	[None]
 * Algorithm:
 *	[None]
 */

int
miPexAnnotationText(pRend, pStuff)
    pexRendererPtr pRend;
    pexAnnotationTextPtr pStuff;
{
    pexCoord3D orig;	        /* unTransformed coord stored here */
    pexCoord4D pt1;	        /* Transformed coord stored here */
    INT16 x, y;           	/* dd coordinates */
    int length;                 /* length of string */
    int vis;                    /* true if point is visible */
    int change1, change2;       /* clip kludge; use line clip function */
    DrawablePtr pDraw;
    GCPtr pGC;
    Pixel index;

    pDraw = pRend->pDraw;
    pGC =  pRend->pGC;

    orig.x = pStuff->origin.x + pStuff->offset.x;
    orig.y = pStuff->origin.y + pStuff->offset.y;
    orig.z = pStuff->origin.z + pStuff->offset.z;
	
    /* Transform to NPC space */
    PexTransformPoint( pRend, &orig, &pt1 );

    /* clipping kludge: don't have time to write a "clip point" routine, so
     * use the clip line routine already available and send it the same point
     * for both endpoints. Ignore change1 and change2 paramaters, as they are
     * only relevant for lines.     */
    /* Clip against NPC sub-volume */
    vis = PexClipLine( &pt1, &pt1, &change1, &change2 );

    if( vis )
    {
	/* Do the perspective divide */
	if( pt1.w != 1.0 )
	{
	    pt1.x /= pt1.w;
	    pt1.y /= pt1.w;
	}
	
	/* Transform to physical device coordinates */
	PexTransformNpcToDev( pRend, pt1.x, pt1.y, &x, &y );

	miPexSetGCLineValue(pGC, pDraw,
			    pRend->pPC->textColor.color.format.indexed.index,
			    index);

	/* Draw the text on the display */
	length = pStuff->string.length;
	(*GetGCValue(pGC, PolyText8)) (pDraw, pGC, x, y, length,
				       (char *) (pStuff + 1));
    }
    return (Success);
}
