/* 
 * validate.c - machine independant function to validate a renderer
 * 
 * Copyright 1988
 * Center for Information Technology Integration (CITI)
 * Information Technology Division
 * University of Michigan
 * Ann Arbor, Michigan
 *
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby
 * granted, provided that the above copyright notice appear in all
 * copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the names of
 * CITI or THE UNIVERSITY OF MICHIGAN not be used in advertising or
 * publicity pertaining to distribution of the software without
 * specific, written prior permission.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS." CITI AND THE UNIVERSITY OF
 * MICHIGAN DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN
 * NO EVENT SHALL CITI OR THE UNIVERSITY OF MICHIGAN BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */
/*****************************************************************
 * TAG( DDPEXValidate )
 * 
 * Takes a pointer to a renderer and fills in the procedure vector.
 * Also gets a GC and validates it as well.
 * 
 * Inputs:
 * 	a pointer to a renderer to be validated
 * Outputs:
 * 	the renderer pointed to by the input ptr is validated.
 * Assumptions:
 * 	...
 * Algorithm:
 * 	...
 */

#include <stdio.h>
#include "pubstr.h"
#include "renderer.h"
#include "pexmisc.h"
#include "validate.h"
#include "colortable.h"

#define ZBuffering (pRend->HLHSRMode == HlhsrZBuffer)
#define WireFrame (pPC->interiorStyle == InteriorStyleHollow)
#define SmoothShadeing (pPC->surfaceInterp == SurfaceInterpColor)

#define SetShadeVectors(pRend)\
if (WireFrame)\
{\
    pRend->QuadMesh3D = miPexQuadMesh3DWire;\
    pRend->Polygon3D = miPexPolygon3DWire;\
    pRend->QuadMesh2DFlat = NULL;\
    pRend->QuadMesh2DSmooth = NULL;\
    pRend->NurbSurface = mipexNurbSurface3DFlat;\
}\
else if (ZBuffering)\
    if (SmoothShadeing)\
{\
    pRend->QuadMesh3D = miPexQuadMesh3DHide;\
    pRend->Polygon3D = miPexPolygon3DSmooth;\
    pRend->QuadMesh2DFlat = miPexQuadMesh2DFlatHide;\
    pRend->QuadMesh2DSmooth = miPexQuadMesh2DSmoothHide;\
    pRend->NurbSurface = mipexNurbSurface3DSmooth;\
}\
else\
{\
    pRend->QuadMesh3D = miPexQuadMesh3DHide;\
    pRend->Polygon3D = miPexPolygon3DFlat;\
    pRend->QuadMesh2DFlat = miPexQuadMesh2DFlatHide;\
    pRend->QuadMesh2DSmooth = miPexQuadMesh2DFlatHide;\
    pRend->NurbSurface = mipexNurbSurface3DFlat;\
    }\
else\
    if (SmoothShadeing)\
{\
    pRend->QuadMesh3D = miPexQuadMesh3DSmooth;\
    pRend->Polygon3D = miPexPolygon3DSmooth;\
    pRend->QuadMesh2DFlat = NULL;\
    pRend->QuadMesh2DSmooth = NULL;\
    pRend->NurbSurface = mipexNurbSurface3DSmooth;\
}\
else\
{\
    pRend->QuadMesh3D = miPexQuadMesh3DFlat;\
    pRend->Polygon3D = miPexPolygon3DFlat;\
    pRend->QuadMesh2DFlat = NULL;\
    pRend->QuadMesh2DSmooth = NULL;\
    pRend->NurbSurface = mipexNurbSurface3DFlat;\
}



void
miPexValidate(pRend, RDMask, TheirPCMask)
    register pexRendererPtr pRend;
    CARD32 RDMask, TheirPCMask[2];
{
    register pexPipelineContextPtr pPC;
    CARD32 PCMask[2];
    Bool setShadeVectors = FALSE;

    extern FUNCTION miPexPolyline3D;
    extern FUNCTION miPexPolygon3DWire;
    extern FUNCTION miPexPolygon3DFlat;
    extern FUNCTION miPexPolygon3DSmooth;
    extern FUNCTION miPexAnnotationText;
    extern FUNCTION miPexQuadMesh3DWire;
    extern FUNCTION miPexQuadMesh3DFlat;
    extern FUNCTION miPexQuadMesh3DSmooth;
    extern FUNCTION miPexQuadMesh3DHide;
    extern FUNCTION miPexQuadMesh2DFlatHide;
    extern FUNCTION miPexQuadMesh2DSmoothHide;
    extern FUNCTION miPexBeginStructure;
    extern FUNCTION miPexEndStructure;
    extern FUNCTION mipexNurbCurve3D;
    extern FUNCTION mipexNurbSurface3DFlat;
    extern FUNCTION mipexNurbSurface3DSmooth;

    PCMask[0] = TheirPCMask[0];
    PCMask[1] = TheirPCMask[1];

    /*
     * Declare procedure vector functions here...
     */
    
    if (!pRend)
	return;		/* like whats the point */
    else
	pPC = pRend->pPC;

    /*
     * do all the things that don't change and which only get done once
     */
    
    if (PCAllValuesChanged)
    {
	pRend->Polyline3D = miPexPolyline3D;
	pRend->AnnotationText3D = miPexAnnotationText;
	pRend->BeginStructure = miPexBeginStructure;
	pRend->EndStructure = miPexEndStructure;
	pRend->NurbCurve = mipexNurbCurve3D;
    };

    if (PCLightStateChanged)
    {
	/* make sure none are greater that max light */
    };
    
    if (PCLineColorChanged)
    {
	if (pPC->lineColor.colorType != Indexed)
	    fprintf(stderr, "miValidate: Color Not Indexed! (MeanClient)\n");

	if (pPC->lineColor.color.format.indexed.index >= MAX_PEX_COLOR)
	    pPC->lineColor.color.format.indexed.index = MAX_PEX_COLOR;
    };

    if (PCSurfaceColorChanged)
    {
	if (pPC->surfaceColor.colorType != Indexed)
	    fprintf(stderr, "miValidate: Color Not Indexed! (MeanClient)\n");

	if (pPC->surfaceColor.color.format.indexed.index >= MAX_PEX_COLOR)
	    pPC->surfaceColor.color.format.indexed.index = MAX_PEX_COLOR;
    };

    if (PCTextColorChanged)
    {
	if (pPC->textColor.colorType != Indexed)
	    fprintf(stderr, "miValidate: Color Not Indexed! (MeanClient)\n");

	if (pPC->textColor.color.format.indexed.index >= MAX_PEX_COLOR)
	    pPC->textColor.color.format.indexed.index = MAX_PEX_COLOR;
    };

    if (PCReflectionAttrChanged)
    {
	/* normalized these suckers or set them back */
	FLOAT sum = pPC->reflectionAttr.ambient + pPC->reflectionAttr.diffuse
	    + pPC->reflectionAttr.specular;
	
	pPC->reflectionAttr.ambient /= sum;
	pPC->reflectionAttr.diffuse /= sum;
	pPC->reflectionAttr.specular /= sum;
    };

    if (PCInteriorStyleChanged)
	setShadeVectors = TRUE;

    if (PCHlhsrIdentifierChanged)
	setShadeVectors = TRUE;

    if (PCSurfaceInterpChanged)
	setShadeVectors = TRUE;

    if (setShadeVectors)
	SetShadeVectors(pRend);

    /*
      if (PCDistinguishChanged)
	;

    if (PCCullingModeChanged)
	;

    if (PCNormalFlipChanged)
	;

    if (PCLocalTransformChanged)
    {
    }
    if (PCGlobalTransformChanged)
    {
    }
    if (PCViewIndexChanged)
    {
    }
    if (RDViewTableChanged)
    {
    }
    if (RDViewportChanged)
    {
    }
    if (RDHlhsrModeChanged)
    {
    }
    */
}
