/* 
 * dispatcher.c - PEX Dispatcher
 * 
 * Copyright 1988
 * Center for Information Technology Integration (CITI)
 * Information Technology Division
 * University of Michigan
 * Ann Arbor, Michigan
 *
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby
 * granted, provided that the above copyright notice appear in all
 * copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the names of
 * CITI or THE UNIVERSITY OF MICHIGAN not be used in advertising or
 * publicity pertaining to distribution of the software without
 * specific, written prior permission.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS." CITI AND THE UNIVERSITY OF
 * MICHIGAN DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN
 * NO EVENT SHALL CITI OR THE UNIVERSITY OF MICHIGAN BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

#include <stdio.h>
#include "X.h"
#include "PEXproto.h"
#include "Xproto.h"
#include "misc.h"
#include "dixstruct.h"
#include "dix.h"
#include "floatconv.h"
#include "PEX.h"

ClientPtr CurrentPexClient;

extern Bool PEXDoesReqHaveFloats[MaxPEXCommand];
extern char *PEXRequestNames[MaxPEXCommand];
extern int
    (* PEXRequestVector[MaxPEXCommand])(),
    (* sPEXRequestVector[MaxPEXCommand])(),
    (* fPEXRequestVector[MaxPEXCommand])(),
    (* sfPEXRequestVector[MaxPEXCommand])();

/*****************************************************************
 * TAG( ProcPEXDispatch )
 * 
 * PEX extension dispatch function. This is called by the X11
 * dispatcher, with requet packets it believes should be processed
 * by PEX.
 *
 * Inputs:
 *	client - this is a PEX request packet which can be of any PEX
 *               request type as defined in PEXproto.h.
 * Outputs:
 *      An int error code or zero.
 * Assumptions:
 *	Any request defined in PEXproto.h will have a field 'opcode'
 *      which specifies the request's type. If the request also contains
 *      floating point numbers in the packet (as designated by an entry
 *      in PEXDoesReqHaveFloats, in tables.c), we also assume a field
 *      called 'format' which specifies the floating point format.
 * Algorithm:
 *	First, check the opcode. Then, if we have floats and the float
 *      format is different from our float format, use the f procedure
 *      vector. Otherwise, use the normal procedure vector.
 */

int
ProcPEXDispatch( client )
    ClientPtr client;
{
    REQUEST(pexReq);
  
    if ((stuff->opcode < 1) || (stuff->opcode > MaxPEXCommand))
	return (BadRequest);

/*
    fprintf(stdout,"ProcPEXDispatch - %d - %s%s\n",
	    stuff->opcode,
	    ((PEXDoesReqHaveFloats[stuff -> opcode] &&
	     (MyFloatType != stuff -> format.fpFormat)) ? "[f] " : "[] "),
	    PEXRequestNames[stuff->opcode]);
*/

    CurrentPexClient = client;  /* Some routines want access to this */
	
    if (PEXDoesReqHaveFloats[stuff -> opcode] &&
	(MyFloatType != stuff -> format.fpFormat))
	return ((*fPEXRequestVector[stuff -> opcode]) (stuff) );
    else
	return ((*PEXRequestVector[stuff -> opcode]) (stuff) );
}


/*****************************************************************
 * TAG( sProcPEXDispatch )
 * 
 * PEX extension dispatch function. This is called by the X11
 * dispatcher, with requet packets it believes should be processed
 * by PEX. This routine differs from the above in that the X11
 * dispatcher calls either this function or the above function 
 * depending on whether byte swapping is required, or not,
 * respectively. This function then uses procedure vectors which
 * point to functions set up to do byte swapping.
 *
 * Inputs:
 *	client - this is a PEX request packet which can be of any PEX
 *               request type as defined in PEXproto.h.
 * Outputs:
 *      An int error code or zero.
 * Assumptions:
 *	Any request defined in PEXproto.h will have a field 'opcode'
 *      which specifies the request's type. If the request also contains
 *      floating point numbers in the packet (as designated by an entry
 *      in PEXDoesReqHaveFloats, in tables.c), we also assume a field
 *      called 'format' which specifies the floating point format.
 * Algorithm:
 *	First, check the opcode. Then, if we have floats and the float
 *      format is different from our float format, use the f procedure
 *      vector. Otherwise, use the normal procedure vector.
 */

#include "swapmacros.h"

int
sProcPEXDispatch( client )
    ClientPtr client;
{
    CARD16 fpFormat;
    REQUEST(pexReq);


    if ((stuff->opcode < 1) || (stuff->opcode > MaxPEXCommand))
	return (BadRequest);

/*
    fprintf(stdout,"sProcPEXDispatch - %d - ", stuff->opcode);
*/
    
    CurrentPexClient = client;  /* Some routines want access to this */

    if (PEXDoesReqHaveFloats[stuff -> opcode])
    {
	swapshortc(stuff->format.fpFormat, fpFormat);
/*	fprintf(stdout, "%s%s\n",
		((MyFloatType != fpFormat) ? "[sf] " : "[s] "),
		PEXRequestNames[stuff->opcode]);
*/	if (MyFloatType != fpFormat) 
	    return ((*sfPEXRequestVector[stuff -> opcode]) (stuff) );
    }
    /*
     * if we have dropped through to here, either there are no floats in the
     * packet or there are floats but the formats are the same.  We use the
     * plain byte-swapped procedure in either case.
     */

/*    fprintf(stdout, "%s%s\n",
	    "[s] ",
	    PEXRequestNames[stuff->opcode]);
*/    return ((*sPEXRequestVector[stuff -> opcode]) (stuff) );
}

