/* 
 * alphamat.h - Data structures for NURBS evaluation
 * 
 * Copyright 1988
 * Center for Information Technology Integration (CITI)
 * Information Technology Division
 * University of Michigan
 * Ann Arbor, Michigan
 *
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby
 * granted, provided that the above copyright notice appear in all
 * copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the names of
 * CITI or THE UNIVERSITY OF MICHIGAN not be used in advertising or
 * publicity pertaining to distribution of the software without
 * specific, written prior permission.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS." CITI AND THE UNIVERSITY OF
 * MICHIGAN DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN
 * NO EVENT SHALL CITI OR THE UNIVERSITY OF MICHIGAN BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

#include "pexarray.h"

/*****************************************************************
 * TAG( alpha_mat alpha_col )
 *
 * Alpha matrix data structure.  Represents a diagonal slice of an NxM
 * matrix, with each column containing at most K (=order of spline)
 * non-zero entries.  Each column has an offset (colstart) and a
 * length, denoting the starting position within the colum of the
 * non-zero entries, and the number of non-zero entries.
 */

typedef struct _alpha_col {
    int		colstart;	/* First non-zero column element */
    int		length;		/* Number of non-zero elements */
    FLOAT	val[1];		/* array[order] of non-zero elements */
} alpha_col;

typedef struct _alpha_mat {
    int		width, order;	/* number of columns, spline order */
    /* Variable length array descriptors */
    CARD32	colStride;	/* Size of each column */
    CARD32	colOffset;	/* Offset from beginning of struct to first */
} alpha_mat;

/*****************************************************************
 * TAG( alpha_mat_col )
 *
 * Data access macros for the alpha matrix.
 *
 * Inputs:
 * 	pmat:		Pointer to the alpha matrix.
 * 	n:		Column index.
 * 	data:		Type of data requested (must be col)
 * Outputs:
 * 	pointer to data field.
 * Assumptions:
 * 	n must be bounded correctly (0 <= n < width)
 *
 * Algorithm:
 * 	simple pointer arithmetic.
 * 
 */

#define alpha_mat_col(pmat, n)\
    (alpha_col *) Pex1DData(pmat, n, col)
#define alpha_mat_next(pmat, pelt)\
    (alpha_col *) Pex1DDataNext(pmat, pelt, col)
