/* 
 * Slate.h - Public header file for Slate widget.
 * 
 * Copyright 1988
 * Center for Information Technology Integration (CITI)
 * Information Technology Division
 * University of Michigan
 * Ann Arbor, Michigan
 *
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby
 * granted, provided that the above copyright notice appear in all
 * copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the names of
 * CITI or THE UNIVERSITY OF MICHIGAN not be used in advertising or
 * publicity pertaining to distribution of the software without
 * specific, written prior permission.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS." CITI AND THE UNIVERSITY OF
 * MICHIGAN DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN
 * NO EVENT SHALL CITI OR THE UNIVERSITY OF MICHIGAN BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

#ifndef _Slate_h
#define _Slate_h

/*****************************************************************
 *
 * Slate Widget
 * 
 */

/* Parameters:

 Name		     Class		RepType		Default Value
 ----		     -----		-------		-------------
 background	     Background		pixel		White
 border		     BorderColor	pixel		Black
 borderWidth	     BorderWidth	int		1
 buttonProc	     Callback		Pointer		NULL
 destroyCallback     Callback		Pointer		NULL
 font		     Font		FontStruct	fixed
 foreground	     Color		pixel		Black
 highlight	     Color		pixel		Red
 depthCue	     Color		pixel		LightGray
 keyProc	     Callback		Pointer		NULL
 label		     Label		String		NULL
 mappedWhenManaged   MappedWhenManaged	Boolean		True
 redisplayProc	     Callback		Pointer		NULL
 resizeProc	     Callback		Pointer		NULL
 mapProc	     Callback		Pointer		NULL
 slateCursor	     Cursor		Cursor		XC_sb_left_arrow
 sensitive	     Sensitive		Boolean		True
 labelX		     Position		int		0
 Labely		     Position		int		0

*/

#define XtNfont			"font"
#define XtNlabel		"label"
#define XtNlabelX		"labelX"
#define XtNlabelY		"labelY"
#define XtNbuttonProc		"buttonProc"
#define XtNkeyProc		"keyProc"
#define XtNredisplayProc	"redisplayProc"
#define XtNresizeProc		"resizeProc"
#define XtNmapProc		"mapProc"
#define XtNslateCursor		"slateCursor"
#define XtNhighlight		"highlight"
#define XtNdepthCue		"depthCue"

typedef struct _SlateRec       *SlateWidget;
typedef struct _SlateClassRec	*SlateWidgetClass;

extern WidgetClass slateWidgetClass;
#endif _Slate_h
