#include "gfto.h"
/*
 * Copyright 1988 Barry Shein
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of Barry Shein not be used
 * in advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.  Barry Shein makes no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied warranty.
 * 
 * BARRY SHEIN DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL BARRY SHEIN BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * Author:  Barry Shein, Encore Computer Corporation, BZS@ENCORE.COM
 */



/*
 * Diagnostic output routines
 */

#define eputchar(c) (errout != NULL ? putc(c,errout) : EOF)

/*VARARGS1*/
eprintf(fmt,a,b,c,d,e,f,g) char *fmt, *a, *b, *c, *d, *e, *f, *g;
{
  if(errout != NULL)
    fprintf(stderr,fmt,a,b,c,d,e,f,g);
}
fatal(code,msg) int code; char *msg;
{
  eprintf("%s\n",msg);
  exit(code);
}
sysfatal(code,msg) int code; char *msg;
{
  perror(msg);
  exit(code);
}
Usage() {
  int i;

  eprintf("Usage: %s [flags] gffile\n",prog);
  eprintf("Where flags are:\n");
  eprintf("\t-d:\tEnable debugging output\n");
  eprintf("\t-b:\tProduce Adobe BDF file format\n");
  eprintf("\t-c:\tProduce character dump format (asterisks)\n");
  eprintf("\t-F:\tSet family name to string after flag\n");
  eprintf("\t-f:\tSet face name to string after flag\n");
  eprintf("\t-C:\tSet copyright to string after flag\n");
#ifdef POSTSCRIPT
  eprintf("\t-p:\tProduce postscript download file\n");
  eprintf("\t(following with -p)\n");
  eprintf("\t-e:\tbuilt-in encoding name or number:\n");

  for(i=0; TeXcharmaps[i] != NULL; i++)
    eprintf("\t\t'%s'\t%d\n",TeXcharmaps[i]->name,TeXcharmaps[i]->type);

  eprintf("\t-E:\tfile name of font encoding\n");
  eprintf("\t\tformatted (one item per line):\n");
  eprintf("\t\t\tencoding-name\n");
  eprintf("\t\t\tencoding-type (number)\n");
  eprintf("\t\t\tone char name per line for each char in font\n");
#endif POSTSCRIPT
  exit(1);
}
/*
 * Moderately portable routine to get 4 bytes of GF integer
 * and return it in user supplied long ptr.
 * Relies on ntohl() routine to convert from GF Bigendian
 * (which is same as netinet order) to local host format.
 *
 * get3 and get2 are basically the same thing for 3 and 2 byte
 * ints respectively. Get2 uses ntohs(). They all take long ptrs
 * for return values just for consistency's sake, I dunno, bother.
 */
get4(ip,fp) long *ip; FILE *fp;
{
  int i,c;
  char ch[4];
  long *lp;

  for(i=0; i < 4; i++)
    if((c = getc(fp)) == EOF)
      goto bad;
    else
      ch[i] = c;
  lp = (long *) ch;
  *ip = ntohl(*lp);
  return(0);
 bad:
  return(-1);
}
get3(ip,fp) long *ip; FILE *fp;
{
  int i,c;
  char ch[4];
  long *lp;

  ch[0] = ch[1] = ch[2] = ch[3];
  for(i=0; i < 3; i++)
    if((c = getc(fp)) == EOF)
      goto bad;
    else
      ch[i] = c;
  lp = (long *) ch;
  *ip = ntohl(*lp);
  return(0);
 bad:
  return(-1);
}
get2(ip,fp) long *ip; FILE *fp;
{
  int c;
  char ch[2];
  short *sp;

  if((c = getc(fp)) == EOF)
    goto bad;
  ch[0] = c;
  if((c = getc(fp)) == EOF)
    goto bad;
  ch[1] = c;
  sp = (short *) ch;
  *ip = ntohs(*sp);
  return(0);
 bad:
  return(-1);
}

/*
 * Open the GF file doing various magic to help the user.
 *
 *	name:		The name the user gave us.
 *	envname:	An environment variable to look for a path in.
 *	defpath:	A default path to use if no envname
 *	result:		A string buffer to receive the path of the result
 */
FILE *
Fopen(name,envname,defpath,result) char *name, *envname, *defpath, *result;
{
  char *path, *getenv();
  char fname[BUFSIZ];

  /*
   * If there's a slash anywhere in the name use it literally
   */
  if(index(name,'/') == 0) {

    /* See if they've set an environment variable */
    if((path = getenv(envname)) == NULL)
      path = defpath;

    /* ensure it ends in a slash */
    if(path[strlen(path)-1] != '/')
      strcat(path,"/");

    /* build the full path name */
    strcpy(fname,path);
    strcat(fname,name);
    name = fname;
  }

  /* copy into global for later use */
  strcpy(result,name);
  return(fopen(result,"r"));
}

/*
 * Return a ptr to the last part of a pathname
 */
char *
basename(cp) char *cp;
{
  char *sp;

  if((sp = rindex(cp,'/')) == NULL)
    sp = cp;
  else
    sp++;

  return(sp);
}
/*
 * Put out a byte as two hex char nibbles
 */
puthex(n) int n;
{
  putchar("0123456789abcdef"[(n >> 4) & 0xf]);
  putchar("0123456789abcdef"[n & 0xf]);
}
#ifdef POSTSCRIPT
struct TeXcharmap *
readencoding(fname,n) char *fname; int n;
{
  FILE *fp = NULL;
  struct TeXcharmap *chp = NULL;
  char **cpp = NULL;
  char buf[BUFSIZ];
  extern int errno;
  extern char *sys_errlist[];
  int i,j;

  if((fp = fopen(fname,"r")) == NULL) {
    eprintf("readencoding: %s: %s\n",fname,sys_errlist[errno]);
    goto bad;
  }

  /* Get the encoding name */
  if(fgets(buf,BUFSIZ,fp) == NULL) {
    eprintf("readencoding: %s: EOF or Error reading encoding name\n",fname);
    goto bad;
  }
  if(buf[i=strlen(buf)-1] == '\n')
    buf[i] = '\0';

  chp = (struct TeXcharmap *) calloc(1,sizeof(*chp));
  chp->name = (char *) malloc(i+1);
  strcpy(chp->name,buf);

  /* Get the encoding type (integer) */
  if(fgets(buf,BUFSIZ,fp) == NULL) {
    eprintf("readencoding: %s: EOF or Error reading encoding type\n",fname);
    goto bad;
  }
  chp->type = atoi(buf);

  chp->nsyms = n;

  cpp = (char **) calloc(n,sizeof(char *));

  for(i=0; i < n; i++) {
    if(fgets(buf,BUFSIZ,fp) == NULL) {
      eprintf("readencoding: %s: EOF or Error reading character %d\n",
	      fname,i);
      goto bad;
    }
    if(buf[j=strlen(buf)-1] == '\n')
      buf[j] = '\0';
    cpp[i] = (char *) malloc(j+1);
    strcpy(cpp[i],buf);
  }

  chp->syms = cpp;
  return(chp);

 bad:
  /* ugly */
  if(fp != NULL)
    fclose(fp);
  if(chp != NULL) {
    if(chp->name != NULL) {
      free(chp->name);
      free(chp);
    }
  }
  if(cpp != NULL) {
    for(i=0;i<n; i++)
      if(cpp[i] != NULL)
	free(cpp[i]);
      else break;
    free(cpp);
  }
  return(NULL);
}
struct TeXcharmap *
encodingname(name) char *name;
{
  int i;

  for(i=0; TeXcharmaps[i] != NULL; i++)
    if(strcmp(name,TeXcharmaps[i]->name) == 0)
      return(TeXcharmaps[i]);
  return(NULL);
}
struct TeXcharmap *
encodingnumber(num) int num;
{
  int i;

  for(i=0; TeXcharmaps[i] != NULL; i++)
    if(num == TeXcharmaps[i]->type)
      return(TeXcharmaps[i]);
  return(NULL);
}
#endif POSTSCRIPT
